<?php

class ApirequestController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetExpenseHistory','UploadExpense','SaveExpense','EditExpense','GetExpenseApproval','SaveExpenseApproval','getnoticeperiod','SaveResignation','GetResignationApproval',
                    'GetResignationApproval','SaveResignationApproval','CertificateHistory','getdocumentlist','SaveCertificateRequest','GetCertificateApproval','GetCertificateApproval','SaveCertificateApproval',
                    'GetExcuseHistory','SaveExcuseMeeting','DeleteExpense'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "cumulush_2021_hr_bluesky";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return parent::beforeAction($action);
    }
    public function actionGetExpenseHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array["employee_id"];
            EmployeeExpense::model()->updateAll(array('view_status' => 1), 'employee_id="'.$employee_id.'" and view_status="0" and (status="12" OR status="13")');
            $model = EmployeeExpense::model()->findAll(array('condition' => 'employee_id = "'.$employee_id.'"','order'=>'created_date desc'));
            foreach ($model as $key => $value) {
                $created_date=$approved_date='';
                if ($value->created_date!= '' && $value->created_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($value->created_date));
                }
                if ($value->approved_date!= '' && $value->approved_date!= '0000-00-00') {
                    $approved_date= date("d/m/Y", strtotime($value->approved_date));
                }
                $edit_button=0;
                if ($value->status==1) {
                    $edit_button=1;
                }
                $data[] = array(
                    "id" => $value->id,
                    "total" => $value->total,
                    "created_date" => $created_date,
                    "approved_date" => $approved_date,
                    "status"=> EmployeeExpense::getStatus($value->status),
                    'edit_button'=>$edit_button);

            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionUploadExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model_employee = Employee::model()->findbypk($_REQUEST['employee_id']);
            $xpense_name=$model_employee->employeecode.'_'.$_FILES["file"]["name"];
            $folder = Yii::getPathOfAlias('webroot') . '/uploads/expense/'.$xpense_name;
            move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
            $jsonData['filename'] = $xpense_name;
            $jsonData['status'] = 'success';
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($jsonData);
    }
    public function actionSaveExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $user_id   = $userModel->id;
            $validate=true;
            $model  = new EmployeeExpense();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
                $model->updated_by = (int)$user_id;
                $model->updated_date_time =date('Y-m-d H:i:s');
            }else{
                $model->created_by = $user_id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_date = date('Y-m-d');
            }          
            $model->employee_id = $data_array['employee_id'];
            $model->total = $data_array['total'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="7"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;           
            $validate = $model->validate();
            if (is_array($data_array['expensedetails'])) 
            { 
              foreach ($data_array['expensedetails'] as $i => $items) 
                {
                    if((int)$items['id']>0){
                        $modalexpensedetails[$i] = EmployeeExpenseDetails::model()->findByPk((int)$items['id']);
                    }else{
                        $modalexpensedetails[$i] = new EmployeeExpenseDetails();
                    }
                    $modalexpensedetails[$i]->expense_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['expense_date'])));
                    $modalexpensedetails[$i]->notes = $items['notes'];
                    $modalexpensedetails[$i]->employee_id = $data_array['employee_id'];
                    $modalexpensedetails[$i]->amount = $items['amount'];
                    $modalexpensedetails[$i]->file = $items['file'];
                    $validate = $modalexpensedetails[$i]->validate() && $validate;
                }
            }else{
                 $modalexpensedetails = new EmployeeExpenseDetails();
            }
            if($validate){
                $model->save();
                if(!empty($modalexpensedetails)){
                    foreach ($modalexpensedetails as $eachModel) 
                    {
                        $eachModel->expense_id=$model->id;
                        $eachModel->save();
                    }
                }
                //Mail
//                    $model_settings = HrGenerelSettings::model()->find();
//                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="9"'));
//                    if(!empty($model_settings)){
//                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                             Yii::import('application.modules.hr.controllers.MailController');
//                             MailController::sendmail(9,$model->employee_id,$model->id);
//                        }
//                    }
                $data['id'] = $model->id;
                $data['status'] = 'success';
    
            } else {
                $data['status'] = 'error';
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modalexpensedetails, '', false), true);
                if(empty($modalexpensedetails)){
                   $error2[]='Please add atleast one expense item';
                }
                $error = array_merge_recursive($error1, $error2);
                foreach($error as $a=>$eacherror){
                    $other[]= $eacherror[0];
                }      
                if ($error != '[]'){
                    $data['msg'] =implode(',',$other);
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionEditExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            $model = EmployeeExpense::model()->findByPK($id);
            $data['id'] = $model->id;
            $data['employee_id'] = $model->employee_id;
            $data['total'] = $model->total;
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="'.$id.'"'));
            if(!empty($model_details)){
                foreach ($model_details as $i => $each){  
                    $data['items'][] = [
                        "id" => $each->id,
                        "expense_date" =>date('d/m/Y', strtotime($each->expense_date)),
                        "notes" => $each->notes,
                        "amount" =>$each->amount
                    ];
                }
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetExpenseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_expense=EmployeeExpense::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_expense.')';
            $data = [];
            $model = new EmployeeExpense();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'created_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $created_date='';
                if ($value->created_date!= '' && $value->created_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($value->created_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $created_date,
                    "total" => $row->total,
                    "status"=> EmployeeExpense::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveExpenseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeExpense::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                     }
                     $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->status = $status;
                $model->save();
                if($status==12 && $final_level=='Y'){
                    //Mail
//                   $model_settings = HrGenerelSettings::model()->find();
//                   $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="10"'));
//                   if(!empty($model_settings)){
//                       if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                           Yii::import('application.modules.hr.controllers.MailController');
//                           MailController::sendmail(10,$model->employee_id,$model->id);
//                       }
//                   }
                }
                $data['status'] = 'success';
                $data['message'] ='Expense Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Expense Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actiongetnoticeperiod() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $condition = 't.isActive =  "Y"';
            $model = MasNoticeperiod::model()->findAll(array('condition' => $condition,'order'=>'period_name'));
            $data=array();
            foreach ($model as $key => $value) {
                 $data[] = array(
                    "id" => $value->id,
                    "value" => $value->period_name);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionSaveResignation() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeResignation();
            $model->created_by = $user_id;
            $model->created_date_time = date('Y-m-d H:i:s'); 
            $model->employee_id = $data_array['employee_id'];
            $model->reason = $data_array['reason'];
            $model->notice_type = $data_array['notice_type'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="5"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;
            $model->apply_date = date('Y-m-d');
            if ($model->validate()) {
              $model->save();
              //Mail
//              $model_settings = HrGenerelSettings::model()->find();
//              $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="11"'));
//              if(!empty($model_settings)){
//                  if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                       Yii::import('application.modules.hr.controllers.MailController');
//                       MailController::sendmail(11,$model->employee_id,$model->id);
//                  }
//              }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetResignationApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_resignation=EmployeeResignation::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_resignation.')';
            $data = [];
            $model = new EmployeeResignation();
            $model = $model->with('employeedetail', 'noticeperioddetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $created_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $created_date,
                    "noticeperiod" => $row['noticeperioddetail']['period_name'],
                    "status"=> EmployeeResignation::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveResignationApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeResignation::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                    $model->notice_type =$data_array["notice_type"];;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->status = $status;
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="12"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(12,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Resignation Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Resignation Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionCertificateHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 'employee_id="'.$employee_id.'" and mascertificate.apply_from="N"';
            EmployeeCertificate::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (status="12" OR status="13")');
            $model = new EmployeeCertificate();
            $model = $model->with('mascertificate')->findAll(array('condition' => $condition));
            $data = array();
            $m = 1;
            foreach ($model as $value) {
                $download_btn =0;
                if ($value->status==12) {
                    $download_btn=1;
                }
                if ($value->apply_date!= '' && $value->apply_date!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "certificate_name" => $value->mascertificate->certificate_name,
                    "reference_no" => $value->reference_no,
                    "apply_date" => $apply_date,
                    "status"=>EmployeeCertificate::getStatus($value->status),
                    "download_btn" => $download_btn);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actiongetdocumentlist() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $condition = 't.isActive =  "Y" and apply_from="N"';
            $model = MasCertificate::model()->findAll(array('condition' => $condition,'order'=>'certificate_name'));
            $data=array();
            foreach ($model as $key => $value) {
                 $data[] = array(
                    "id" => $value->id,
                    "value" => $value->certificate_name);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionSaveCertificateRequest() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeCertificate();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
            }else{
                $model->apply_date = date('Y-m-d');
            }        
            $model->employee_id = $data_array['employee_id'];
            $model->certificate_id = $data_array['certificate_id'];
            $model->apply_notes = $data_array['apply_notes'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="4"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;
            if ($model->validate()) {
                $model->save();
            //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="18"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(18,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetCertificateApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_certificates=EmployeeCertificate::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level And t.id IN('.$pending_certificates.')';
            $data = [];
            $model = new EmployeeCertificate();
            $model = $model->with('employeedetail', 'mascertificate','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $created_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $created_date,
                    "certificate_name" => $row->mascertificate->certificate_name,
                    "status"=> EmployeeCertificate::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveCertificateApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeCertificate::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->status = $status;
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="19"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(19,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Certificate Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Certificate Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionDownloadCertificate() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $model_certificate = EmployeeCertificate::model()->findByPk($id);
            $path = Yii::getPathOfAlias('webroot') . "/uploads/certificate/".$model_certificate->certificate_document;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            EmployeeCertificate::model()->updateByPK($id, array('status' => 14));
            Yii::app()->end();
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
            echo json_encode($data);
        }
    }
    public function actionGetExcuseHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $model = EmployeeLeaveExcuse::model()->findAll(array('condition' => 'employee_id = "'.$employee_id.'"','order'=>'request_date desc'));
            $arr_type= array(1=>'Meeting',2=>'Excuse');
            foreach ($model as $key => $value) {
                $request_date='';
                if ($value->request_date!= '' && $value->request_date!= '0000-00-00') {
                    $request_date = date("d/m/Y", strtotime($value->request_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "type" => $arr_type[$value->type],
                    "request_date" => $request_date,
                    "customer_name" => $value->customer_name,
                    'excuse_reason'=>$value->excuse_reason);

            }
            if(empty($data)){
                $data[] = ["excuse_reason" =>'No Data Available',];
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        
        echo json_encode($data);
    }
    public function actionSaveExcuseMeeting() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeLeaveExcuse();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
                $model->updated_by = $user_id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by = $user_id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }      
            $model->employee_id = $data_array['employee_id'];
            $model->type = $data_array['type'];
            $model->customer_name = $data_array['customer_name'];
            $model->excuse_reason = $data_array['excuse_reason'];
            $model->start_time = $data_array['start_time'];
            $model->end_time = $data_array['end_time'];
            $model->status = 1;
            if ($data_array['request_date'] != '0000-00-00' && $data_array['request_date'] != '') {
                $model->request_date = date("Y-m-d", strtotime(str_replace('/', '-',$data_array['request_date'])));
            }
            if ($model->validate()) {
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="20"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(20,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionDeleteExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST['id'];
            $model = EmployeeExpenseDetails::model()->findbyPK($id);
            $path = '';
            if ($model->file != '') {
                $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $model->file;
            }
            $status = $model->deleteByPk($id);
            if ($status == 1) {
                if (file_exists($path)) {
                    unlink($path);
                }
                $data['status'] = 'success';
            } else {
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo CJSON::encode($data);
    }
}
