<?php

class ApipaymentController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('AdvanceApplyStatus','GetAdvanceHistory','SaveAdvance','GetAdvanceApproval','SaveAdvanceApproval','deletesalaryadvance','EditAdvance',
                    'LoanApplyStatus','GetLoanHistory','SaveLoan','EditLoan','deleteloandetail','GetLoanApproval','SaveLoanApproval'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "cumulush_2021_hr_bluesky";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return parent::beforeAction($action);
    }
    public function actionAdvanceApplyStatus() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $data['apply_btn']=0;
            $data['monthly_salary']=0;
            $model_details_pending = EmployeeSalaryAdvance::model()->findAll(array('condition'=>'employee_id="'.$employee_id.'" and (advance_payment_status = "1" or advance_payment_status = "2" or advance_payment_status = "4" or advance_payment_status = "6" or advance_payment_status = "8" or advance_payment_status = "10" or advance_payment_status = "12" or advance_payment_status = "14" or advance_payment_status = "15")'));
            if(empty($model_details_pending)){
                $data['apply_btn']=1;
            }
            $current_date = date('Y-m-d');
            $condition = 'employee_id="'.$employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
            if($model_salary->amount>0){
                $data['monthly_salary'] = $model_salary->amount;
            }
        }
        echo json_encode($data);
    }
    public function actionGetAdvanceHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            EmployeeSalaryAdvance::model()->updateAll(array('view_status' =>1), 'employee_id="'.$employee_id.'" and view_status="0" and (advance_payment_status="12" OR advance_payment_status="13")');
            $model = EmployeeSalaryAdvance::model()->findAll(array('condition' => 'employee_id = "'.$employee_id.'"','order'=>'apply_date desc'));
            foreach ($model as $key => $value) {
                $created_date=$approved_date='';
                if ($value->apply_date!= '' && $value->apply_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($value->apply_date));
                }
                if ($value->approved_date!= '' && $value->approved_date!= '0000-00-00') {
                    $approved_date= date("d/m/Y", strtotime($value->approved_date));
                }
                $edit_button=0;
                if ($value->advance_payment_status==1) {
                    $edit_delete_button=1;
                }
                $data[] = array(
                    "id" => $value->id,
                    "amount" => $value->amount,
                    "balance_amount" => ($value->amount-$value->amount_paid),
                    "apply_date" => $created_date,
                    "approved_date" => $approved_date,
                    "status"=> EmployeeSalaryAdvance::getStatus($value->advance_payment_status),
                    'edit_delete_button'=>$edit_delete_button,
                    'msg' => "");

            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[]= array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveAdvance() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeSalaryAdvance();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
            }else{
                $model->apply_date = date('Y-m-d');
            }        
            $model->employee_id = $data_array['employee_id'];
            $model->payment_note = $data_array['payment_note'];
            $model->amount = $data_array['amount'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="3"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->advance_payment_status =1;
            if ($model->validate()) {
              $model->save();
              //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="16"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                        Yii::import('application.modules.hr.controllers.MailController');
//                        MailController::sendmail(16,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetAdvanceApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_salaryadvance=EmployeeSalaryAdvance::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_salaryadvance.')';
            $data = [];
            $model = new EmployeeSalaryAdvance();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $apply_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $current_date = date('Y-m-d');
                $condition = 'employee_id="'.$employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
                $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $apply_date,
                    "monthly_salary" => $model_salary->amount,
                    "amount" => $row->amount,
                    "status"=> EmployeeSalaryAdvance::getStatus($row->advance_payment_status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveAdvanceApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeSalaryAdvance::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->advance_payment_status = $status;
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="17"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(17,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Salary Advance Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Salary Advance Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actiondeletesalaryadvance(){     
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            if($id>0){            
               EmployeeSalaryAdvance::model()->deleteByPk($id);
               $data = array('status' => "success", "msg"=>"Deleted Successfully"); 
            }else{
                $data = array('status' => "error", "msg"=>"ID Error "); 
            }  
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionEditAdvance()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            $model = EmployeeSalaryAdvance::model()->findByPK($id);
            $data['id'] = $model->id;
            $data['employee_id'] = $model->employee_id;
            $data['payment_note'] = $model->payment_note;
            $data['amount'] = $model->amount;
            $current_date = date('Y-m-d');
            $condition = 'employee_id="'.$model->employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
            if($model_salary->amount>0){
                $data['monthly_salary'] = $model_salary->amount;
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);    
    }
    //Loan
    public function actionLoanApplyStatus() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $data['apply_btn']=0;
            $model_details_pending = EmployeeLoanDetail::model()->findAll(array('condition'=>'employee_id="'.$employee_id.'" and (loan_status = "1" or loan_status = "2" or loan_status = "4" or loan_status = "6" or loan_status = "8" or loan_status = "10" or loan_status = "12" or loan_status = "14" or loan_status = "15")'));
            if(empty($model_details_pending)){
                $data['apply_btn']=1;
            }
        }
        echo json_encode($data);
    }
    public function actionGetLoanHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            EmployeeLoanDetail::model()->updateAll(array('view_status' =>1), 'employee_id="'.$employee_id.'" and view_status="0" and (loan_status="12" OR loan_status="13")');
            $model = EmployeeLoanDetail::model()->findAll(array('condition' => 'employee_id = "'.$employee_id.'"','order'=>'apply_date desc'));
            foreach ($model as $key => $value) {
                $created_date=$approved_date='';
                if ($value->apply_date!= '' && $value->apply_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($value->apply_date));
                }
                if ($value->approved_date!= '' && $value->approved_date!= '0000-00-00') {
                    $approved_date= date("d/m/Y", strtotime($value->approved_date));
                }
                $edit_button=0;
                if ($value->loan_status==1) {
                    $edit_delete_button=1;
                }
                $data[] = array(
                    "id" => $value->id,
                    "loan_amount" => $value->loan_amount,
                    "loan_monthly_payment" => $value->loan_monthly_payment,
                    "loan_total_installment" => $value->loan_total_installment,
                    "balance_amount" => ($value->loan_amount-$value->loan_repayment),
                    "apply_date" => $created_date,
                    "approved_date" => $approved_date,
                    "status"=> EmployeeLoanDetail::getLoanStatus($value->loan_status),
                    'edit_delete_button'=>$edit_delete_button,
                    'msg' => "");

            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[]= array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveLoan() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeLoanDetail();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
            }else{
                $model->apply_date = date('Y-m-d');
            }        
            $model->employee_id = $data_array['employee_id'];
            $model->loan_amount = $data_array['loan_amount'];
            $model->employee_id = $data_array['employee_id'];
            $model->proposed_installment = $data_array['proposed_installment'];
            $model->proposed_monthly_installment = $data_array['proposed_monthly_installment'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="2"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->loan_status =1;
            if ($model->validate()) {
              $model->save();
               //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="14"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(14,$modelloan->employee_id,$modelloan->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionEditLoan()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            $model = EmployeeLoanDetail::model()->findByPK($id);
            $data['id'] = $model->id;
            $data['loan_amount'] = $model->loan_amount;
            $data['proposed_installment'] = $model->proposed_installment;
            $data['proposed_monthly_installment'] = $model->proposed_monthly_installment;
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);    
    }
    public function actiondeleteloandetail(){     
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            if($id>0){            
               EmployeeLoanDetail::model()->deleteByPk($id);
               $data = array('status' => "success", "msg"=>"Deleted Successfully"); 
            }else{
                $data = array('status' => "error", "msg"=>"ID Error "); 
            }  
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetLoanApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_loans=EmployeeLoanDetail::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_loans.')';
            $data = [];
            $model = new EmployeeLoanDetail();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $apply_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $apply_date,
                    "loan_amount" => $row->loan_amount,
                    'proposed_installment'=> $row->proposed_installment,
                    "proposed_monthly_installment"=> $row->proposed_monthly_installment,
                    "loan_monthly_payment" => $row->loan_monthly_payment,
                    "loan_total_installment" => $row->loan_total_installment,
                    "status"=> EmployeeLoanDetail::getLoanStatus($row->loan_status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveLoanApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $loan_monthly_payment = $data_array["loan_monthly_payment"];
            $loan_total_installment = $data_array["loan_total_installment"];
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeLoanDetail::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                    $model->loan_monthly_payment =$loan_monthly_payment;
                    $model->loan_total_installment =$loan_total_installment;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->loan_status = $status;
                if ($model->validate()) {
                    $model->save();
                    //Mail
    //                $model_settings = HrGenerelSettings::model()->find();
    //                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="15"'));
    //                if(!empty($model_settings)){
    //                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
    //                         Yii::import('application.modules.hr.controllers.MailController');
    //                         MailController::sendmail(15,$model->employee_id,$modelloan->id);
    //                    }
    //                }
                    $data['status'] = 'success';
                    $data['message'] ='Loan Details Updated Successfylly';
                }else{
                    $errors = $model->errors; 
                    $arr_err=array();
                    foreach ($model->errors as $t=>$value) {
                        $arr_err[]=$value[0];
                    }
                    $data=array('status' => 'error','message'=>$arr_err);
                }
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Loan Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
}
