<?php
class ApileaveController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'Login', 'logout', 'error', 'SaveAppliedLeave', 'UploadDocument', 'GetLeaveforApproval', 'GetLeaveHistory', 'SaveApprovedLeave', 'SaveleaveCancel', 'SaveCancelledLeave', 'Saveleavedelete', 'EditLeave', 'LeaveTypes','GetPreviousLeaveHistory',
                    'GetleaveDays', 'GetLeaveforApprovalHistory'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        //for db connection added by Nisha on 21-03-2023
        $this->ChangeDB();
        return true;
    }

    public function actionSaveAppliedLeave() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $model = new EmployeeLeaveDetail();
            if (isset($data_array)) {
                if ((int) @ $data_array['id'] > 0) {
                    $model->id = (int) $data_array['id'];
                    $model->scenario = 'update';
                    $model = EmployeeLeaveDetail::model()->findByPK($data_array['id']);
                    $model->updated_by = $userModel->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model->scenario = 'add';
                    $model->apply_date = date('Y-m-d');
                    $model->apply_by = $userModel->id;
                    $model->created_by = $userModel->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                $model->attributes = $data_array;
                //Approval Level
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $data_array["employee_id"] . '" and functionality_id="1"'));
                $functiontype = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
                ;
                $model->function_type = $functiontype;
                $model->last_approved_level = 0;
                $model->normal_leave = $data_array['normal_leave'];
                $model->medical_certificate = $data_array['medical_certificate'];
                $model->salary_deduction_leave = $data_array['salary_deduction_leave'];
                if ($data_array['leave_start_date'] != '0000-00-00' && $data_array['leave_start_date'] != '') {
                    $model->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $data_array['leave_start_date'])));
                }
                if ($data_array['leave_end_date'] != '0000-00-00' && $data_array['leave_end_date'] != '') {
                    $model->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $data_array['leave_end_date'])));
                }
                if (isset($data_array['medical_certificate']) && $data_array['medical_certificate'] != '') {
                    $model->medical_certificate = $data_array['medical_certificate'];
                }
                $ticket_applied = $data_array['ticket_applied'];
                if ($ticket_applied == 1) {
                    $model->travel_destination = $data_array['travel_destination'];
                    if ($data_array['travel_date'] != '0000-00-00' && $data_array['travel_date'] != '') {
                        $model->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $data_array['travel_date'])));
                    }
                    $model->return_destination = $data_array['return_destination'];
                    if ($data_array['return_date'] != '0000-00-00' && $data_array['return_date'] != '') {
                        $model->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $data_array['return_date'])));
                    }
                }
                $model->leave_status = 1;
                if ($model->validate()) {
                    $model->save();
                    //Ticket
                    if ($ticket_applied == 1) {
                        $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                        if (!empty($model_tkt)) {
                            $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                            $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                            $model_tkt_1->updated_by = $userModel->id;
                            $model_tkt_1->save();
                        } else {
                            $model_tkt_1 = new EmployeeTicket();
                            $model_tkt_1->employee_id = $model->employee_id;
                            $model_tkt_1->travel_date = $model->travel_date;
                            $model_tkt_1->travel_destination = $model->travel_destination;
                            $model_tkt_1->return_date = $model->return_date;
                            $model_tkt_1->return_destination = $model->return_destination;
                            $model_tkt_1->leave_id = $model->id;
                            $model_tkt_1->leave_type = $model->leave_type;
                            $model_tkt_1->date_apply = date('Y-m-d');
                            $model_tkt_1->status = 1;
                            $model_tkt_1->year = date('Y', strtotime($model->leave_end_date));
                            $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                            $model_tkt_1->created_by = $userModel->id;
                            //Approval Level
                            /*   $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$model->employee_id.'" and functionality_id="11"')); 
                              $model_tkt_1->function_type =$model_master_approve_setting->id;
                              $model_tkt_1->last_approved_level =0; */
                            $model_tkt_1->save();
                        }
                        //Mail
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="9"'));
                        /* if (!empty($model_settings)) {
                          if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                          Yii::import('application.modules.hr.controllers.MailController');
                          MailController::sendmail(9, $model_tkt_1->employee_id, $model_tkt_1->id);
                          }
                          } */
                    } else {
                        $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                        if (!empty($model_tkt)) {
                            EmployeeTicket::model()->deleteByPK($model_tkt->id);
                        }
                    }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="1"'));
                    /*
                      if (!empty($model_settings)) {
                      if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                      Yii::import('application.modules.hr.controllers.MailController'); 
                      MailController::sendmail(1, $model->employee_id, $model->id);
                      }
                      } */
                    $model_leave_notification_approval = $this->getnotificationapproval($model->id, 1);
                    $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                } else {
                    $errors = $model->errors;
                    $arr_err = array();
                    foreach ($model->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => 'error', 'msg' => "Input parameters missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actionGetLeaveHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $condition = 'employee_id="' . $employee_id . '" and YEAR(leave_start_date)>="' . date('Y') . '"';
            //Updating Notification Status
            EmployeeLeaveDetail::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (leave_status="12" OR leave_status="13")');
            EmployeeLeaveDetail::model()->updateAll(array('hr_cancel_view_status' => 1), 'employee_id="' . $employee_id . '" and lm_cancel_view_status="0" and (leave_status="25" OR leave_status="26")');
            //End Updation

            $model = new EmployeeLeaveDetail();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'order' => 'leave_start_date desc'));
            foreach ($model as $key => $value) {
                $leave_start_date = $leave_end_date = '';
                if ($value->leave_start_date != '' && $value->leave_start_date != '0000-00-00') {
                    $leave_start_date = date("d/m/Y", strtotime($value->leave_start_date));
                }
                if ($value->leave_end_date != '' && $value->leave_end_date != '0000-00-00') {
                    $leave_end_date = date("d/m/Y", strtotime($value->leave_end_date));
                }
                $button_cancel = $button_edit = $button_delete = 'N';
                if ($value->leave_status == 1) {
                    $button_delete = 'Y';
                    $button_edit = 'Y';
                }
                if ($value->leave_status == 12) {
                    $button_cancel = 'Y';
                }
                $model_general_setting = HrGenerelSettings::model()->find();
                $lock_attendance_leave = $model_general_setting->lock_attendance_leave;
                if ($value->leave_status == 12) {
                    $approved_year = date("Y", strtotime($value->approved_date));
                    $leave_current_year = date("Y");
                    if ($approved_year == $leave_current_year) {
                        $button_cancel = 'Y';
                        if ($lock_attendance_leave == "Y" && strtotime($value->leave_start_date) > strtotime($last_locked_date) && strtotime($value->leave_start_date) >= strtotime(date("Y-m-d")) && $value->leave_status == 12 && $value->status_cancel == 0) {
                            $button_cancel = 'Y';
                        } else if ($lock_attendance_leave == "N" && strtotime($value->leave_start_date) >= strtotime(date("Y-m-d")) && $value->leave_status == 12 && $value->status_cancel == 0) {
                            $button_cancel = 'Y';
                        }
                    }
                }

                $data[] = array(
                    "id" => (string) $value->id,
                    "leave_name" => $value->leavetype->leave_name,
                    "leave_start_date" => $leave_start_date,
                    "leave_end_date" => $leave_end_date,
                    "no_days" => $value->no_days,
                    "status" => EmployeeLeaveDetail::getleavestatusbybranch($value->leave_status),
                    "leave_reason" => $value->leave_reason,
                    "button_edit" => "N",
                    "button_delete" => $button_delete,
                    "button_cancel" => $button_cancel);
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }

    public function actionGetLeaveforApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        $data = [];
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $pending_leaves = EmployeeLeaveDetail::getintermediateapproval($employee_id, 1);
            $condition = 'employeedetail.isActive="Y" AND (last_approved_level<t.max_level OR last_cancel_level<t.max_level) And t.id IN(' . $pending_leaves . ')';

            $model = new EmployeeLeaveDetail();
            $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            $model_settings = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_month = date("m");
            if ($current_month < $model_settings->leave_carry_forward_month) {
                $year = $year - 1;
            }
            foreach ($model as $key => $value) {
                $apply_date = $leave_start_date = $leave_end_date = '';

                $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value->leave_type . '" and employee_id="' . $value->employee_id . '" and leave_year="' . $year . '"'));
                if ($value->apply_date != '' && $value->apply_date != '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }

                if ($value->leave_start_date != '' && $value->leave_start_date != '0000-00-00') {
                    $leave_start_date = date("d/m/Y", strtotime($value->leave_start_date));
                }
                if ($value->leave_end_date != '' && $value->leave_end_date != '0000-00-00') {
                    $leave_end_date = date("d/m/Y", strtotime($value->leave_end_date));
                }
                //Approve Button
                $last_approved_level = $value->last_approved_level;
                $next_approval_level = $last_approved_level + 1;
                $show_approve_button = 0;
                $level_no = 0;
                $final_level = 'N';
                if ($next_approval_level <= $value->max_level) {
                    if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 1;
                    } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 2;
                    } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 3;
                    } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 4;
                    } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 5;
                    }
                }
                if ($next_approval_level == $value->max_level) {
                    $final_level = 'Y';
                }
                //End Approve
                //Start Cancel
                $last_cancel_level = $value->last_cancel_level;
                $next_cancel_level = $last_cancel_level + 1;
                $show_cancel_button = 0;
                $cancel_level_no = 0;
                $cancel_final_level = 'N';
                if ($next_cancel_level <= $value->max_level) {
                    if ($next_cancel_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 1;
                    } else if ($next_cancel_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 2;
                    } else if ($next_cancel_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 3;
                    } else if ($next_cancel_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 4;
                    } else if ($next_cancel_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 5;
                    }
                }
                if ($next_cancel_level == $value->max_level) {
                    $cancel_final_level = 'Y';
                }
                //ENd Cancel
                $data[] = array(
                    "id" => (string) $value->id,
                    "employee_id" => $value->employee_id,
                    "leave_type" => $value->leave_type,
                    "employee_name" => $value->employeedetail->employeefullname,
                    "leave_name" => $value->leavetype->leave_name,
                    "apply_date" => $apply_date,
                    "leave_start_date" => $leave_start_date,
                    "leave_end_date" => $leave_end_date,
                    "no_days" => $value->no_days,
                    "leave_current_balance" => $model_leave->leave_current_balance,
                    "status" => EmployeeLeaveDetail::getleavestatusbybranch($value->leave_status),
                    "leave_reason" => $value->leave_reason,
                    "approve_btn" => $show_approve_button,
                    "cancel_btn" => $show_cancel_button,
                    "next_cancel_level" => $next_cancel_level,
                    "next_approval_level" => $next_approval_level);
            }
            if (empty($data)) {
                $response = array('status' => "success", "msg" => "No data available", 'data' => $data);
            } else {
                $response = array('status' => "success", "msg" => "success", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');

            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }

    public function actionGetLeaveforApprovalHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        $data = [];
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $leave_id = $data_array['leave_type'];
            $condition = 'employeedetail.isActive="Y" AND leave_type ="' . $leave_id . '" AND t.employee_id="' . $employee_id . '"';
            $model = new EmployeeLeaveDetail();
            $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            $model_settings = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_month = date("m");
            if ($current_month < $model_settings->leave_carry_forward_month) {
                $year = $year - 1;
            }
            foreach ($model as $key => $value) {
                $apply_date = $leave_start_date = $leave_end_date = '';

                $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value->leave_type . '" and employee_id="' . $value->employee_id . '" and leave_year="' . $year . '"'));
                if ($value->apply_date != '' && $value->apply_date != '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }

                if ($value->leave_start_date != '' && $value->leave_start_date != '0000-00-00') {
                    $leave_start_date = date("d/m/Y", strtotime($value->leave_start_date));
                }
                if ($value->leave_end_date != '' && $value->leave_end_date != '0000-00-00') {
                    $leave_end_date = date("d/m/Y", strtotime($value->leave_end_date));
                }
                //Approve Button
                $last_approved_level = $value->last_approved_level;
                $next_approval_level = $last_approved_level + 1;
                $show_approve_button = 0;
                $level_no = 0;
                $final_level = 'N';
                if ($next_approval_level <= $value->max_level) {
                    if ($next_approval_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 1;
                    } else if ($next_approval_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 2;
                    } else if ($next_approval_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 3;
                    } else if ($next_approval_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 4;
                    } else if ($next_approval_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                        $show_approve_button = 1;
                        $level_no = 5;
                    }
                }
                if ($next_approval_level == $value->max_level) {
                    $final_level = 'Y';
                }
                //End Approve
                //Start Cancel
                $last_cancel_level = $value->last_cancel_level;
                $next_cancel_level = $last_cancel_level + 1;
                $show_cancel_button = 0;
                $cancel_level_no = 0;
                $cancel_final_level = 'N';
                if ($next_cancel_level <= $value->max_level) {
                    if ($next_cancel_level == 1 && (($value->approvelevel->level_1_type == 'L' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'S' && $value->approvelevel->level_1_authority == $employee_id) || ($value->approvelevel->level_1_type == 'N' && $value->approvelevel->level_1_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 1;
                    } else if ($next_cancel_level == 2 && (($value->approvelevel->level_2_type == 'L' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'S' && $value->approvelevel->level_2_authority == $employee_id) || ($value->approvelevel->level_2_type == 'N' && $value->approvelevel->level_2_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 2;
                    } else if ($next_cancel_level == 3 && (($value->approvelevel->level_3_type == 'L' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'S' && $value->approvelevel->level_3_authority == $employee_id) || ($value->approvelevel->level_3_type == 'N' && $value->approvelevel->level_3_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 3;
                    } else if ($next_cancel_level == 4 && (($value->approvelevel->level_4_type == 'L' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'S' && $value->approvelevel->level_4_authority == $employee_id) || ($value->approvelevel->level_4_type == 'N' && $value->approvelevel->level_4_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 4;
                    } else if ($next_cancel_level == 5 && (($value->approvelevel->level_5_type == 'L' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'S' && $value->approvelevel->level_5_authority == $employee_id) || ($value->approvelevel->level_5_type == 'N' && $value->approvelevel->level_5_authority == $employee_id))) {
                        $show_cancel_button = 1;
                        $cancel_level_no = 5;
                    }
                }
                if ($next_cancel_level == $value->max_level) {
                    $cancel_final_level = 'Y';
                }
                //ENd Cancel
                $data[] = array(
                    "id" => $value->id,
                    "employee_id" => $value->employee_id,
                    "employee_name" => $value->employeedetail->employeefullname,
                    "leave_name" => $value->leavetype->leave_name,
                    "apply_date" => $apply_date,
                    "leave_start_date" => $leave_start_date,
                    "leave_end_date" => $leave_end_date,
                    "no_days" => $value->no_days,
                    "leave_current_balance" => $model_leave->leave_current_balance,
                    "status" => EmployeeLeaveDetail::getleavestatusbybranch($value->leave_status),
                    "leave_reason" => $value->leave_reason,
                    "approve_btn" => $show_approve_button,
                    "cancel_btn" => $show_cancel_button,
                    "next_cancel_level" => $next_cancel_level,
                    "next_approval_level" => $next_approval_level);
            }
            if (empty($data)) {
                $response = array('status' => "success", "msg" => "No data available", 'data' => $data);
            } else {
                $response = array('status' => "success", "msg" => "success", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');

            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }

    public function actionSaveApprovedLeave() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $jsonData = array();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id = $userModel->id;
            $status_v = $data_array["status"]; //A-Approved,R-Rejected
            $comment = $data_array["comment"];
            $next_approval_level = $data_array["next_approval_level"];
            if ($id > 0 && $status_v != '' && $user_id > 0) {
                $model = EmployeeLeaveDetail::model()->findByPK($id);
                $final_level = 'N';
                $status = 0;
                $modelemployee = User::model()->findByPK($user_id);
                $level = $model->last_approved_level + 1;
                if ((int) $next_approval_level == $level) {
                    //Status Start
                    //For Approval Level-Start
                    if ($model->last_approved_level != $model->max_level) {

                        if ($level == $model->max_level) {
                            $final_level = 'Y';
                        }
                        if ($final_level == 'Y') {
                            if ($status_v == 'A') {
                                $status = 12;
                            } else {
                                $status = 13;
                            }
                            $model->approved_date = date('Y-m-d');
                            $model->hr_comment = $comment;
                            $model->approved_id = $modelemployee->employee_id;
                        } else if ($level == 1) {
                            if ($status_v == 'A') {
                                $status = 2;
                            } else {
                                $status = 3;
                            }
                            $model->line_manager_approved_date = date('Y-m-d');
                            $model->line_manager_comment = $comment;
                            $model->line_manager_id = $modelemployee->employee_id;
                        } else if ($level == 2) {
                            if ($status_v == 'A') {
                                $status = 4;
                            } else {
                                $status = 5;
                            }
                            $model->approve_level2_date = date('Y-m-d');
                            $model->approve_level2_comment = $comment;
                            $model->approve_level2_id = $modelemployee->employee_id;
                        } else if ($level == 3) {
                            if ($status_v == 'A') {
                                $status = 6;
                            } else {
                                $status = 7;
                            }
                            $model->approve_level3_date = date('Y-m-d');
                            $model->approve_level3_comment = $comment;
                            $model->approve_level3_id = $modelemployee->employee_id;
                        } else if ($level == 4) {
                            if ($status_v == 'A') {
                                $status = 8;
                            } else {
                                $status = 9;
                            }
                            $model->approve_level4_date = date('Y-m-d');
                            $model->approve_level4_comment = $comment;
                            $model->approve_level4_id = $modelemployee->employee_id;
                        } else if ($level == 5) {
                            if ($status_v == 'A') {
                                $status = 10;
                            } else {
                                $status = 11;
                            }
                            $model->approve_level5_date = date('Y-m-d');
                            $model->approve_level5_comment = $comment;
                            $model->approve_level5_id = $modelemployee->employee_id;
                        }
                        $model->last_approved_level = $level;
                    }
                    //For Approval Level-End
                    //Status End
                    //Updating Table
                    $model->leave_status = $status;
                    $model->save();
                    //Leave Deduction Starts
                    if ($status == 12 && $final_level == 'Y') {
                        $employee_id = $model->employee_id;
                        $model_settings = HrGenerelSettings::model()->find();
                        $year = date("Y");
                        $current_month = date("m");
                        if ($current_month < $model_settings->leave_carry_forward_month) {
                            $year = $year - 1;
                        }
                        $start_date = $model->leave_start_date;
                        $end_date = $model->leave_end_date;
                        $leave_type = $model->leave_type;
                        $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                        if ($model_master_leave->sub_type_leave == "N") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
                        } else if ($model_master_leave->sub_type_leave == "Y") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                        }
                        if ($model_leave->id > 0) {
                            $available_leave = $model_leave->leave_current_balance;
                            $leave_days = $model->normal_leave;
                            $balance_leave = $available_leave - $leave_days;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave));
                        }
                        //Salary Deduction for leave
                        //Start Adding Normal Leaves
                        $normal_leaves = $model->normal_leave;
                        if ($model_master_leave->salary_deduction != 'N' && $normal_leaves > 0) {
                            $start_date_1 = $model->leave_start_date;
                            $normal_leaves = ceil($normal_leaves - 1);
                            for ($i = 0; $i <= $normal_leaves; $i++) {
                                $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                                $model_salary_deduction->employee_id = $model->employee_id;
                                $model_salary_deduction->leave_id = $model->id;
                                $model_salary_deduction->leave_type_id = $model->leave_type;
                                $model_salary_deduction->leave_date = $start_date_1;
                                $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction;
                                $model_salary_deduction->created_by = $userModel->id;
                                $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                                $model_salary_deduction->save();
                                $start_date_1 = date('Y-m-d', strtotime('+1 day', strtotime($start_date_1)));
                            }
                        }
                        //End Adding Normal Leaves
                        //Starting Adding Negative Leaves
                        $negative_leaves = $model->salary_deduction_leave;
                        if ($model_master_leave->salary_deduction_negative_leave != 'N' && $negative_leaves > 0) {
                            $normal_leaves = ceil($model->normal_leave);
                            $negative_deduction_start = date('Y-m-d', strtotime("+$normal_leaves days", strtotime($model->leave_start_date)));
                            $negative_leaves = ceil($model->salary_deduction_leave - 1);
                            for ($i = 0; $i <= $negative_leaves; $i++) {
                                $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                                $model_salary_deduction->employee_id = $model->employee_id;
                                $model_salary_deduction->leave_id = $model->id;
                                $model_salary_deduction->leave_type_id = $model->leave_type;
                                $model_salary_deduction->leave_date = $negative_deduction_start;
                                $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction_negative_leave;
                                $model_salary_deduction->created_by = $userModel->id;
                                $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                                $model_salary_deduction->save();
                                $negative_deduction_start = date('Y-m-d', strtotime('+1 day', strtotime($negative_deduction_start)));
                            }
                        }
                        //End Adding Negative Leaves
                        $d1 = strtotime($start_date);
                        $d2 = strtotime($end_date);
                        $datediff = $d2 - $d1;
                    $diff = floor($datediff / (60 * 60 * 24))+1;
                        $start = 0;
                        $end = $diff;
                        $date_from = $start_date;
                    for ($i = $start; $i <$end; $i++) {
                            //EMployee 
                            $model_emp = Employee::model()->findByPk($employee_id);
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and status="2"';
                            if ($model_emp->branch_sponsor->exclude_weekend == 0) {
                                $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and (status="2" OR status="5")';
                            }
                            $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                            if (!empty($model_attendance)) {
                                EmployeeAttendance::model()->updateByPK($model_attendance->id, array('status' => 3, 'leave_id' => $model->id));
                            }
                            $date_from = date('Y-m-d', strtotime($date_from . ' +1 day'));
                        }
                    }
                    //Mail
//                        $model_settings = HrGenerelSettings::model()->find();
//                        $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="2"'));
//                        if(!empty($model_settings)){
//                            if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                                 Yii::import('application.modules.hr.controllers.MailController'); 
//                                 MailController::sendmail(2,$model->employee_id,$model->id);
//                            }
//                        }
                    //sent pushnotification
                    if ($status_v == "A") {
                        $model_leave_notification_approval = $this->getnotificationapproval($model->id, 1);
                    } else {
                        $this->getnotificationapproval($model->id, 3);
                    }
                    //
                    $jsonData['status'] = 'success';
                    $jsonData['message'] = 'Leave Details Updated Successfully';
                } else {
                    $jsonData['message'] = 'Error in getting Leave Details.Please check';
                    $jsonData['status'] = 'error';
                }
            } else {
                if ($id == '') {
                    $jsonData['message'] = 'Error in getting Leave Details';
                } else if ($status_v == '') {
                    $jsonData['message'] = 'Please Select Status';
                } else if ($user_id == '') {
                    $jsonData['message'] = 'Cannot Access User Details';
                }
                $jsonData['status'] = 'error';
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveCancelledLeave() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id = $userModel->id;
            $status_v = $data_array["status"]; //A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id > 0 && $status_v != '' && $user_id > 0) {
                $model = EmployeeLeaveDetail::model()->findByPK($id);
                $final_level = 'N';
                $status = 0;
                $modelemployee = User::model()->findByPK($user_id);
                //Status Start
                //For Cancel Level-Start
                if ($model->last_cancel_level >= 0 && $model->last_cancel_level != $model->max_level) {
                    $level = $model->last_cancel_level + 1;
                    if ($level == $model->max_level) {
                        $final_level = 'Y';
                    }
                    if ($final_level == 'Y') {
                        if ($status_v == 'A') {
                            $status = 25;
                        } else {
                            $status = 26;
                        }
                        $model->date_cancel_hr = date('Y-m-d');
                        $model->cancel_comment_hr = $comment;
                        $model->cancel_approved_id = $modelemployee->employee_id;
                    } else if ($level == 1) {
                        if ($status_v == 'A') {
                            $status = 15;
                        } else {
                            $status = 16;
                        }
                        $model->date_cancel_lm = date('Y-m-d');
                        $model->cancel_comment_lm = $comment;
                        $model->cancel_level_1_id = $modelemployee->employee_id;
                    } else if ($level == 2) {
                        if ($status_v == 'A') {
                            $status = 17;
                        } else {
                            $status = 18;
                        }
                        $model->date_cancel_level_2 = date('Y-m-d');
                        $model->cancel_level_2_comment = $comment;
                        $model->cancel_level_2_id = $modelemployee->employee_id;
                    } else if ($level == 3) {
                        if ($status_v == 'A') {
                            $status = 19;
                        } else {
                            $status = 20;
                        }
                        $model->date_cancel_level_3 = date('Y-m-d');
                        $model->cancel_level_3_comment = $comment;
                        $model->cancel_level_3_id = $modelemployee->employee_id;
                    } else if ($level == 4) {
                        if ($status_v == 'A') {
                            $status = 21;
                        } else {
                            $status = 22;
                        }
                        $model->date_cancel_level_4 = date('Y-m-d');
                        $model->cancel_level_4_comment = $comment;
                        $model->cancel_level_4_id = $modelemployee->employee_id;
                    } else if ($level == 5) {
                        if ($status_v == 'A') {
                            $status = 23;
                        } else {
                            $status = 24;
                        }
                        $model->date_cancel_level_5 = date('Y-m-d');
                        $model->cancel_level_5_comment = $comment;
                        $model->cancel_level_5_id = $modelemployee->employee_id;
                    }
                    $model->last_cancel_level = $level;
                }
                //For Cancel Level-End
                //Status End
                //Updating Table
                $model->leave_status = $status;
                $model->save();
                if ($status == 25 && $final_level == 'Y') {
                    $model_settings = HrGenerelSettings::model()->find();
                    $year = date("Y");
                    $current_month = date("m");
                    if ($current_month < $model_settings->leave_carry_forward_month) {
                        $year = $year - 1;
                    }
                    $model_master_leave = MasLeave::model()->findbyPk($model->leave_type);
                    if ($model_master_leave->sub_type_leave == "N") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model->leave_type . '" and leave_year="' . $year . '"'));
                    } else if ($model_master_leave->sub_type_leave == "Y") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                    }
                    if ($model_leave->id > 0) {
                        if ($model->approved_date != '0000-00-00') {
                            $available_leave = $model_leave->leave_current_balance;
                            $leave_days = $model->normal_leave;
                            $balance_leave = $available_leave + $leave_days;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave));
                            $model_leave_ledger = new EmployeeLeaveLedger();
                            $model_leave_ledger->employee_id = $model->employee_id;
                            $model_leave_ledger->leave_type = $model->leave_type;
                            $model_leave_ledger->leave_count = $model->normal_leave;
                            $model_leave_ledger->remarks = "Leave added by cancellation of leave from " . date("d/m/Y", strtotime($model->leave_start_date)) . " to " . date("d/m/Y", strtotime($model->leave_end_date));
                            $model_leave_ledger->created_by = Yii::app()->user->id;
                            $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                            $model_leave_ledger->save();
                        }
                    }
                }
                //Mail
                /* $model_settings = HrGenerelSettings::model()->find();
                  $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="2"'));
                  if(!empty($model_settings)){
                  if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                  Yii::import('application.modules.hr.controllers.MailController'); 
                  MailController::sendmail(2,$model->employee_id,$model->id);
                  }
                  } */
                $jsonData['status'] = 'success';
                $jsonData['msg'] = 'Leave Details Updated Successfully';
            } else {
                if ($id == '') {
                    $jsonData['msg'] = 'Error in getting Leave Details';
                } else if ($status_v == '') {
                    $jsonData['msg'] = 'Please Select Status';
                } else if ($user_id == '') {
                    $jsonData['msg'] = 'Cannot Access User Details';
                }
                $jsonData['status'] = 'error';
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveleaveCancel() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $cancel_reason_employee = $data_array["cancel_reason_employee"];
            $user_id = $userModel->id;
            if ($id > 0 && $user_id > 0) {
                EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => 0, 'cancel_reason_employee' => $cancel_reason_employee, 'leave_status' => 14, 'date_apply_cancel' => date('Y-m-d'), 'status_cancel' => 1));
                //Mail
                /*    $model = EmployeeLeaveDetail::model()->findbyPk($id);
                  $model_settings = HrGenerelSettings::model()->find();
                  $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="3"'));
                  if(!empty($model_settings)){
                  if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                  Yii::import('application.modules.hr.controllers.MailController');
                  MailController::sendmail(3,$model->employee_id,$model->id);
                  }
                  } */
                $jsonData['status'] = 'success';
                $jsonData['msg'] = 'Leave Details Updated Successfully';
            } else {

                $jsonData['status'] = 'failed';
                $jsonData['msg'] = 'Input parameters missing';
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveleavedelete() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id = $userModel->id;
            if ($id > 0 && $user_id > 0) {
                $model = EmployeeLeaveDetail::model()->findByPk($id);
                if ($model->leave_status == 1) {
                    EmployeeLeaveDetail::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                    $jsonData['msg'] = 'Leave Details Deleted Successfully';
                } else {
                    $jsonData['status'] = 'error';
                    $jsonData['msg'] = 'Error in Deletion';
                }
            } else {

                $jsonData['status'] = 'failed';
                $jsonData['msg'] = 'Input parameters missing';
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($jsonData);
    }

    public function actionEditLeave() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $model = EmployeeLeaveDetail::model()->findByPk($id);
            $employee_id = $model->employee_id;
            $leave_id = $model->leave_type;
            $current_leave_year = date('Y');
            $model_setting = HrGenerelSettings::model()->find();
            $current_month = date("m");
            if ($current_month < $model_setting->leave_carry_forward_month) {
                $current_leave_year = $current_leave_year - 1;
            }
            $model_master_leave = MasLeave::model()->findbypk($leave_id);
            if ($model_master_leave->sub_type_leave == "N") {
                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_id . '" and leave_year="' . $current_leave_year . '"'));
            } else if ($model_master_leave->sub_type_leave == "Y") {
                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
            }
            $d1 = strtotime($model->leave_start_date);
            $d2 = strtotime($model->leave_end_date);
            $datediff = $d2 - $d1;
            $diff = floor($datediff / (60 * 60 * 24)) + 1;
            $checked = 1;
            if ($model->no_days == $diff) {
                $checked = 0;
            }
            $ticket_applied = 0;
            $travel_date = $return_date = '';
            if ($model->ticket_applied == 1) {
                $ticket_applied = 1;
                if ($model->travel_date != '' && $model->travel_date != '0000-00-00') {
                    $travel_date = date("d/m/Y", strtotime($model->travel_date));
                }
                if ($model->return_date != '' && $model->return_date != '0000-00-00') {
                    $return_date = date("d/m/Y", strtotime($model->return_date));
                }
            }

            $data[] = array(
                "id" => $model->id,
                "leave_type" => $model->leave_type,
                "current_leave" => $model_leave->leave_current_balance,
                "leave_start_date" => date("d/m/Y", strtotime($model->leave_start_date)),
                "leave_end_date" => date("d/m/Y", strtotime($model->leave_end_date)),
                "no_days" => $model->no_days,
                "normal_leave" => $model->normal_leave,
                "salary_deduction_leave" => $model->salary_deduction_leave,
                "half_checked" => $checked,
                "leave_reason" => $model->leave_reason,
                "ticket_applied" => $ticket_applied,
                "travel_date" => $travel_date,
                "travel_destination" => $model->travel_destination,
                "return_date" => $return_date,
                "return_destination" => $model->return_destination,
                "document_medical_certificate_upload" => $model_master_leave->document_medical_certificate_upload,
                "medical_certificate" => $model->medical_certificate,);
            $jsonData = array('status' => "success", "msg" => "Success", 'data' => $data);
            if (empty($data)) {
                $jsonData = array('status' => "failed", "msg" => "No data found", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($jsonData);
    }

    public function actionGetleaveDays() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array["employee_id"];
            $available_leave = $data_array["available_leave"];
            $leave_type = $data_array["leave_type"];
            $start_date = $data_array["start_date"];
            $end_date = $data_array["end_date"];
            $checkbox = $data_array["half_leave"];
            $current_leave_year = date('Y');
            if ($start_date != '' && $end_date != '') {
                $start_date = str_replace('/', '-', $start_date);
                $start_date = date("Y-m-d", strtotime($start_date));
                $end_date = str_replace('/', '-', $end_date);
                $end_date = date("Y-m-d", strtotime($end_date));
                $current_date = date('Y-m-d');
                $date1_convert = strtotime($current_date);
                $date2_convert = strtotime($start_date);
                $apply_days = $date2_convert - $date1_convert;
                $applyday = floor($apply_days / (60 * 60 * 24));
                $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                //$additional_leave=$model_master_leave->additional_leave;
                //$available_leave+=$additional_leave;
                $model_setting = HrGenerelSettings::model()->find();
                $model_employee_dtl = Employee::model()->findbyPk($employee_id);
                //Check holiday deducted
                $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model_employee_dtl->branch_or_sponsor_id);
                $include_holiday = '';
                if ($model_master_leave->exclude_holiday == 'Y') {
                    $include_holiday = 'N';
                } else if ($model_master_leave->exclude_holiday == 'N') {
                    $include_holiday = 'Y';
                }
                if ($model_setting->leave_apply_before_current_date == 'Y') {
                    $model_master_leave->apply_before = 0;
                }
                if ($model_setting->consider_advance_leave == 'Y' && $model_master_leave->leave_type == 1) {
                    //Get Max Salary Details
                    $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $employee_id . '"'));
                    if ($model_max_id->salary_processing_id > 0) {
                        $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                        $payroll_dt = $model_salry_processing->payroll_enddate;
                        $date_for_advnc_1 = strtotime($payroll_dt);
                        $date_for_advnc_2 = strtotime($end_date);
                        $year11 = date('Y', $date_for_advnc_1);
                        $year12 = date('Y', $date_for_advnc_2);
                        $month11 = date('m', $date_for_advnc_1);
                        $month12 = date('m', $date_for_advnc_2);
                        $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                        $available_leave += $advance_leave_month * $model_master_leave->leave_days;
                    } else {
                        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                        if ($model_lock_month->id == '') {
                            $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                        }
                        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                        if ($model_lock_days->id == '') {
                            $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                        }
                        $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                        // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));
                        $date_for_advnc_1 = strtotime($salary_last_date);
                        $date_for_advnc_2 = strtotime($end_date);
                        $year11 = date('Y', $date_for_advnc_1);
                        $year12 = date('Y', $date_for_advnc_2);
                        $month11 = date('m', $date_for_advnc_1);
                        $month12 = date('m', $date_for_advnc_2);
                        $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                        $available_leave += $advance_leave_month * $model_master_leave->leave_days;
                    }
                }
                if ($model_master_leave->sub_type_leave == "N") {
                    $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $current_leave_year . '"'));
                } else if ($model_master_leave->sub_type_leave == "Y") {
                    $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
                }
                if (!empty($model_leave_table_exist)) {
                    //Attendance marked
                    $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"', 'order' => 'attendance_date asc'));
                    if (empty($model_attendance_present)) {
                        if ($applyday >= $model_master_leave->apply_before || $model_master_leave->apply_before == 0) {
                            $model_employee_leave_approved = EmployeeLeaveDetail::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                        OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) and (leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
                            if (empty($model_employee_leave_approved)) {
                                $model = Employee::model()->findbyPK($employee_id);
                                $weekend_off1 = $model->weekend_off1;
                                $weekend_off2 = $model->weekend_off2;
                                $weekend_off3 = $model->weekend_off3;
                                $weekend = $model_master_leave->exclude_weekend;
                                //Day Calculation
                                $leave_days = 0;
                                $d1 = strtotime($start_date);
                                $d2 = strtotime($end_date);
                                $total_days = $d2 - $d1;
                                if ($weekend == 'Y') {
                                    $datefrom = $start_date;
                                    $diff = floor($total_days / (60 * 60 * 24));
                                    for ($i = 0; $i <= $diff; $i++) {
                                        $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                        $weekvalue = date('w', strtotime($datefrom));
                                        $weekvalue += 1;
                                        if ($weekend_off1 == $weekvalue) {
                                            if ($model->weekend_off1_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($weekend_off2 == $weekvalue) {
                                            if ($model->weekend_off2_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($weekend_off3 == $weekvalue) {
                                            if ($model->weekend_off3_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                                            $leave_days++;
                                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                            
                                        } else {
                                            $leave_days++;
                                        }
                                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                    }
                                    if ($checkbox == 1) {
                                        $leave_days = $leave_days - 0.5;
                                    }
                                } else {
                                    $datefrom = $start_date;
                                    $diff = floor($total_days / (60 * 60 * 24));
                                    for ($i = 0; $i <= $diff; $i++) {
                                        if ($include_holiday == "Y" && !empty($model_holiday)) {
                                            $leave_days++;
                                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                            
                                        } else {
                                            $leave_days++;
                                        }
                                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                    }
                                    //$leave_days = floor($total_days / (60  60  24) + 1);
                                    if ($checkbox == 1) {
                                        $leave_days = $leave_days - 0.5;
                                    }
                                }
                                //check negative leave apply permission
                                if ($model_master_leave->negative_leave_apply_permission == 'B') {  //Leave limit condition when negative 
                                    if ($leave_days <= $available_leave) {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                                $message = '';
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is' . $model_master_leave->max_leave_appl;    //Leave apply limit error
                                                $status = 'error';
                                            }
                                        } else {
                                            $days = $leave_days;
                                            $normal_leave = $leave_days;
                                            $salary_deduction_leave = 0.00;
                                            $status = 'success';
                                            $message = '';
                                        }
                                    } else {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {   //Leave limit condition when negative salary deduction
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                    $salary_deduction_leave = $leave_days - $available_leave;
                                                    $days = $leave_days;
                                                    $normal_leave = $available_leave;
                                                    $status = 'success';
                                                    $message = 'Available leave is ' . $normal_leave . ' and applied for ' . $days . ' leaves.Salary deducted for ' . $salary_deduction_leave . ' leaves.'; //8
                                                } else {
                                                    $days = $leave_days;
                                                    $normal_leave = $leave_days;
                                                    $salary_deduction_leave = 0.00;
                                                    $status = 'success';
                                                    $message = '';
                                                }
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is ' . $model_master_leave->max_leave_apply;    //Leave apply limit error 9
                                                $status = 'error';
                                            }
                                        } else {
                                            if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                $salary_deduction_leave = $leave_days - $available_leave;
                                                $days = $leave_days;
                                                $normal_leave = $available_leave;
                                                $status = 'success';
                                                $message = 'Available leave is ' . $normal_leave . ' and applied for ' . $days . ' leaves.Salary deducted for ' . $salary_deduction_leave . ' leaves.'; //8
                                            } else {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                                $message = '';
                                            }
                                        }
                                    }
                                } else {
                                    if ($leave_days > $available_leave) {
                                        $message = 'Leaves not availabe.Maximum available leave is ' . $available_leave;    //Leave not available 4
                                        $status = 'error';
                                    } else {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is ' . $model_master_leave->max_leave_apply;
                                                $status = 'error';
                                            }
                                        } else {
                                            $days = $leave_days;
                                            $normal_leave = $leave_days;
                                            $salary_deduction_leave = 0.00;
                                            $status = 'success';
                                        }
                                    }
                                }
                            } else {
                                $message = 'Leave applied in this date range';    //Already Leave applied 3
                                $status = 'error';
                            }
                        } else {
                            $message = 'Leave should be applied before ' . $model_master_leave->apply_before;    //Apply before master set value 5
                            $status = 'error';
                        }
                    } else {
                        $date_array = array();
                        foreach ($model_attendance_present as $key => $value) {
                            $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
                        }
                        $attendancedate = implode(',', $date_array);
                        $message = 'Attendance marked as present for ' . $attendancedate;    //Attendance-Present added 6
                        $status = 'error';
                    }
                } else {
                    $message = 'Leave Balance Record not Present.Contact HR';    //Leave balance record error 7
                    $status = 'error';
                }
            } else {
                if ($start_date == '') {
                    $message = 'Select Start Date'; //Start Date Null 1
                } else if ($end_date == '') {
                    $message = 'Select End Date'; //End Date Null 2
                }
                $status = 'error';
            }
            $data = array(
                "days" => $days,
                "normal_leave" => $normal_leave,
                "salary_deduction_leave" => $salary_deduction_leave,
                "status" => $status,
                "message" => $message,
                'employee_id' => $data_array["employee_id"],
                'available_leave' => $data_array["available_leave"],
                'leave_type' => $data_array["leave_type"],
                'start_date' => $data_array["start_date"],
                'end_date' => $data_array["end_date"]);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($data);
    }

    public static function getnotificationapproval($id, $from) {
        if ($from == 1) {

            $model_leave_details = EmployeeLeaveDetail::model()->findbyPK($id);
            $next_approval_level = $model_leave_details->last_approved_level + 1;
            $field_type = 'level_' . $next_approval_level . '_type';
            $field_authority = 'level_' . $next_approval_level . '_authority';
            //for approval
            if ($next_approval_level <= $model_leave_details->max_level) {
                if ($model_leave_details->approvelevel->$field_type == 'L' || $model_leave_details->approvelevel->$field_type == 'S' || $model_leave_details->approvelevel->$field_type == 'N') {
                    $employee_id = $model_leave_details->approvelevel->$field_authority;
                    if ($employee_id > 0) {
                        ApileaveController::sendandSaveNotification($employee_id, 1);
                    }
                }
            }
        } else if ($from == 2) {
            $model_leave_details = EmployeeLeaveDetail::model()->findbyPK($id);
            $next_approval_level = $model_leave_details->last_approved_level + 1;
            $field_type = 'level_' . $next_approval_level . '_type';
            $field_authority = 'cancel_level_' . $next_approval_level . '_id';
            //for approval
            if ($next_approval_level <= $model_leave_details->max_level) {
                if ($model_leave_details->approvelevel->$field_type == 'L' || $model_leave_details->approvelevel->$field_type == 'S' || $model_leave_details->approvelevel->$field_type == 'N') {
                    $employee_id = $model_leave_details->approvelevel->$field_authority;
                    if ($employee_id > 0) {
                        ApileaveController::sendandSaveNotification($employee_id, 2);
                    }
                }
            }
        } else if ($from == 3) {
            $model_leave_details = EmployeeLeaveDetail::model()->findbyPK($id);
            $employee_id = $model_leave_details->employee_id;
            if ($employee_id > 0) {
                ApileaveController::sendandSaveNotification($employee_id, 3);
            }
        }
    }

    public static function sendandSaveNotification($employee_id, $type) {
        error_log(json_encode($employee_id));
        $fcmMessage = new FcmMessage();
        $fcmMessage->setTofromCsutomer($employee_id);
        $fcmMessage->to_type = "E";
        $employeeModel = Employee::model()->find(array('condition' => 'id="' . $employee_id . '" AND isActive!="B"'));
        $fcmMessage->employee_name = $employeeModel->employeefullname;
        $message = "";
        // <customer> booked for <tech> on <dt> at <tm>
        if ($type == 1) {
            $fcmMessage->title = "Leave Approval";
            $message = "An employee applied for leave.Waiting for Approval";
        } else if ($type == 2) {
            $fcmMessage->title = "Leave Cancel";
            $message = "There is a leave Cancellation request.";
        } else if ($type == 3) {
            $fcmMessage->title = "Leave Rejected";
            $message = "Your Leave Rejected.";
        }
        $fcmMessage->text = $message;
        $fcmMessage->message = $message;
        $fcmClient = new FcmClient();
        $fcmClient->SendNotification($fcmMessage->getMessageArray());
    }

    public function actionLeaveTypes() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model = new MasLeave();
            $condition = 'isActive =  "Y" and FIND_IN_SET(' . $userModel->employee_id . ', employee_id)';
            $model_master_employee = Employee::model()->findbypk($userModel->employee_id);
            $service_days = 0;
            if (!empty($model_master_employee)) {
                if ($model_master_employee->date_join != '' && $model_master_employee->date_join != "0000-00-00") {
                    $d1 = strtotime($model_master_employee->date_join);
                    $d2 = strtotime(date('Y-m-d'));
                    $datediff = $d2 - $d1;
                    $service_days = $datediff / (60 * 60 * 24) + 1;
                }
                $condition .= ' AND branch_id="' . $model_master_employee->branch_or_sponsor_id . '"';
            }
            $condition .= ' AND (employee_can_apply="0" OR employee_can_apply<="' . $service_days . '")';
            $leave_tyes = $model->findall(array('condition' => $condition, 'order' => 't.id ASC'));
            $data = [];
            if (!empty($leave_tyes)) {
                foreach ($leave_tyes as $tp) {
                    $data[] = [
                        "id" => $tp['id'],
                        "leave_name" => $tp['leave_name'],
                    ];
                }
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
                $responseArray = array('status' => "success", "msg" => "success", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $responseArray = array('status' => "error", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($responseArray);
    }

    public function actionUploadDocument($folder = NULL) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $jsonData=array();
        if ($userModel->id > 0) {
            $model_upload_document = HrMasterUpload::model()->findByPK(16);
            if ($model_upload_document->isActive == 'Y') {
                $upload_size = $model_upload_document->max_upload_size * 1024 * 1024;
                $employee_id = $userModel->employee_id;
                $certificate_name = $_FILES["file"]["name"];
                $extension = pathinfo($certificate_name, PATHINFO_EXTENSION);
                $fileSize = $_FILES["file"]['size'];
                if ($fileSize < $upload_size) {
                    $upload_size = $model_upload_document->max_upload_size * 1024 * 1024;
                    $model_employee= Employee::model()->findbyPK($employee_id);
                    //$model_employee=
                    $current_date =date('Y-m-d');
                    $new_file_name="Leave_";
                    if(!empty($model_employee)){
                        $new_file_name.=str_replace(' ', '_', $model_employee->employeecode);
                    }
                    $new_file_name.='_'.$current_date.'_'.uniqid().'.'.$extension;
                    $folder = Yii::getPathOfAlias('webroot') . '/uploads/leavedocument/' . $new_file_name;
                    move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
                    $jsonData['filename'] = $new_file_name;
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData = array('status' => "failed", "msg" => "File too large. Maximum size is " . $model_upload_document->max_upload_size . " MB",'filename'=>'', "token_status" => "UA");
                }
            } else {
                $jsonData = array('status' => "failed", "msg" => "Document uploads are not allowed under your current subscription plan",'filename'=>'', "token_status" => "UA");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($jsonData);
    }
        public function actionGetPreviousLeaveHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $condition = 'employee_id="' . $employee_id . '" and YEAR(leave_start_date)>="' . date('Y') . '"';
            $model = new EmployeeLeaveDetail();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'order' => 'leave_start_date desc'));
            foreach ($model as $key => $value) {
                $leave_start_date = $leave_end_date = '';
                if ($value->leave_start_date != '' && $value->leave_start_date != '0000-00-00') {
                    $leave_start_date = date("d/m/Y", strtotime($value->leave_start_date));
                }
                if ($value->leave_end_date != '' && $value->leave_end_date != '0000-00-00') {
                    $leave_end_date = date("d/m/Y", strtotime($value->leave_end_date));
                }
      
                $data[] = array(
                    "id" => (string) $value->id,
                    "leave_name" => $value->leavetype->leave_name,
                    "leave_start_date" => $leave_start_date,
                    "leave_end_date" => $leave_end_date,
                    "no_days" => $value->no_days,
                    "status" => EmployeeLeaveDetail::getleavestatusbybranch($value->leave_status),
                    "leave_reason" => $value->leave_reason);
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }
}
