<?php

class ApihrrequestController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array("GetEmployeeCertificateList", "SaveApplyRequest"),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        //for db connection added by nisha on 11-04-2023
        $this->ChangeDB();
        return true;
    }

    public function actionGetEmployeeCertificateList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $model = new MasCertificate();
            $employee_id = $data_array['employee_id'];
            $condition = 't.isActive="Y" and apply_from="N"';
            EmployeeCertificate::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (status="2" OR status="3")');
            $model = MasCertificate::model()->findAll(array('condition' => $condition));
            foreach ($model as $row) {
                $model_certificate_request_approved = EmployeeCertificate::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and certificate_id="' . $row->id . '" and status="2"'));
                $model_certificate_request = EmployeeCertificate::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and certificate_id="' . $row->id . '" and status="1"'));
                $button_string = "";
                if (empty($model_certificate_request)) {
                    $button_string = 1;
                } else {
                    $button_string = 2;
                }
                $data[] = array(
                    "id" => (string) $row['id'],
                    "certificate_name" => $row['certificate_name'],
                    "button_string" => $button_string,
                );
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionSaveApplyRequest() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $certificate_id = $data_array['certificate_id'];
            $employee_id = $data_array['employee_id'];
            $model = EmployeeCertificate::model()->find(array('condition' => 'certificate_id="' . $certificate_id . '" and employee_id="' . $employee_id . '" and status="1"'));
            if (empty($model)) {
                $model = new EmployeeCertificate();
                $model->created_by = $userModel->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            if ((int) @$data_array['id'] > 0) {
                $model->id = (int) $data_array['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = $userModel->id;
                $model->updated_date_time = date('Y-m-d H:i:s');

            }
            $model->certificate_id = $data_array['certificate_id'];
            $model->employee_id = $data_array['employee_id'];
            $model->addresses_to = $data_array['addresses_to'];
            $model->apply_notes = $data_array['reason'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="4"'));
            $model->last_approved_level = 0;
            if(!empty($model_master_approve_setting)){
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
            }
            if ($data_array['apply_date'] != '0000-00-00' && $data_array['apply_date'] != '') {
                $model->apply_date = $data_array['apply_date'];
                $model->apply_date = str_replace('/', '-', $model->apply_date);
                $model->apply_date = date("Y-m-d", strtotime($model->apply_date));
            }

            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="18"'));
                if (!empty($model_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.controllers.front.MailController');
                        //  MailController::sendmail(18, $model->employee_id, $model->id);
                    }
                }
                $response = array('status' => "success", "msg" => "success", 'id' => $model->id);
            } else {
                foreach ($model->errors as $t => $value) {
                    $arr_err[] = $value[0];
                }
                $response = array('status' => 'error', 'msg' => $arr_err);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }
}
