<?php

class ApihrgeneralController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetNoticeList','DownloadnoticeDocument','UploadDocument','SavesignedNoticeDocument','DownloadSignedDocument',
                    'GetComplaintList','SaveComplaint','GetAppraisalList','SaveAppraisalReview','GetOrganizationChart','dasboarddetails','Changepassword','NotificationDetails','NotificationCount','birthdaylist'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
        public function beforeAction($action) {
            //for db connection added by nisha on 27-03-2023
            $this->ChangeDB();
            return true; 
    }
    public function actionGetNoticeList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 't.employee_id = "'.$employee_id.'" and issued_date!="0000-00-00" and signed_date="0000-00-00"';
            EmployeeNoticeConduct::model()->updateAll(array('view_status' =>1), 'employee_id="'.$employee_id.'" and view_status="0"');
            $model = new EmployeeNoticeConduct();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
            $data = array();
            $m = 1;
            foreach ($model as $value) {
                $issued_date="";
                $days=0;
                if ($value->issued_date!= '' && $value->issued_date!= '0000-00-00') {
                    $issued_date = date("d/m/Y", strtotime($value->issued_date));
                    $issued_date_1 = strtotime($value->issued_date);
                    $current_date_1 = strtotime(date('Y-m-d'));
                    $datediff = $current_date_1-$issued_date_1 ;
                    $days = $datediff / (60 * 60 * 24)+1;  
                }
                $download_unsigned_document=$upload_signed_document=$download_notice=0;
                //For Downloading document to be signed
                if($value->notice_document!='' && $value->signed_notice_document==''){
                    $download_unsigned_document=1;
                }
                if($days<=5 && $value->signed_notice_document==''){
                    $upload_signed_document=1;
                }
                if($value->signed_notice_document!=''){
                    $download_notice=1;
                }
                $data[] = array(
                    "id" => $value->id,
                    "issued_date" => $issued_date,
                    "reason" => $value->reason,
                    "download_unsigned_document" => $download_unsigned_document,
                    "upload_signed_document" => $upload_signed_document,
                    "download_notice"=>$download_notice);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionDownloadnoticeDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $model= EmployeeNoticeConduct::model()->findByPk($id);
            $path = Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/".$model->notice_document;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
            echo json_encode($data);
        }
    }
    public function actionDownloadSignedDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $model= EmployeeNoticeConduct::model()->findByPk($id);
            $path = Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/".$model->signed_notice_document;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
            echo json_encode($data);
        }
    }
    public function actionUploadDocument($folder=NULL) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model_employee = Employee::model()->findbypk($_REQUEST['id']);
            $document_name=$model_employee->employeecode.'_'.$_FILES["file"]["name"];
            $folder = Yii::getPathOfAlias('webroot') . '/uploads/noticeconduct/'.$document_name;
            move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
            $jsonData['filename'] = $document_name;
            $jsonData['status'] = 'success';
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($jsonData);
    }
    public function actionSavesignedNoticeDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $id = $data_array["id"];
            $model= EmployeeNoticeConduct::model()->findByPK($id); 
            $model->updated_by = $user_id;
            $model->updated_date_time = date('Y-m-d H:i:s'); 
            $model->signed_notice_document = $data_array['signed_notice_document'];
            $model->signed_date = date('Y-m-d');
            if ($model->validate()) {
              $model->save();
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetComplaintList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 'employee_id="'.$employee_id.'"';
            $model = new ComplaintSuggestion();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
            $data = array();
            $m = 1;
            foreach ($model as $value) {
                $created_date="";
                if ($value->created_date!= '' && $value->created_date!= '0000-00-00') {
                    $created_date = date("d/m/Y", strtotime($value->created_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "created_date" => $created_date,
                    "complaint_suggestion" => $value->complaint_suggestion);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveComplaint() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $user_id   = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $id = $data_array["id"];
            $model = new ComplaintSuggestion();
            $model->created_by = $user_id;
            $model->created_date_time = date('Y-m-d H:i:s'); 
            $model->employee_id = $data_array['employee_id'];
            $model->complaint_suggestion = $data_array['complaint_suggestion'];
            $model->created_date = date('Y-m-d'); 
            if ($model->validate()) {
              $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="13"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                        Yii::import('application.modules.hr.controllers.MailController'); 
//                         MailController::sendmail(13,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetAppraisalList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_appraisal=HrAppraisal::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_appraisal.')';
            $data = [];
            $model = new HrAppraisal();
            $model = $model->with('employeedetail','employeedetail.departmentdetail','employeedetail.designationdetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'DATE(t.created_date_time) asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $date_join='';
                if ($row->employeedetail->date_join!= '' && $row->employeedetail->date_join!= '0000-00-00') {
                    $date_join = date("d/m/Y", strtotime($row->employeedetail->date_join));
                }
                //Appraisal Analysis Data
                $model_analysis= HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'.$row->id.'"'));
                foreach ($model_analysis as $key => $value) {
                    $arr_analysis[]=array(
                        "id"=>$value->id,
                        "question"=>trim($value->question),
                        "level1_answer"=>$value->level1_answer,
                        "level1_score"=>$value->level1_score,
                        "level2_answer"=>$value->level2_answer,
                        "level2_score"=>$value->level2_score,
                        "level3_answer"=>$value->level3_answer,
                        "level3_score"=>$value->level3_score,
                        "level4_answer"=>$value->level4_answer,
                        "level4_score"=>$value->level4_score,
                        "level5_answer"=>$value->level5_answer,
                        "level5_score"=>$value->level5_score
                    );
                }
                $save_status=$send_status=0;
                if($level_no==1){
                    $save_status=2;
                    $send_status=3;
                }else if($level_no==2){
                    $save_status=4;
                    $send_status=5;
                }else if($level_no==3){
                    $save_status=6;
                    $send_status=7;
                }else if($level_no==4){
                    $save_status=8;
                    $send_status=9;
                }else if($level_no==5){
                    $save_status=10;
                    $send_status=11;
                }
                if($final_level=='Y'){
                    $save_status=12;
                    $send_status=12;
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "department_name" => $row->employeedetail->departmentdetail->department_name,
                    "designation_name" => $row->employeedetail->designationdetail->designation_name,
                    "date_join" => $date_join,
                    "level_no" => $level_no,
                    "appraisal_for"=>$row->appraisal_for,
                    "save_status"=>$save_status,
                    "send_status"=>$send_status,
                    "analysis"=>$arr_analysis,
                    "status"=>HrAppraisal::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionGetOrganizationChart() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        $response =array();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            if($employee_id >0){
            $condition = 't.isActive="Y" and reporting_manager="'.$employee_id.'"';
            $model = new Employee();
            $model = $model->findAll(array('condition' => $condition));
            foreach ($model as $row) {
                $date_join='';
                if ($row->date_join!= '' && $row->date_join!= '0000-00-00') {
                    $date_join = date("d/m/Y", strtotime($row->date_join));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeefullname,
                    "employeecode" => $row->employeecode,
                    "department_name" => $row->departmentdetail->department_name,
                    "designation_name" => $row->designationdetail->designation_name,
                    "date_join" => $date_join);
            }
            $response = array('status'=>"success",'msg' => "success",'data'=>$data);
            if (empty($data)) {
            $response = array('status'=>"failed",'msg' => "No data available",'data'=>$data);
        }
        }else{
          $response = array('status'=>"failed",'msg' => "Employee id missing",'data'=>$data);  
        }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actionSaveAppraisalReview() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status = $data_array["status"];
            $level = $data_array["level"];
            if ($id>0 && $status!='' && $user_id>0) {
                $model= HrAppraisal::model()->findByPK($id); 
                $model->updated_by= $user_id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                if($status==3 || $status==5 || $status==7 || $status==9 || $status==11 || $status==12){
                    $model->last_approved_level =$level;
                }
                $final_level='N';
                if($level==$model->approvelevel->max_level){
                    $final_level='Y';
                }
                if($level==1){
                    $model->approve_level1_date = date('Y-m-d');
                    $model->approve_level1_comment = '';
                    $model->approve_level1_id = $modelemployee->employee_id;
                }else if($level==2){
                    $model->approve_level2_date = date('Y-m-d');
                    $model->approve_level2_comment = '';
                    $model->approve_level2_id = $modelemployee->employee_id;
                }else if($level==3){
                    $model->approve_level3_date = date('Y-m-d');
                    $model->approve_level3_comment = '';
                    $model->approve_level3_id = $modelemployee->employee_id;
                }else if($level==4){
                    $model->approve_level4_date = date('Y-m-d');
                    $model->approve_level4_comment = '';
                    $model->approve_level4_id = $modelemployee->employee_id;
                }else if($level==5){
                    $model->approve_level5_date = date('Y-m-d');
                    $model->approve_level5_comment = '';
                    $model->approve_level5_id = $modelemployee->employee_id;
                }
                if($final_level=='Y'){
                    $model->approved_date = date('Y-m-d');
                    $model->approval_comment = '';
                    $model->approved_by = $modelemployee->employee_id;
                }
                 //Updating Table
                $model->status = $status;
                $valid=$model->validate();
                //Adding Analysis Data
                if (isset($_POST['appraisalanalysis'])){
                    foreach ($_POST['appraisalanalysis'] as $i => $items) {
                        if($items['id']>0){
                            $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']); 
                            if($level==1){
                                $model_analysis[$i]->scenario= 'level1review';
                                $model_analysis[$i]->level1_answer = $items['answer'];
                                $model_analysis[$i]->level1_score = $items['score'];
                            }else if($level==2){
                                $model_analysis[$i]->scenario= 'level2review';
                                $model_analysis[$i]->level2_answer = $items['answer'];
                                $model_analysis[$i]->level2_score = $items['score'];
                            }else if($level==3){
                                $model_analysis[$i]->scenario= 'level3review';
                                $model_analysis[$i]->level3_answer = $items['answer'];
                                $model_analysis[$i]->level3_score = $items['score'];
                            }else if($level==4){
                                $model_analysis[$i]->scenario= 'level4review';
                                $model_analysis[$i]->level4_answer = $items['answer'];
                                $model_analysis[$i]->level4_score = $items['score'];
                            }else if($level==5){
                                $model_analysis[$i]->scenario= 'level5review';
                                $model_analysis[$i]->level5_answer = $items['answer'];
                                $model_analysis[$i]->level5_score = $items['score'];
                            }
                            $model_analysis[$i]->updated_by= Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');                   

                            $valid=$model_analysis[$i]->validate() && $valid;
                        }
                    }
                }
                //End Analysis Data
                $model->save();
                if ($valid) {
                    $model->save();
                    //Save Analysis
                    if (!empty($model_analysis)) {
                        foreach ($model_analysis as $eachModel) {
                            $eachModel->save();
                        }
                    }
                    if($status==3 || $status==5 || $status==7 || $status==9 || $status==11 || $status==12){
                        //Mail
//                        $model_settings = HrGenerelSettings::model()->find();
//                        $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="24"'));
//                        if(!empty($model_settings)){
//                            if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                                 Yii::import('application.modules.hr.controllers.MailController');
//                                 MailController::sendmail(24,$model->employee_id,$model->id);
//                            }
//                        }
                    }
                    $data['status'] = 'success';
                } else {
                    $data['status'] = 'error';
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                    $error = array_merge_recursive($error1, $error2);
                    foreach($error as $a=>$eacherror){
                        $other[]= $eacherror[0];
                    }      
                    if ($error != '[]'){
                        $data['msg'] =implode(',',$other);
                    }
                }
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Appraisal Details';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionDashboardDetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $model_employee = Employee::model()->findbyPK($employee_id);
            $year=date('Y');
            //Leave This Month
            $data=array();
                $model_master_leave = MasLeave::model()->findAll(array('condition' => 'branch_id="' . $model_employee->branch_or_sponsor_id . '"', 'limit' => 3,'order' => 'id asc'));
                foreach ($model_master_leave as $f => $leave) {
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $leave->id . '" and employee_id="' .$employee_id. '" and leave_year="' . $year . '"'));
                    $leave_current_balance=$leave_taken=$leave_encashed=0;
                    if($model_leave->leave_current_balance>0){
                        $leave_current_balance=$model_leave->leave_current_balance;
                    }
                    $model_leave_taken = EmployeeLeaveDetail::model()->find(array('select' => 'sum(no_days) as no_days', 'condition' => 'YEAR(leave_start_date)>="' . $year . '" AND employee_id="' .$employee_id. '" AND leave_type="' . $leave->id . '" and leave_status="12"'));
                    if($model_leave_taken->no_days>0){
                        $leave_taken=$model_leave_taken->no_days;
                    }
                    $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => 'status="12" and leave_type_id="' . $leave->id . '" and encashment_year="' . $year . '" and employee_id="' .$employee_id. '"'));
                    if($model_leave_encashable_approved->encashable_leave){
                        $leave_encashed=$model_leave->encashable_leave;
                    }
                    $total_leave_taken = $leave_taken+ $leave_encashed;
                    $data[$f]['leave']= $leave->leave_name;
                    $data[$f]['total_leave_taken']= $total_leave_taken;
                    $data[$f]['leave_balance']= $leave_current_balance;
                    $data[$f]['leave_taken']= $leave_taken;
                    $data[$f]['leave_encashed']= $leave_encashed;
                    $data[$f]['total_leave_year']= $total_leave_taken+$leave_current_balance;
                }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionChangepassword() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $old_password = $data_array['old_password'];
            $new_password = $data_array['new_password'];
            $login_user_id = $data_array['id'];
            $arr_user_details = User::model()->findByPk($login_user_id);
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $status = "success";
            $password = crypt($old_password, $salt);
            if ($arr_user_details->password == $password) {
                $new_password = crypt($new_password, $salt);
                $arr_user_details->password = $new_password;
                $arr_user_details->password_reset = 'Y';
                $arr_user_details->save(false);
                $status = "success";
                $error_message = "Password Changed Successfully";
            } else {
                $status = "error";
                $error_message = "Error.Please check password";
            }
            $data = ["status" => $status, "message" => $error_message];
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[]= array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }


    public function actionNotificationDetails() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response=array();
        $data=[];
      //  print_r($userModel);die;
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            if($employee_id  >0){
            $model_employee = Employee::model()->findbyPK($employee_id);
            $leave_approve_cancel=$total_notification=$leave_history=$leave_approval_encash=$leave_encash_history=$loan_approval=$loan_history=$advance_approval=$advance_history=$certificate_approval=$certificate_history=$ptime_history=$excuse_approval=0;
            $expense_approval=$expense_history=$resignation_approval=$resignation_history=$purchase_approval=$purchase_history=$appraisal_review=$ticket_encashment_approval=$ticket_encashment_history=$staff_board=$circular=$notice_conduct=$document_expiry=0;
            $model_hr_settings = HrGenerelSettings::model()->find();
            $array_hr_permission = json_decode($model_hr_settings->app_permission);
            //Leave Approval
            $model_module_leave = HrModules::model()->findByPK(3);
            if ($array_hr_permission->leave_view == 1 && $model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y'):
                    $model_leave_notification_approval = EmployeeLeaveDetail::getintermediateapproval($employee_id, 2);
                    if ($model_leave_notification_approval > 0) {
                        $leave_approve_cancel = $model_leave_notification_approval;
                        // $total_notification += $model_leave_notification_approval;
                        $total_notification += 1;
                        $data[] = array('notification' => 'Leave Approval', 'screenview' => 'LA');
                    }
            endif;
            //end leave approval
            $model_module_employee = HrModules::model()->findByPK(1);
            if ($array_hr_permission->document_view == 1 && $model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y'):
                $remind_day = date("Y-m-d", strtotime("+7  days"));
                $model_empl_documents = EmployeeDocuments::model()->with('document')->count(array('condition' => 'employee_id="' . $employee_id . '" and document.isActive="Y" AND view_in_employee = "Y" AND validate_till_date<="'.$remind_day.'"'));

                if($model_empl_documents>0){
                   // $total_notification += $model_empl_documents;
                    $document_expiry+= $model_empl_documents;
                    $total_notification += 1;
                    $data[]=array('notification'=>'Document Expiry','screenview'=>'DE');
                }
            endif;
            //Final Approved/Rejected Leave
            if ($array_hr_permission->leave_view == 1 && $model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y'):
                    $model_hrleave_notification = EmployeeLeaveDetail::model()->with('employeedetail')->count(array('condition' => 'employee_id="' . $employee_id . '" and (leave_status="12" OR leave_status="13") and view_status="0"'));
                    if ($model_hrleave_notification > 0) {
                        // $total_notification += $model_hrleave_notification;
                        $leave_history += $model_hrleave_notification;
                        $total_notification += 1;
                        $data[] = array('notification' => 'Leave History', 'screenview' => 'LH');
                    }
                    //Cancelled Leave
                    $model_hrcanceleave_notification = EmployeeLeaveDetail::model()->with('employeedetail')->count(array('condition' => 'employee_id="' . $employee_id . '" and (leave_status="25" OR leave_status="26") and hr_cancel_view_status="0"'));
                    if ($model_hrcanceleave_notification > 0) {
                        // $total_notification += $model_hrcanceleave_notification;
                        $total_notification += 1;
                        $leave_history += $model_hrcanceleave_notification;
                        $data[] = array('notification' => 'Leave History', 'screenview' => 'LH');
                    }
            endif;
                //Leave Encashment
            //Pending Approval
            $model_module_leave_encash = HrModules::model()->findByPK(4);
            if ($array_hr_permission->leave_encashment_view == 1 && $model_module_leave_encash->grant_access == 1 && $model_module_leave_encash->isActive == 'Y'):
                $model_encashment_approval_notification = EmployeeLeaveEncashment::getintermediateapproval($employee_id,2);
                if($model_encashment_approval_notification>0){
                 //   $total_notification += $model_encashment_approval_notification;
                    $total_notification += 1;
                    $leave_approval_encash+= $model_encashment_approval_notification;
                    $data[]=array('notification'=>'Leave Encash Approval','screenview'=>'');
                }
                //Leave Encashment History
                $model_encashment_notification = EmployeeLeaveEncashment::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and status="12" and view_status="0"'));
                if($model_encashment_notification>0){
                  //  $total_notification += $model_encashment_notification;
                    $total_notification += 1;
                    $leave_encash_history+= $model_encashment_notification;
                    $data[]=array('notification'=>'Leave Encash History','screenview'=>'');
                }
            endif;
            //Loan
            //Pending Approval
            $model_module_loan = HrModules::model()->findByPK(6);
            if ($array_hr_permission->loan_view == 1 && $model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y'):
                $model_loan_notification_approval = EmployeeLoanDetail::getintermediateapproval($employee_id,2);
                if($model_loan_notification_approval>0){
                 //   $total_notification += $model_loan_notification_approval;
                    $total_notification += 1;
                    $loan_approval+= $model_loan_notification_approval;
                    $data[]=array('notification'=>'Loan Approval','screenview'=>'LOA');
                }
                $model_loan_notification = EmployeeLoanDetail::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and (loan_status="12" OR loan_status="13") and view_status="0"'));
                if($model_loan_notification>0){
                 //   $total_notification += $model_loan_notification;
                    $total_notification += 1;
                    $loan_history+= $model_loan_notification;
                    $data[]=array('notification'=>'Loan History','screenview'=>'LOH');
                }
            endif;
            //End Loan
            //Salary Advance
            //Pending Approval
            $model_module_salary_advance =HrModules::model()->findByPK(5);
            if ($array_hr_permission->salary_advance_view == 1 && $model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y'):
                $model_advance_notification_approval = EmployeeSalaryAdvance::getintermediateapproval($employee_id,2);
                if($model_advance_notification_approval>0){
                //    $total_notification += $model_advance_notification_approval;
                    $total_notification += 1;
                    $advance_approval += $model_advance_notification_approval;
                    $data[]=array('notification'=>'Salary Advance Approval','screenview'=>'SA');
                }
                $model_salaryadvance_notification = EmployeeSalaryAdvance::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and (advance_payment_status="12" OR advance_payment_status="13") and view_status="0"'));                       
                if($model_salaryadvance_notification>0){
                 //   $total_notification += $model_salaryadvance_notification;
                    $total_notification += 1;
                    $advance_history+= $model_salaryadvance_notification;
                    $data[]=array('notification'=>'Salary Advance History','screenview'=>'SH');
                }
            endif;
            //Start Document request
            //Pending Approval
        /*    $model_certificate_notification_approval = EmployeeCertificate::getintermediateapproval($employee_id,2);
            if($model_certificate_notification_approval>0){
               // $total_notification += $model_certificate_notification_approval;
                $total_notification += 1;
                $certificate_approval += $model_certificate_notification_approval;
                $data[]=array('notification'=>'Employee Certificate Approval','screenview'=>'');
            }*/
            $model_module_doc_request= HrModules::model()->findByPK(10);
            if ($array_hr_permission->certificate_view == 1 && $model_module_doc_request->grant_access == 1 && $model_module_doc_request->isActive == 'Y'):
                $model_certificate_notification = EmployeeCertificate::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and status="12" and view_status="0"'));
                if($model_certificate_notification>0){
                  //  $total_notification += $model_certificate_notification;
                    $total_notification += 1;
                    $certificate_history += $model_certificate_notification;
                    $data[]=array('notification'=>'Employee Certificate History','screenview'=>'CH');
                }
            endif;
            //End Document Request
            //Start Expense request
            //Pending Approval
            $model_module_expense= HrModules::model()->findByPK(11);
            if ($array_hr_permission->expense_view == 1 && $model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y'):
                $model_expense_notification_approval = EmployeeExpense::getintermediateapproval($employee_id,2);
                if($model_expense_notification_approval>0){
                 //   $total_notification += $model_expense_notification_approval;
                    $total_notification += 1;
                    $expense_approval += $model_expense_notification_approval;
                    $data[]=array('notification'=>'Employee Expense Approval','screenview'=>'EA');

                }
                //Employee notification after expense approval
                $model_expense_notification = EmployeeExpense::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_expense_notification>0){
                //    $total_notification += $model_expense_notification;
                    $total_notification += 1;
                    $expense_history += $model_expense_notification;
                    $data[]=array('notification'=>'Employee Expense','screenview'=>'EH');
                }
            endif;
            //End Expense Request
            //Start Resignation request
            //Pending Approval
            
             /* if ($array_hr_permission->resignation_view == 1):
                $model_resignation_notification_approval = EmployeeResignation::getintermediateapproval($employee_id,2);
                if($model_resignation_notification_approval>0){
                 //   $total_notification += $model_resignation_notification_approval;
                    $total_notification += 1;
                    $resignation_approval += $model_resignation_notification_approval;
                    $data[]=array('notification'=>'Employee Resignation Approval','screenview'=>'');
                }
                //Employee notification after resignation approval
                $model_resignation_notification = EmployeeResignation::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_resignation_notification>0){
                  //  $total_notification += $model_resignation_notification;
                    $total_notification += 1;
                    $resignation_history += $model_resignation_notification;
                    $data[]=array('notification'=>'Employee Resignation History','screenview'=>'');
                }
            endif;
            //End Resignation Request
            //Pending Approval
           if ($array_hr_permission->purchase_view == 1):
                $model_purchase_notification_approval = EmployeePurchase::getintermediateapproval($employee_id,2);
                if($model_purchase_notification_approval>0){
                 //   $total_notification += $model_purchase_notification_approval;
                    $total_notification += 1;
                    $purchase_approval += $model_purchase_notification_approval;
                    $data[]=array('notification'=>'Purchase Approval','screenview'=>'');
                }
                //Employee notification after purchase approval
                $model_purchase_notification = EmployeePurchase::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_purchase_notification>0){
                //    $total_notification += $model_purchase_notification;
                    $total_notification += 1;
                    $purchase_history += $model_purchase_notification;
                    $data[]=array('notification'=>'Purchase History','screenview'=>'');
                }
            endif;
             //Pending Approval
            if ($array_hr_permission->appraisal_view == 1):
            $model_apprasial_notification_approval = HrAppraisal::getintermediateapproval($employee_id,2);
            if($model_apprasial_notification_approval>0){
              //  $total_notification += $model_apprasial_notification_approval;
                $total_notification += 1;
                $appraisal_review += $model_apprasial_notification_approval;
                $data[]=array('notification'=>'Apprisal Approval','screenview'=>'');
            }
            endif;
             //Pending Approval
            if ($array_hr_permission->ticket_encashment_view == 1):
                $model_tktencashment_notification_approval = EmployeeTicketEncashment::getintermediateapproval($employee_id,2);
                if($model_tktencashment_notification_approval>0){
                   // $total_notification += $model_tktencashment_notification_approval;
                    $total_notification += 1;
                    $ticket_encashment_approval += $model_tktencashment_notification_approval;
                    $data[]=array('notification'=>'Ticket Encash Approval','screenview'=>'');
                }
                //Employee notification after purchase approval
                $model_tktencashment_notification = EmployeeTicketEncashment::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_tktencashment_notification>0){
                 //   $total_notification += $model_tktencashment_notification;
                    $total_notification += 1;
                    $ticket_encashment_history += $model_tktencashment_notification;
                    $data[]=array('notification'=>'Ticket Encash History','screenview'=>'LA');
                }
            endif;*/
            //Staff Board
            $model_module_staffboard= HrModules::model()->findByPK(22);
            if ($array_hr_permission->staff_board_view == 1 && $model_module_staffboard->grant_access == 1 && $model_module_staffboard->isActive == 'Y'):
                $model_general_notification = HrNotification::model()->count(array('condition' => '(FIND_IN_SET("' . $model_employee->department . '",department_id) OR FIND_IN_SET("' . $model_employee->designation . '",designation) OR FIND_IN_SET("' . $model_employee->branch_or_sponsor_id . '",branch)) AND (FIND_IN_SET("' . $model_employee->id . '",employee_id) AND !FIND_IN_SET("' . $model_employee->id . '",read_status))'));

                if($model_general_notification>0){
                 //   $total_notification += $model_general_notification;
                    $total_notification += 1;
                    $staff_board += $model_general_notification;
                    $data[]=array('notification'=>'Staff board','screenview'=>'SB');
                }
            endif;
            //Circular
            //Start Circular
            $model_module_circular = HrModules::model()->findByPK(18);
            if ($array_hr_permission->circular_view == 1 && $model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y'):
                $model_circular = CompanyCircular::model()->count(array('condition' => 'isActive="Y" and (circular_type="1" OR circular_type="2") and ((branch_or_sponsor_id="" OR FIND_IN_SET("'.$model_employee->branch_or_sponsor_id.'",branch_or_sponsor_id)) AND (employee_id="" OR FIND_IN_SET("'.$model_employee->id.'",employee_id)) AND !FIND_IN_SET("'.$model_employee->id.'",employees_viewed))'));

                if($model_circular>0){
                  //  $total_notification += $model_circular;
                    $total_notification += 1;
                    $circular += $model_circular;
                    $data[]=array('notification'=>'Circular','screenview'=>'C');
                }
            endif;
            //End Circular
            //Pending Approval
            $model_module_flexitime= HrModules::model()->findByPK(32);
            if ($array_hr_permission->late_in_view == 1 && $model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y'):
                $model_excuse_approval = HrEmployeeAttendanceExcuse::getintermediateapproval($model_employee->id,2);
                if($model_excuse_approval>0){
                    $total_notification += 1;
                    $excuse_approval += $model_excuse_approval;
                    $data[]=array('notification'=>'Meeting/Flexi Time','screenview'=>'PT');
                }

                $model_ptimeoff_notification = HrEmployeeAttendanceExcuse::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$model_employee->id.'" and (status="12" OR status="13") and view_status="0"'));
                if($model_ptimeoff_notification>0){
                    $total_notification += $model_ptimeoff_notification;
                    $ptime_history+= $model_loan_notification;
                    $data[]=array('notification'=>'Meeting/Flexi Time','screenview'=>'PT');
                }
            endif;
             //Start Notice of Conduct
        /*    $model_module_notice_conduct= HrModules::model()->findByPK(24);
            if ($array_hr_permission->notice_conduct_view == 1 && $model_module_notice_conduct->grant_access == 1 && $model_module_notice_conduct->isActive == 'Y'):
            $model_notice_conduct = EmployeeNoticeConduct::model()->count(array('condition' => 'view_status="0" AND employee_id="'.$employee_id.'"'));
                if($model_notice_conduct>0){
                  //  $total_notification += $model_notice_conduct;
                    $total_notification += 1;
                    $notice_conduct += $notice_conduct;
                    $data[]=array('notification'=>'Notice of Conduct','screenview'=>'');
                }
            endif;*/
            //End Notice of Conduct
            $response = array('status'=>"success",'msg' => "success",'data'=>$data,"total_notification" => $total_notification);
            if($total_notification==0){
            $response = array('status'=>"failed",'msg' => "No new Notification","total_notification" => 0,'data'=>$data);
        }
    }else{
       $response = array('status'=>"failed",'msg' => "Employee id missing",'data'=>$data); 
    }
         }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response= array('status' => "failed","msg"=>"Unauthorized user");
        }
        
        echo CJSON::encode($response);
    }


    public function actionNotificationCount() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response=array();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            if($employee_id  >0){
            $model_employee = Employee::model()->findbyPK($employee_id);
            $total_notification=0;
            $model_hr_settings = HrGenerelSettings::model()->find();
            $array_hr_permission = json_decode($model_hr_settings->app_permission);
            //Leave Approval
           if ($array_hr_permission->leave_view == 1 && $model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y'):
                $model_leave_notification_approval = EmployeeLeaveDetail::getintermediateapproval($employee_id,2);
                if($model_leave_notification_approval>0){
                   // $total_notification += $model_leave_notification_approval;
                    $total_notification += 1;
                }
                //Final Approved/Rejected Leave
                $model_hrleave_notification = EmployeeLeaveDetail::model()->with('employeedetail')->count(array('condition' =>'employee_id="'.$employee_id.'" and (leave_status="12" OR leave_status="13") and view_status="0"'));
                if($model_hrleave_notification>0){
                  //  $total_notification += $model_hrleave_notification;
                    $total_notification += 1;
                }
                //Cancelled Leave
                $model_hrcanceleave_notification = EmployeeLeaveDetail::model()->with('employeedetail')->count(array('condition' =>'employee_id="'.$employee_id.'" and (leave_status="25" OR leave_status="26") and hr_cancel_view_status="0"'));
                if($model_hrcanceleave_notification>0){
                   // $total_notification += $model_hrcanceleave_notification;
                    $total_notification += 1;
                }
            endif;
            //Leave Encashment
            //Pending Approval
            $model_module_leave_encash = HrModules::model()->findByPK(4);
            if ($array_hr_permission->leave_encashment_view == 1 && $model_module_leave_encash->grant_access == 1 && $model_module_leave_encash->isActive == 'Y'):
                $model_encashment_approval_notification = EmployeeLeaveEncashment::getintermediateapproval($employee_id,2);
                if($model_encashment_approval_notification>0){
                  //  $total_notification += $model_encashment_approval_notification;
                    $total_notification += 1;
                }
                //Leave Encashment History
                $model_encashment_notification = EmployeeLeaveEncashment::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and status="12" and view_status="0"'));
                if($model_encashment_notification>0){
                  //  $total_notification += $model_encashment_notification;
                    $total_notification += 1;
                }
            endif;
            //Loan
            //Pending Approval
            $model_module_loan = HrModules::model()->findByPK(6);
            if ($array_hr_permission->loan_view == 1 && $model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y'):
                $model_loan_notification_approval = EmployeeLoanDetail::getintermediateapproval($employee_id,2);
                if($model_loan_notification_approval>0){
                  //  $total_notification += $model_loan_notification_approval;
                    $total_notification += 1;
                }
                $model_loan_notification = EmployeeLoanDetail::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and (loan_status="12" OR loan_status="13") and view_status="0"'));
                if($model_loan_notification>0){
                   // $total_notification += $model_loan_notification;
                    $total_notification += 1;
                }
            endif;
            //End Loan
            //Salary Advance
            //Pending Approval
            $model_module_salary_advance =HrModules::model()->findByPK(5);
            if ($array_hr_permission->salary_advance_view == 1 && $model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y'):
                $model_advance_notification_approval = EmployeeSalaryAdvance::getintermediateapproval($employee_id,2);
                if($model_advance_notification_approval>0){
                   // $total_notification += $model_advance_notification_approval;
                    $total_notification += 1;
                }
                $model_salaryadvance_notification = EmployeeSalaryAdvance::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and (advance_payment_status="12" OR advance_payment_status="13") and view_status="0"'));                       
                if($model_salaryadvance_notification>0){
                   // $total_notification += $model_salaryadvance_notification;
                    $total_notification += 1;
                }
            endif;
            //Start Document request
            //Pending Approval
        /*    $model_certificate_notification_approval = EmployeeCertificate::getintermediateapproval($employee_id,2);
            if($model_certificate_notification_approval>0){
               // $total_notification += $model_certificate_notification_approval;
                $total_notification += 1;
            }*/
            $model_module_doc_request= HrModules::model()->findByPK(10);
            if ($array_hr_permission->certificate_view == 1 && $model_module_doc_request->grant_access == 1 && $model_module_doc_request->isActive == 'Y'):
                $model_certificate_notification = EmployeeCertificate::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and status="12" and view_status="0"'));
                if($model_certificate_notification>0){
                   // $total_notification += $model_certificate_notification;
                    $total_notification += 1;
                }
            endif;
            //End Document Request
            //Start Expense request
            //Pending Approval
            $model_module_expense= HrModules::model()->findByPK(11);
            if ($array_hr_permission->expense_view == 1 && $model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y'):
                $model_expense_notification_approval = EmployeeExpense::getintermediateapproval($employee_id,2);
                if($model_expense_notification_approval>0){
                  //  $total_notification += $model_expense_notification_approval;
                    $total_notification += 1;
                }
                //Employee notification after expense approval
                $model_expense_notification = EmployeeExpense::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_expense_notification>0){
                   // $total_notification += $model_expense_notification;
                    $total_notification += 1;
                }
            endif;
            //End Expense Request
            //Start Resignation request
            //Pending Approval
           /* if ($array_hr_permission->resignation_view == 1):
                $model_resignation_notification_approval = EmployeeResignation::getintermediateapproval($employee_id,2);
                if($model_resignation_notification_approval>0){
                  // $total_notification += $model_resignation_notification_approval;
                    $total_notification += 1;
                }
                    //Employee notification after resignation approval
                    $model_resignation_notification = EmployeeResignation::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                    if($model_resignation_notification>0){
                       // $total_notification += $model_resignation_notification;
                        $total_notification += 1;
                    }
            endif;    
            //End Resignation Request
            //Pending Approval
            if ($array_hr_permission->purchase_view == 1):
                $model_purchase_notification_approval = EmployeePurchase::getintermediateapproval($employee_id,2);
                if($model_purchase_notification_approval>0){
                   // $total_notification += $model_purchase_notification_approval;
                    $total_notification += 1;
                }
                //Employee notification after purchase approval
                $model_purchase_notification = EmployeePurchase::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_purchase_notification>0){
                 //   $total_notification += $model_purchase_notification;
                    $total_notification += 1;
                }
            endif;
             //Pending Approval
            if ($array_hr_permission->appraisal_view == 1):
                $model_apprasial_notification_approval = HrAppraisal::getintermediateapproval($employee_id,2);
                if($model_apprasial_notification_approval>0){
                   // $total_notification += $model_apprasial_notification_approval;
                    $total_notification += 1;
                }
            endif;
             //Pending Approval
            if ($array_hr_permission->ticket_encashment_view == 1):
                $model_tktencashment_notification_approval = EmployeeTicketEncashment::getintermediateapproval($employee_id,2);
                if($model_tktencashment_notification_approval>0){
                   // $total_notification += $model_tktencashment_notification_approval;
                    $total_notification += 1;
                }
                //Employee notification after purchase approval
                $model_tktencashment_notification = EmployeeTicketEncashment::model()->with('employeedetail')->count(array('condition' => 'view_status="0" and employee_id="'.$employee_id.'" and status="12"'));
                if($model_tktencashment_notification>0){
                   // $total_notification += $model_tktencashment_notification;
                    $total_notification += 1;
                }
            endif;*/
            //Staff Board
             $model_module_staffboard= HrModules::model()->findByPK(22);
            if ($array_hr_permission->staff_board_view == 1 && $model_module_staffboard->grant_access == 1 && $model_module_staffboard->isActive == 'Y'):
                $model_general_notification = HrNotification::model()->count(array('condition' => '(FIND_IN_SET("' . $model_employee->department . '",department_id) OR FIND_IN_SET("' . $model_employee->designation . '",designation) OR FIND_IN_SET("' . $model_employee->branch_or_sponsor_id . '",branch)) AND (FIND_IN_SET("' . $model_employee->id . '",employee_id) AND !FIND_IN_SET("' . $model_employee->id . '",read_status))'));
                if($model_general_notification>0){
                   // $total_notification += $model_general_notification;
                    $total_notification += 1;
                }
            endif;
            //Circular
            //Start Circular
            $model_module_circular = HrModules::model()->findByPK(18);
            if ($array_hr_permission->circular_view == 1 && $model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y'):
                $model_circular = CompanyCircular::model()->count(array('condition' => 'isActive="Y" and (circular_type="1" OR circular_type="2") and ((branch_or_sponsor_id="" OR FIND_IN_SET("'.$model_employee->branch_or_sponsor_id.'",branch_or_sponsor_id)) AND (employee_id="" OR FIND_IN_SET("'.$model_employee->id.'",employee_id)) AND !FIND_IN_SET("'.$model_employee->id.'",employees_viewed))'));

                if($model_circular>0){
                   // $total_notification += $model_circular;
                    $total_notification += 1;
                }
            endif;
            
            $model_module_employee = HrModules::model()->findByPK(1);
            if ($array_hr_permission->document_view == 1 && $model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y'):
                $remind_day = date("Y-m-d", strtotime("+7  days"));
                $model_empl_documents = EmployeeDocuments::model()->with('document')->count(array('condition' => 'employee_id="' . $employee_id . '" and document.isActive="Y" AND view_in_employee = "Y" AND validate_till_date<="'.$remind_day.'"'));
                if($model_empl_documents>0){
                   // $total_notification += $model_empl_documents;
                    $total_notification += 1;
                }
            endif;
            //End Circular
             //Start Notice of Conduct
    /*        if ($array_hr_permission->notice_conduct_view == 1):
                $model_notice_conduct = EmployeeNoticeConduct::model()->count(array('condition' => 'view_status="0" AND employee_id="'.$employee_id.'"'));
                if($model_notice_conduct>0){
                   // $total_notification += $model_notice_conduct;
                    $total_notification += 1;
                }
            endif; */
            //End Notice of Conduct
             $model_module_flexitime= HrModules::model()->findByPK(32);
            if ($array_hr_permission->late_in_view == 1 && $model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y'):
                $model_ptimeoff_notification = HrEmployeeAttendanceExcuse::model()->with('employeedetail')->count(array('condition' => 'employee_id="'.$employee_id.'" and (status="12" OR status="13") and view_status="0"'));
                if($model_ptimeoff_notification>0){
                    $total_notification += 1; 
                }
                $model_excuse_approval = HrEmployeeAttendanceExcuse::getintermediateapproval($model_employee->id,2);
                if($model_excuse_approval>0){
                    $total_notification += 1;
                }
            endif;
            $response = array('status'=>"success",'msg' => "success","total_notification" => $total_notification);
            if($total_notification==0){
            $response = array('status'=>"failed",'msg' => "No new Notification","total_notification" => 0);
        }
    }else{
       $response = array('status'=>"failed",'msg' => "Employee id missing"); 
    }
         }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response= array('status' => "failed","msg"=>"Unauthorized user");
        }
        
        echo CJSON::encode($response);
    }
    public function actionbirthdaylist() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response =array();
        if ($userModel->id > 0) {
            $show_type='N'; //Y- ALL N- No
            $data_array = json_decode(file_get_contents('php://input'), true);
            $model_hr_settings = HrGenerelSettings::model()->find();
            $array_app_permission = json_decode($model_hr_settings->app_permission);
            if ($array_app_permission->birthday_view == 1):
                $show_type='Y';
            endif;
            $arr_employee_birthdays = Employee::model()->findAll(array('select' => 'id,employee_code,first_name,last_name,date_of_birth,email', 'condition' => 'isActive="Y" AND (MONTH(`date_of_birth`)= MONTH(CURRENT_DATE) AND (DAY(`date_of_birth`) = DAY(CURRENT_DATE)) )', 'order' => 'DAY( `date_of_birth` )'));
            $data = array();
            $emp_ids=array();
        foreach ($arr_employee_birthdays AS $row) {
            $emp_ids[]= $row->id;
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeefullname,
                    "employeecode" => $row->employeecode,
                    "birth_day" => $row->date_of_birth,
                );
            }
            $response = array('status'=>"success",'msg' => "success",'data'=>$data,'emp_ids'=>$emp_ids,'show_type'=>$show_type);
            if (empty($data)) {
            $response = array('status'=>"failed",'msg' => "No data available",'data'=>$data,'emp_ids'=>$emp_ids,'show_type'=>$show_type);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($response);
    }




}
