<?php
class ApiemployeeexpenseController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('expenseTypes', 'currencyTypes', 'SaveExpense', "UploadDocument", "viewExpensedetails", "DeleteExpense", "SaveExpenseLmApproval", "EditSaveExpense", "GetExpenseHistory", "GetExpenseApproval", "ViewexpenseLM"),
                'users' => array('*'),
            ),
        );
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action) {
        //for db connection added by nisha on 27-03-2023
        $this->ChangeDB();
        return true;
    }
    public function actionexpenseTypes() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $data = [];
            $condition = 'isActive =  "Y"';
            $model = HrMasEmployeeExpense::model()->findAll(array('condition' => $condition, 'order' => 'expense_component asc'));
            foreach ($model as $row => $val) {
                $data[] = [
                    "id" => (string) $val->id,
                    "expense_name" => $val->expense_component,
                ];
            }
            $response = array('status' => "success", "msg" => "success", "data" => $data);
            if (empty($data)) {
                $response = array('status' => "failed", "msg" => "No data available", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actioncurrencyTypes() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $data = [];
            $condition = 't.isActive =  "Y"';
            $model = MasCurrency::model()->findAll(array('condition' => $condition, 'order' => 'isBaseCurrency, currency_code'));
            foreach ($model as $row => $val) {
                $data[] = [
                    "id" => (string) $val->id,
                    "currency_name" => $val->currency_code,
                ];
            }
            $response = array('status' => "success", "msg" => "success", "data" => $data);
            if (empty($data)) {
                $response = array('status' => "failed", "msg" => "No data available", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actionSaveExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $validate = true;
                $model = new EmployeeExpense();
                if ((int) @$data_array['id'] > 0) {
                    $model->id = (int) $data_array['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by = $userModel->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model->created_by = $userModel->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                $empid = $userModel->employee_id;
                $employee = Employee::model()->findbypk($empid);
                $model->employee_id = $empid;
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $empid . '" and functionality_id="7"'));
                $model->last_approved_level = 0;
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
                $model->total = $data_array['total'];
                $model->created_date = date('Y-m-d');
                $model->status = 1;
                $validate = $model->validate();
                if (isset($data_array['EmployeeExpenseDetails'])) {
                    foreach ($data_array['EmployeeExpenseDetails'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modalexpensedetails[$i] = EmployeeExpenseDetails::model()->findByPK($items['id']);
                        } else {
                            $modalexpensedetails[$i] = new EmployeeExpenseDetails();
                        }
                        $modalexpensedetails[$i]->expense_date = str_replace('/', '-', $items['expense_date']);
                        $modalexpensedetails[$i]->expense_date = date("Y-m-d", strtotime($modalexpensedetails[$i]->expense_date));
                        $modalexpensedetails[$i]->notes = $items['notes'];
                        $modalexpensedetails[$i]->expense_component_id = $items['expense_component_id'];
                        $modalexpensedetails[$i]->employee_id = $model->employee_id;
                        $modalexpensedetails[$i]->amount = $items['amount'];
                        $modalexpensedetails[$i]->currency_id = $items['currency_id'];
                        $modalexpensedetails[$i]->exchange_rate = $items['exchange_rate'];
                        $modalexpensedetails[$i]->grand_total = $items['grand_total'];
                        $modalexpensedetails[$i]->file = $items['file'];
                        $validate = $modalexpensedetails[$i]->validate() && $validate;
                    }
                }
                if ($validate) {
                    if ($model->save()) {
                        if (!empty($modalexpensedetails)) {

                            foreach ($modalexpensedetails as $eachModel) {
                                $eachModel->expense_id = $model->id;
                                $eachModel->save();
                            }
                        }
                        //Mail

                        $model_settings = HrGenerelSettings::model()->find();

                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="9"'));

                        if (!empty($model_settings)) {

                            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {

                                Yii::import('application.modules.hr.controllers.MailController');

                                MailController::sendmail(9, $model->employee_id, $model->id);
                            }
                        }
                    }
                    $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                } else {

                    $errors = $model->errors;
                    foreach ($model->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    foreach ($modalexpensedetails as $t => $value) {
                        foreach ($modalexpensedetails[$t]->errors as $k => $val) {
                            $arr_err[] = $val[0];
                        }
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "msg" => "Unauthorized user");
            }
            echo json_encode($response);
        }
    }

    public function actionUploadDocument($folder = null) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $model_upload_document = HrMasterUpload::model()->findByPK(28);
            if ($model_upload_document->isActive == 'Y') {
                $upload_size = $model_upload_document->max_upload_size * 1024 * 1024;
                $employee_id = $userModel->employee_id;
                $certificate_name = $_FILES["file"]["name"];
                $extension = pathinfo($certificate_name, PATHINFO_EXTENSION);
                $fileSize = $_FILES["file"]['size'];
                if ($fileSize < $upload_size) {
                    $model_employee= Employee::model()->findbyPK($employee_id);
                    //$model_employee=
                    $current_date =date('Y-m-d H:i:s');
                    $new_file_name="Expense_";
                    if(!empty($model_employee)){
                        $new_file_name.=str_replace(' ', '_', $model_employee->employeecode);
                    }
                    $new_file_name.='_'.$current_date.'_'.uniqid().'.'.$extension;
                    $folder = Yii::getPathOfAlias('webroot') . '/uploads/expense/' . $new_file_name;
                    move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
                    $response = array('status' => "success", "msg" => "success", "filename" => $new_file_name);
                } else {
                    $response = array('status' => "failed", "msg" => "File too large. Maximum size is " . $model_upload_document->max_upload_size . " MB","filename" => '', "token_status" => "UA");
                }
            } else {
                $response = array('status' => "failed", "msg" => "Document uploads are not allowed under your current subscription plan","filename" => '', "token_status" => "UA");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionGetExpenseHistory() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $condition = 't.employee_id="' . $employee_id . '"';
            $model = new EmployeeExpense();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));

            foreach ($model as $row) {
                $created_date = "";
                $approval_date = "";
                $lm_approve_date = "";
                $edit_button = 0;
                if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                    $created_date = date("d/m/Y", strtotime($row['created_date']));
                }
                if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                    $approval_date = date("d/m/Y", strtotime($row['approved_date']));
                }
                if ($row['status'] == 0 || $row['status'] == 1 || $row['status'] == 3 || $row['status'] == 5 || $row['status'] == 7 || $row['status'] == 9 || $row['status'] == 11 || $row['status'] == 13) {
                    $edit_button = 1;
                }
                $data[] = array(
                    "id" => (string) $row->id,
                    "created_date" => $created_date,
                    "approval_date" => $approval_date,
                    "total" => $row['total'],
                    "edit_button" => $edit_button,
                    "status" => EmployeeExpense::getStatus($row['status']),
                );
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionviewExpensedetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $model = new EmployeeExpense();
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            $apply_date = '-';
            if ($model->created_date != '0000-00-00' && $model->created_date != '') {
                $apply_date = date("d/m/Y", strtotime($model->created_date));
            }
            $approved_date = '';
            if ($model->approved_date != '0000-00-00' && $model->approved_date != '') {
                $approved_date = date("d/m/Y", strtotime($model->approved_date));
            }
            if (!empty($model_details)) {
                foreach ($model_details as $i => $each_details) {
                    $expense_date = '';
                    if ($each_details->expense_date != '' && $each_details->expense_date != '0000-00-00') {
                        $expense_date = date("d/m/Y", strtotime($each_details->expense_date));
                    }
                    $total_amount += $each_details->grand_total;
                    $expense_details[] = array(
                        "id" => (string) $each_details->id,
                        "expense_date" => $expense_date,
                        "expense_name" => $each_details->expensedetail->expense_component,
                        "expense_component_id" => $each_details->expense_component_id,
                        "currency_name" => $each_details->currencydetail->currency_code,
                        "currency_id" => $each_details->currency_id,
                        "exchange_rate" => $each_details->exchange_rate,
                        "grand_total" => $each_details->grand_total,
                        "amount" => $each_details->amount,
                        "notes" => $each_details->notes,
                        "file" => $each_details->file,
                    );
                }
                $data = array("id" => (string) $model->id,
                    "employee_name" => $this->ciphertext($model->employeedetail->first_name, "d") . ' ' . $this->ciphertext($model->employeedetail->last_name, "d"),
                    "employee_code" => $this->ciphertext($model->employeedetail->employee_code, "d"),
                    "apply_date" => $apply_date,
                    "approved_date" => $approved_date,
                    "status" => EmployeeExpense::getStatus($model->status),
                    "expense_details" => $expense_details,
                    "total" => $total_amount
                );
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionDeleteExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $model = EmployeeExpenseDetails::model()->findbyPK($id);
            $path = '';
            if ($model->file != '') {
                $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $model->file;
            }
            $status = $model->deleteByPk($id);
            if ($status == 1) {
                if (file_exists($path)) {
                    unlink($path);
                }
                $response = array('status' => "success", "msg" => "success");
                $data['status'] = 'success';
            } else {
                $response = array('status' => "failed", "msg" => "failed");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionEditSaveExpense() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $validate = true;
                $model = new EmployeeExpense();
                if ((int) @$data_array['id'] > 0) {
                    $model->id = (int) $data_array['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by = $userModel->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                    $empid = $userModel->employee_id;
                    $employee = Employee::model()->findbypk($empid);
                    $model->employee_id = $empid;
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $empid . '" and functionality_id="7"'));
                    $model->last_approved_level = 0;
                    $model->function_type = $model_master_approve_setting->id;
                    $model->total = $data_array['total'];
                    $model->created_date = date('Y-m-d');
                    $model->status = 1;
                    $validate = $model->validate();
                    if (isset($data_array['EmployeeExpenseDetails'])) {
                        foreach ($data_array['EmployeeExpenseDetails'] as $i => $items) {
                            if ($items['id'] > 0) {
                                $modalexpensedetails[$i] = EmployeeExpenseDetails::model()->findByPK($items['id']);
                            } else {
                                $modalexpensedetails[$i] = new EmployeeExpenseDetails();
                            }
                            $modalexpensedetails[$i]->expense_date = str_replace('/', '-', $items['expense_date']);
                            $modalexpensedetails[$i]->expense_date = date("Y-m-d", strtotime($modalexpensedetails[$i]->expense_date));
                            $modalexpensedetails[$i]->notes = $items['notes'];
                            $modalexpensedetails[$i]->expense_component_id = $items['expense_component_id'];
                            $modalexpensedetails[$i]->employee_id = $model->employee_id;
                            $modalexpensedetails[$i]->amount = $items['amount'];
                            $modalexpensedetails[$i]->currency_id = $items['currency_id'];
                            $modalexpensedetails[$i]->exchange_rate = $items['exchange_rate'];
                            $modalexpensedetails[$i]->grand_total = $items['grand_total'];
                            $modalexpensedetails[$i]->file = $items['file'];
                            $validate = $modalexpensedetails[$i]->validate() && $validate;
                        }
                    }
                    if ($validate) {
                        if ($model->save()) {
                            if (!empty($modalexpensedetails)) {

                                foreach ($modalexpensedetails as $eachModel) {
                                    $eachModel->expense_id = $model->id;
                                    $eachModel->save();
                                }
                            }
                            //Mail

                            $model_settings = HrGenerelSettings::model()->find();

                            $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="9"'));

                            if (!empty($model_settings)) {

                                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {

                                    Yii::import('application.modules.hr.controllers.MailController');

                                    MailController::sendmail(9, $model->employee_id, $model->id);
                                }
                            }
                        }
                        $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                    } else {

                        $errors = $model->errors;
                        foreach ($model->errors as $t => $value) {
                            $arr_err[] = $value[0];
                        }
                        foreach ($modalexpensedetails as $t => $value) {
                            foreach ($modalexpensedetails[$t]->errors as $k => $val) {
                                $arr_err[] = $val[0];
                            }
                        }
                        $response = array('status' => 'error', 'msg' => $arr_err);
                    }
                }
            } else {
                $response = array('status' => 'error', 'msg' => "Input parameters missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionGetExpenseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $pending_expense = EmployeeExpense::getintermediateapproval($employee_id, 1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN(' . $pending_expense . ')';

            $model = new EmployeeExpense();
            $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition));

            foreach ($model as $row) {
                $created_date = "";

                $approve_date = "";

                $button_string = "";

                $last_approved_level = $row->last_approved_level;

                $next_approval_level = $last_approved_level + 1;

                $show_approve_button = 0;

                $level_no = 0;

                $final_level = 'N';
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {

                    $show_approve_button = 1;

                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {

                    $show_approve_button = 1;

                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {

                    $show_approve_button = 1;

                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {

                    $show_approve_button = 1;

                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {

                    $show_approve_button = 1;

                    $level_no = 5;
                }


                if ($next_approval_level == $row->approvelevel->max_level) {

                    $final_level = 'Y';
                }


                if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                    $created_date = date("d/m/Y", strtotime($row['created_date']));
                }

                $data[] = array(
                    "id" => $row->id,
                    "employee_code" => $row['employeedetail']['employeecode'],
                    "employee_name" => $row['employeedetail']['employeefullname'],
                    "created_date" => $created_date,
                    "total" => $row['total'],
                    "show_approve_button" => $show_approve_button,
                    "status" => EmployeeExpense::getStatus($row['status']),
                    "next_approval_level" => $level_no,
                    "final_level" => $final_level
                );
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionViewexpenseLM() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $level = $data_array['level'];
            $final_level = $data_array['final_level'];
            $model = new EmployeeExpense();
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            $apply_date = '-';
            if ($model->created_date != '0000-00-00' && $model->created_date != '') {
                $apply_date = date("d/m/Y", strtotime($model->created_date));
            }
            $approved_date = '';
            if ($model->approved_date != '0000-00-00' && $model->approved_date != '') {
                $approved_date = date("d/m/Y", strtotime($model->approved_date));
            }
            foreach ($model_details as $i => $each_details) {
                $expense_date = '';
                if ($each_details->expense_date != '' && $each_details->expense_date != '0000-00-00') {
                    $expense_date = date("d/m/Y", strtotime($each_details->expense_date));
                }
                $total_amount += $each_details->grand_total;
                $expense_details[] = array(
                    "id" => $each_details->id,
                    "expense_date" => $expense_date,
                    "particulars" => $each_details->expensedetail->expense_component,
                    "currency" => $each_details->currencydetail->currency_code,
                    "exchange_rate" => $each_details->exchange_rate,
                    "grand_total" => $each_details->grand_total,
                    "file" => $each_details->file,
                );
            }
            $data = array("id" => $model->id,
                "employee_name" => $this->ciphertext($model->employeedetail->first_name, "d") . ' ' . $this->ciphertext($model->employeedetail->last_name, "d"),
                "employee_code" => $this->ciphertext($model->employeedetail->employee_code, "d"),
                "apply_date" => $apply_date,
                "approved_date" => $approved_date,
                "status" => EmployeeExpense::getStatus($model->status),
                "expense_details" => $expense_details,
                "total" => $total_amount
            );
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionSaveExpenseLmApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $model = new EmployeeExpense();
                if ((int) @$data_array['id'] > 0) {
                    $model->id = (int) $data_array['id'];
                    $model = $model->findByPK($model->id);
                }
                $model->last_approved_level = $data_array['approval_level'];
                $modelemployee = User::model()->findByPK($userModel->id);
                $level = $data_array['approval_level'];
                $final_level = $data_array['final_level'];
                if ($level == 1  && $final_level == 'N') {
                    $model->approve_level1_date = date('Y-m-d');
                    $model->approve_level1_comment = $data_array['approval_comment'];
                    $model->approve_level1_id = $modelemployee->employee_id;
                } else if ($level == 2  && $final_level == 'N') {

                    $model->approve_level2_date = date('Y-m-d');
                    $model->approve_level2_comment = $data_array['approval_comment'];
                    $model->approve_level2_id = $modelemployee->employee_id;
                } else if ($level == 3  && $final_level == 'N') {
                    $model->approve_level3_date = date('Y-m-d');
                    $model->approve_level3_comment = $data_array['approval_comment'];
                    $model->approve_level3_id = $modelemployee->employee_id;
                } else if ($level == 4  && $final_level == 'N') {
                    $model->approve_level4_date = date('Y-m-d');
                    $model->approve_level4_comment = $data_array['approval_comment'];
                    $model->approve_level4_id = $modelemployee->employee_id;
                } else if ($level == 5  && $final_level == 'N') {
                    $model->approve_level5_date = date('Y-m-d');
                    $model->approve_level5_comment = $data_array['approval_comment'];
                    $model->approve_level5_id = $modelemployee->employee_id;
                }
                if ($final_level == 'Y') {
                    $model->approved_date = date('Y-m-d');
                    $model->approval_comment = $data_array['approval_comment'];
                    $model->approved_by = $modelemployee->employee_id;
                }
                $status_v = $data_array['status'];
                if ($final_level == 'Y') {
                    if ($status_v == 'A') {
                        $status = 12;
                    } else {
                        $status = 13;
                    }
                } else if ($level == 1) {
                    if ($status_v == 'A') {
                        $status = 2;
                    } else {
                        $status = 3;
                    }
                } else if ($level == 2) {
                    if ($status_v == 'A') {
                        $status = 4;
                    } else {
                        $status = 5;
                    }
                } else if ($level == 3) {
                    if ($status_v == 'A') {
                        $status = 6;
                    } else {
                        $status = 7;
                    }
                } else if ($level == 4) {
                    if ($status_v == 'A') {
                        $status = 8;
                    } else {
                        $status = 9;
                    }
                } else if ($level == 5) {
                    if ($status_v == 'A') {
                        $status = 10;
                    } else {
                        $status = 11;
                    }
                }
                $model->status = $status;
                $model->updated_date_time = date('Y-m-d H:i:s');

                $model->updated_by = $userModel->id;
                if ($model->validate()) {
                    $model->save();
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="10"'));
                    if (!empty($model_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(10, $model->employee_id, $model->id);
                        }
                    }
                    $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                } else {
                    $errors = $model->errors;
                    foreach ($model->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => 'error', 'msg' => "Input parameters missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
}
