<?php

//added by nisha on 10-10-2024
class ApiattendanceexcuseController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetExcuseList', 'excusefileupload', 'excuseTypes', 'viewExcusedetails', 'SaveExcuse', 'GetExcuseApproval', 'saveApproveRequest','UploadDocument'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        //for db connection added by nisha on 27-03-2023
        $this->ChangeDB();
        return true;
    }

    public function actionGetExcuseList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $condition = "employee_id ='" . $employee_id . "'";
            HrEmployeeAttendanceExcuse::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (status="12" OR status="13")');
            $model = new HrEmployeeAttendanceExcuse();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'order' => 't.id desc'));
            $response = array();
            foreach ($model as $value) {
                $show_btn_edit = $show_btn_delete = 0;
                if ($value->status == 1) {
                    $show_btn_edit = 1;
                    //  $show_btn_delete=1;
                }
                $apply_date = "";
                if ($value->apply_date != '' && $value->apply_date != '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "employee_code" => $value->employeedetail->employeecode,
                    "employee_name" => $value->employeedetail->employeefullname,
                    "apply_date" => $apply_date,
                    //  "start_time" => $value->start_time,
                    //  "end_time" => $value->end_time,
                    "status" => HrEmployeeAttendanceExcuse::getStatus($value->status),
                    "show_button_edit" => $show_btn_edit,
                );
            }
            $response = array('status' => 'success', 'msg' => 'success', 'data' => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $response = array('status' => "failed", 'msg' => "No Data Available");
        }
        echo json_encode($response);
    }

    public function actionexcuseTypes() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $data = [];
            $condition = 'isActive =  "Y"';
            $model = HrMasExcuse::model()->findAll(array('condition' => $condition, 'order' => 'excuse_type asc'));
            foreach ($model as $row => $val) {
                $data[] = [
                    "id" => (string) $val->id,
                    "excuse_name" => $val->excuse_type,
                ];
            }
            $response = array('status' => "success", "msg" => "success", "data" => $data);
            if (empty($data)) {
                $response = array('status' => "failed", "msg" => "No data available", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionexcusefileupload() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $model_upload_document = HrMasterUpload::model()->findByPK(13);
            if ($model_upload_document->isActive == 'Y') {
                $upload_file_mandatory = "N";
            }
            $response = array('status' => "success", "msg" => "success", "upload_file_mandatory" => $upload_file_mandatory);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    
    public function actionUploadDocument($folder = null) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $model_upload_document = HrMasterUpload::model()->findByPK(13);
            if ($model_upload_document->isActive == 'Y') {
                $upload_size = $model_upload_document->max_upload_size * 1024 * 1024;
                $employee_id = $userModel->employee_id;
                $certificate_name = $_FILES["file"]["name"];
                $extension = pathinfo($certificate_name, PATHINFO_EXTENSION);
                $fileSize = $_FILES["file"]['size'];
                if ($fileSize < $upload_size) {
                    $model_employee= Employee::model()->findbyPK($employee_id);
                    //$model_employee=
                    $current_date =date('Y-m-d');
                    $new_file_name="Excuse_";
                    if(!empty($model_employee)){
                        $new_file_name.=str_replace(' ', '_', $model_employee->employeecode);
                    }
                    $new_file_name.='_'.$current_date.'_'.uniqid().'.'.$extension;
                    $folder = Yii::getPathOfAlias('webroot') . '/uploads/excuse/' . $new_file_name;
                    move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
                    $response = array('status' => "success", "msg" => "success", "filename" => $new_file_name);
                } else {
                    $response = array('status' => "failed", "msg" => "File too large. Maximum size is " . $model_upload_document->max_upload_size . " MB","filename" => '', "token_status" => "UA");
                }
            } else {
                $response = array('status' => "failed", "msg" => "Document uploads are not allowed under your current subscription plan","filename" => '', "token_status" => "UA");
            }
           
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionSaveExcuse() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $other = array();
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $validate = true;
                $model = new HrEmployeeAttendanceExcuse();
                $empid = $data_array['employee_id'];
                if ((int) $data_array['id'] > 0) {
                    $model->id = (int) $data_array['id'];
                    $model = $model->findByPK($model->id);
                    $model->updated_by = $userModel->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model->created_by = $userModel->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                $model->employee_id = $empid;
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $empid . '" and functionality_id="12"'));
                $model->last_approved_level = 0;
                if(!empty($model_master_approve_setting)){
                    $model->function_type = $model_master_approve_setting->id;
                    $model->max_level = $model_master_approve_setting->max_level;
                }
                $model->apply_date = date('Y-m-d');
                $model->status = 1;
                $validate = $model->validate();
                $arr_excuse_details = array();
                if (isset($data_array['EmployeeAttendanceExcuseDetails'])) {
                    foreach ($data_array['EmployeeAttendanceExcuseDetails'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modalexcusedetails[$i] = HrEmployeeAttendanceExcuseDetails::model()->findByPK($items['id']);
                        } else {
                            $modalexcusedetails[$i] = new HrEmployeeAttendanceExcuseDetails();
                        }
                        if ($items['excuse_date'] != '' && $items['excuse_date'] != '0000-00-00') {
                            $modalexcusedetails[$i]->excuse_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['excuse_date'])));
                            $arr_excuse_details[$i]['excuse_date'] = $modalexcusedetails[$i]->excuse_date;
                        }
                        if (isset($items['customer_name']) && $items['customer_name'] != '') {
                            $modalexcusedetails[$i]->customer_name = $items['customer_name'];
                        } else {
                            $modalexcusedetails[$i]->customer_name = '';
                        }
                        if (isset($items['visit_area']) && $items['visit_area'] != '') {
                            $modalexcusedetails[$i]->visit_area = $items['visit_area'];
                        } else {
                            $modalexcusedetails[$i]->visit_area = '';
                        }
                        if ($model->id > 0) {
                            $modalexcusedetails[$i]->excuse_id = $model->id;
                        }
                        $modalexcusedetails[$i]->type = 2;
                        $modalexcusedetails[$i]->start_time = $items['start_time'];
                        $modalexcusedetails[$i]->end_time = $items['end_time'];
                        $modalexcusedetails[$i]->excuse_reason = $items['excuse_reason'];
                        $modalexcusedetails[$i]->attendance_status = 1;
                        $modalexcusedetails[$i]->document = $items['document'];
                        $validate = $modalexcusedetails[$i]->validate() && $validate;
                    }
                }
                if ($validate) {
                    if ($model->save()) {
                        if (!empty($modalexcusedetails)) {

                            foreach ($modalexcusedetails as $eachModel) {
                                $eachModel->excuse_id = $model->id;
                                $eachModel->save();
                            }
                        }
                        //Mail
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="32"'));
                        if (!empty($model_settings) && !empty($model_mail_settings)) {
                            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                Yii::import('application.modules.hr.controllers.MailController');
                                MailController::sendmail(32, $model->employee_id, $model->id);
                            }
                        }
                    }
                    $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                } else {

                    $errors = $model->errors;
                    foreach ($model->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    foreach ($modalexcusedetails as $t => $value) {
                        foreach ($modalexcusedetails[$t]->errors as $k => $val) {
                            $arr_err[] = $val[0];
                        }
                    }
                    foreach ($other as $t => $value) {
                        foreach ($other as $k => $val) {
                            $arr_err[] = $val[0];
                        }
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => "failed", "msg" => "Input missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionviewExcusedetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $model = new HrEmployeeAttendanceExcuse();
            $model = $model->findByPk($id);
            $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"  AND rejected_level="0"'));
            $apply_date = '-';
            if ($model->apply_date != '0000-00-00' && $model->apply_date != '') {
                $apply_date = date("d/m/Y", strtotime($model->apply_date));
            }
            $approved_date = '';
            if ($model->approved_date != '0000-00-00' && $model->approved_date != '') {
                $approved_date = date("d/m/Y", strtotime($model->approved_date));
            }
            if (!empty($model_details)) {
                foreach ($model_details as $i => $each_details) {
                    $weekvalue = date('w', strtotime($details->excuse_date));
                    $weekvalue += 1;
                    $day = array(1 => "Sunday", 2 => "Monday", 3 => "Tuesday", 4 => "Wednesday", 5 => "Thursday", 6 => "Friday", 7 => "Saturday");
                    $day_name = $day[$weekvalue];
                    $excuse_date = '';
                    if ($each_details->excuse_date != '' && $each_details->excuse_date != '0000-00-00') {
                        $excuse_date = date("d/m/Y", strtotime($each_details->excuse_date));
                    }
                    $excuse_details[] = array(
                        "id" => (string) $each_details->id,
                        "excuse_date" => $excuse_date,
                        "excuse_name" => $each_details->typedetail->excuse_type,
                        "week_day" => $day_name,
                        "customer_name" => $each_details->customer_name,
                        "visit_area" => $each_details->visit_area,
                        "start_time" => $each_details->start_time,
                        "end_time" => $each_details->end_time,
                        "excuse_reason" => $each_details->excuse_reason,
                        "document_attachment" => $each_details->document,
                        "document_path" => "uploads/excuse",
                    );
                }
                $data = array("id" => (string) $model->id,
                    "employee_name" => $this->ciphertext($model->employeedetail->first_name, "d") . ' ' . $this->ciphertext($model->employeedetail->last_name, "d"),
                    "employee_code" => $this->ciphertext($model->employeedetail->employee_code, "d"),
                    "apply_date" => $apply_date,
                    "approved_date" => $approved_date,
                    "status" => HrEmployeeAttendanceExcuse::getStatus($model->status),
                    "excuse_details" => $excuse_details,
                );
            }
            $response = array('status' => "success", 'msg' => "success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionGetExcuseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            if ($employee_id > 0) {
                $pending_excuse = HrEmployeeAttendanceExcuse::getintermediateapproval($employee_id, 1);
                $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN(' . $pending_excuse . ')';
                $model = new HrEmployeeAttendanceExcuse();
                $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition));
                foreach ($model as $row) {
                    $last_approved_level = $row->last_approved_level;
                    $next_approval_level = $last_approved_level + 1;
                    $final_level = 'N';
                    $show_approve_button = 0;
                    $level_no = 0;
                    if ($next_approval_level <= $row->approvelevel->max_level) {
                        if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                            $show_approve_button = 1;
                            $level_no = 1;
                        } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                            $show_approve_button = 1;
                            $level_no = 2;
                        } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                            $show_approve_button = 1;
                            $level_no = 3;
                        } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                            $show_approve_button = 1;
                            $level_no = 4;
                        } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                            $show_approve_button = 1;
                            $level_no = 5;
                        }
                    }
                    if ($next_approval_level == $row->approvelevel->max_level) {
                        $final_level = 'Y';
                    }
                    $apply_date = '-';
                    if ($row->apply_date != '0000-00-00' && $row->apply_date != '') {
                        $apply_date = date("d/m/Y", strtotime($row->apply_date));
                    }
                    $data[] = array(
                        "id" => $row->id,
                        "employee_code" => $row->employeedetail->employeecode,
                        "employee_name" => $row->employeedetail->employeefullname,
                        "apply_date" => $apply_date,
                        "show_approve_button" => $show_approve_button,
                        "status" => HrEmployeeAttendanceExcuse::getStatus($row->status),
                        "next_approval_level" => $level_no,
                        "final_level" => $final_level
                    );
                }
                $response = array('status' => "success", 'msg' => "success", 'data' => $data);
                if (empty($data)) {
                    $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
                }
            } else {
                $response = array('status' => "failed", 'msg' => "input Missing", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }

    public function actionsaveApproveRequest() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $other = array();
        $userModel = User::model()->findBytoken($token);
        if (!empty($userModel) && $userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $validate = true;
                $model = new HrEmployeeAttendanceExcuse();
                $id = $data_array['id'];
                $employee_id = $data_array['employee_id'];
                $model->last_approved_level = $data_array['approval_level'];
                $level = $data_array['approval_level'];
                $final_level = $data_array['final_level'];
                if ((int) $id > 0) {
                    $model = $model->findByPK($id);
                    $model->updated_by = $userModel->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                }
                $status_v = $data_array['status'];
                if ($final_level == 'Y') {
                    if ($status_v == 'A') {
                        $status = 12;
                    } else {
                        $status = 13;
                    }
                } else if ($level == 1) {
                    if ($status_v == 'A') {
                        $status = 2;
                    } else {
                        $status = 3;
                    }
                } else if ($level == 2) {
                    if ($status_v == 'A') {
                        $status = 4;
                    } else {
                        $status = 5;
                    }
                } else if ($level == 3) {
                    if ($status_v == 'A') {
                        $status = 6;
                    } else {
                        $status = 7;
                    }
                } else if ($level == 4) {
                    if ($status_v == 'A') {
                        $status = 8;
                    } else {
                        $status = 9;
                    }
                } else if ($level == 5) {
                    if ($status_v == 'A') {
                        $status = 10;
                    } else {
                        $status = 11;
                    }
                }
                $model->status = $status;
                if ($level == 1 && $final_level == 'N') {
                    $model->approve_level1_date = date('Y-m-d');
                    $model->approve_level1_comment = $data_array['approval_comment'];
                    $model->approve_level1_id = $employee_id;
                } else if ($level == 2 && $final_level == 'N') {
                    $model->approve_level2_date = date('Y-m-d');
                    $model->approve_level2_comment = $data_array['approval_comment'];
                    $model->approve_level2_id = $employee_id;
                } else if ($level == 3 && $final_level == 'N') {
                    $model->approve_level3_date = date('Y-m-d');
                    $model->approve_level3_comment = $data_array['approval_comment'];
                    $model->approve_level3_id = $employee_id;
                } else if ($level == 4 && $final_level == 'N') {
                    $model->approve_level4_date = date('Y-m-d');
                    $model->approve_level4_comment = $data_array['approval_comment'];
                    $model->approve_level4_id = $employee_id;
                } else if ($level == 5 && $final_level == 'N') {
                    $model->approve_level5_date = date('Y-m-d');
                    $model->approve_level5_comment = $data_array['approval_comment'];
                    $model->approve_level5_id = $employee_id;
                }
                if ($final_level == 'Y') {
                    $model->approved_date = date('Y-m-d');
                    $model->approval_comment = $data_array['approval_comment'];
                    $model->approved_by = $employee_id;
                }
                $validate = $model->validate();
                $model_excuse_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"'));
                if ($validate) {
                    if ($model->save()) {
                        if (!empty($model_excuse_details)) {
                            foreach ($model_excuse_details as $eachModel) {
                                if ($status_v == "A") {
                                    $eachModel->excuse_status = "Y";
                                    $eachModel->updated_by = $userModel->id;
                                    $eachModel->updated_date_time = date('Y-m-d H:i:s');
                                } else {
                                    $eachModel->excuse_status = "N";
                                    $eachModel->rejected_level = $level;
                                    $eachModel->updated_by = $userModel->id;
                                    $eachModel->save();
                                }
                            }
                        }
                        //Updating Attendance Table
                        if ($status == 12 && $final_level == 'Y') {
                            $model_details_approved = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '" and excuse_status="Y"'));
                            foreach ($model_details_approved as $i => $items) {
                                $date_from = $items->excuse_date;
                                $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '"';
                                $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                                if (!empty($model_attendance)) {
                                    $model_attendance_details = EmployeeAttendance::model()->findByPK($model_attendance->id);
                                    $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                                    if (!empty($model_shift)) {
                                        $model_attendance_details->shift_id = $model_shift->id;
                                    }
                                    $model_attendance_details->updated_by = $userModel->id;
                                    $model_attendance_details->updated_date_time = date('Y-m-d H:i:s');
                                    $model_attendance_details->excuse_reason = $items->excuse_reason;
                                    if ($items->attendance_status == 1) {
                                        $model_attendance_details->status = 1;
                                        if (strtotime($items->start_time) < strtotime($model_attendance_details->login_time)) {
                                            $model_attendance_details->login_time = $items->start_time;
                                        }
                                        if (strtotime($items->end_time) > strtotime($model_attendance_details->logout_time)) {
                                            $model_attendance_details->logout_time = $items->end_time;
                                        }
                                        $model_attendance_details->login_punch_from = 'H';
                                        $model_attendance_details->logout_punch_from = 'H';
                                    } else {
                                        $model_attendance_details->status = $model_attendance->status;
                                    }
                                    $model_attendance_details->morning_late = $this->morninglate($model_attendance->employee_id, $date_from, $model_attendance_details->login_time);
                                    $model_attendance_details->total_working = $this->totalworking($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->variance_time_loss = $this->totaltimeloss($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->excess_time = $this->excesstime($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->shift_id = $this->shiftdetail($model_attendance->employee_id, $date_from);
                                    $model_attendance_details->save();
                                } else {
                                    $weekvalue = date('w', strtotime($date_from));
                                    $weekvalue += 1;
                                    $day = '';
                                    if ($weekvalue == 1) {
                                        $day = "Sunday";
                                    } else if ($weekvalue == 2) {
                                        $day = "Monday";
                                    } else if ($weekvalue == 3) {
                                        $day = "Tuesday";
                                    } else if ($weekvalue == 4) {
                                        $day = "Wednesday";
                                    } else if ($weekvalue == 5) {
                                        $day = "Thursday";
                                    } else if ($weekvalue == 6) {
                                        $day = "Friday";
                                    } else if ($weekvalue == 7) {
                                        $day = "Saturday";
                                    }
                                    $model_attendance_details = new EmployeeAttendance();
                                    $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                                    if (!empty($model_shift)) {
                                        $model_attendance_details->shift_id = $model_shift->id;
                                    }
                                    $model_attendance_details->employee_id = $model->employee_id;
                                    $model_attendance_details->created_by = Yii::app()->user->id;
                                    $model_attendance_details->created_date_time = date('Y-m-d H:i:s');
                                    if ($items->attendance_status == 1) {
                                        $model_attendance_details->status = 1;
                                        $model_attendance_details->login_time = $items->start_time;
                                        $model_attendance_details->logout_time = $items->end_time;
                                        $model_attendance_details->login_punch_from = 'H';
                                        $model_attendance_details->logout_punch_from = 'H';
                                    } else {
                                        $model_attendance_details->status = 2;
                                        $model_attendance_details->login_time = '';
                                        $model_attendance_details->logout_time = '';
                                    }
                                    $model_attendance_details->excuse_reason = $items->excuse_reason;
                                    $model_attendance_details->branch_or_sponsor_id = $model->employeedetail->branch_or_sponsor_id;
                                    $model_attendance_details->attendance_date = $date_from;
                                    $model_attendance_details->week_day = $day;
                                    $model_attendance_details->attendance_via = 'H';
                                    $model_attendance_details->morning_late = $this->morninglate($model->employee_id, $date_from, $model_attendance_details->login_time);
                                    $model_attendance_details->total_working = $this->totalworking($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->variance_time_loss = $this->totaltimeloss($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->excess_time = $this->excesstime($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                    $model_attendance_details->shift_id = $this->shiftdetail($model->employee_id, $date_from);
                                    $model_attendance_details->save();
                                }
                            }
                        }
                        //Mail
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="32"'));
                        if (!empty($model_settings) && !empty($model_mail_settings)) {
                            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                Yii::import('application.modules.hr.controllers.MailController');
                                MailController::sendmail(32, $model->employee_id, $model->id);
                            }
                        }
                    }
                    $response = array('status' => 'success', 'msg' => 'success', 'id' => $model->id);
                } else {

                    $errors = $model->errors;
                    foreach ($model->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    foreach ($modalexcusedetails as $t => $value) {
                        foreach ($modalexcusedetails[$t]->errors as $k => $val) {
                            $arr_err[] = $val[0];
                        }
                    }
                    $response = array('status' => 'failed', 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => 'failed', 'msg' => "Input Missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    function decimalHours($time) {
        $hms = explode(":", $time);
        return ((float) $hms[0] + (float) ($hms[1] / 60) + (float) ($hms[2] / 3600));
    }

    //Function Start
    function morninglate($employee_id, $date, $login_time) {
        $weekend = '';
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time = $model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }
        $mor_late = '00:00';
        if (!empty($model_holiday) && $login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $weektype != 'F' && $model_holiday->id == '') {
            $from_time = strtotime($login_time);
            $secs = strtotime($cool_off_time) - strtotime("00:00:00");
            $morning_start = date("H:i", strtotime($original_start_time) + $secs);
            $morning_shift_in_time = strtotime($morning_start);
            $shift_in_time = strtotime($original_start_time);
            $time_diff = $from_time - $shift_in_time;
            if ($morning_shift_in_time >= $from_time) {
                $mor_late = '00:00';
            } else {
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }

    //Morning Late-End
    //Total Working -Start
    function totalworking($employee_id, $date, $login_time, $logout_time) {
        $total_working = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if (!empty($model_shift) && $model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if ($model_master_shift->shift_type == 'N') {
                    $diff = ($working_start_time - $working_stop_time);
                } else {
                    if ($working_stop_time > $working_start_time) {
                        $diff = ($working_stop_time - $working_start_time);
                    } else {
                        $diff = ($working_start_time - $working_stop_time);
                    }
                }
            } else {
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff);
        }
        return $total_working;
    }

    //Total Working -End
    //Total Time Loss Per Day -Start
    function totaltimeloss($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        $weekend = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_timeloss = '00:00';
        if (!empty($model_holiday) && $model_holiday->id == '') {
            if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
                $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
                if ((strtotime($total_working) < strtotime($branch_working_hours)) && $weekend == 0) {
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff);
                }
            }
        }
        return $total_timeloss;
    }

    //Total Time Loss Per Day -End
    //Total Excess Time Per Day -Start
    function excesstime($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        $weekend = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_excess_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if ($working_stop_time > $working_start_time) {
                $diff = ($working_stop_time - $working_start_time);
            } else {
                $diff = ($working_start_time - $working_stop_time);
            }
            $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
            if (!empty($model_holiday) && ($weekend == 1 || $model_holiday->id > 0)) {
                $total_excess_time = $total_working;
            } else if (strtotime($total_working) > strtotime($branch_working_hours)) {
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess);
            }
        }
        return $total_excess_time;
    }

    //Total Excess Time Per Day -End
    function shiftdetail($employee_id, $date) {
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        $shift_id = 0;
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $shift_id = $model_shift->shift_id;
        }
        return $shift_id;
    }
}
