<?php
class ApiattendanceController extends Controller {
    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('GetEmployeeAttendance', 'PunchStatus', 'SaveAttendance'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array('Index',), 'expression' => '$user->isMember()',),);
    }
    public function filters() {
        return array('accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action) {
        //for db connection added by nisha on 27-03-2023
        $this->ChangeDB();
        return true;
    }
    public function actionGetEmployeeAttendance() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $month = $data_array['month'];
            $year = $data_array['year'];
            if ($employee_id > 0 && $month > 0 && $year > 0) {
                $start = $year . '-' . $month . '-01';
                $end = date("Y-m-t", strtotime($start));
                if ($month == date("m")) {
                    $end = date('Y-m-d');
                }
                $date = $end;
                $datediff = strtotime($end) - strtotime($start);
                $diff = $datediff / (60 * 60 * 24) + 1;
                $attendance_type = "";
                for ($k = $diff; $k >= 1; $k--) {
                    $weekvalue = date('w', strtotime($date));
                    $weekvalue += 1;
                    if (($model_attendance->employeedetail->weekend_off1 == $weekvalue) || ($model_attendance->employeedetail->weekend_off2 == $weekvalue)) {
                        $week_end = 1;
                    }
                    $model_attendance = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date="' . $date . '"'));
                    $login_time = $logout_time = $status = $morning_late = $variance = $overtime = $working_hrs = '-';
                    if (!empty($model_attendance) && $model_attendance->status == 1) {
                        $attendance_date = date("d/m/Y", strtotime($date));
                        
                        if ($model_attendance->id > 0) {
                            $status = "Present";
                            if (($model_attendance->employeedetail->weekend_off1 == $weekvalue) || ($model_attendance->employeedetail->weekend_off2 == $weekvalue) || ($model_attendance->employeedetail->weekend_off3 == $weekvalue)) {
                                $week_end = 1;
                            }
                            $attendance_date = date("d/m/Y", strtotime($model_attendance->attendance_date));
                            $login_time = $model_attendance->login_time;
                            $logout_time = $model_attendance->logout_time;
                            if (!empty($model_attendance) && $model_attendance->login_time != '' && $model_attendance->login_time != '00:00' && $model_attendance->login_time != '00:00') {
                                $login_time = date("H:i:s", strtotime($model_attendance->login_time));
                            }
                            if (!empty($model_attendance) && $model_attendance->login_time != '' && $model_attendance->logout_time != '0:00' && $model_attendance->logout_time != '00:00') {
                                $logout_time = date("H:i:s", strtotime($model_attendance->logout_time));
                            }
                            if ($model_attendance->holiday_overtime != '00:00:00') {
                                $overtime = $model_attendance->holiday_overtime;
                            } else if ($model_attendance->weekend_overtime != '00:00:00') {
                                $overtime = $model_attendance->weekend_overtime;
                            } else if ($model_attendance->normal_overtime != '00:00:00') {
                                $overtime = $model_attendance->normal_overtime;
                            } else if ($model_attendance->night_shift_overtime != '00:00:00') {
                                $overtime = $model_attendance->night_shift_overtime;
                            }
                            if ($model_attendance->morning_late != '00:00:00') {
                                $morning_late = date("H:i:s", strtotime($model_attendance->morning_late));
                            }
                            if ($model_attendance->variance_time_loss != '00:00:00') {
                                $variance = '-' . date("H:i:s", strtotime($model_attendance->variance_time_loss));
                            } else if ($model_attendance->excess_time != '00:00:00') {
                                $variance = '+' . date("H:i:s", strtotime($model_attendance->excess_time));
                            }
                            if ($model_attendance->total_working != '00:00:00') {
                                $working_hrs = date("H:i:s", strtotime($model_attendance->total_working));
                            }
                        }
                        $data[] = array("id" => $model_attendance->id, "attendance_date" => $attendance_date, "login_time" => $login_time, "logout_time" => $logout_time, "status" => $status, "morning_late" => $morning_late, "variance" => $variance, "overtime" => $overtime, "working_hrs" => $working_hrs);

                    } else {
                        
                        if (!empty($model_attendance) && $model_attendance->status == 2) {
                            $status = "Absent";
                        } else if (!empty($model_attendance) && $model_attendance->status == 3) {
                            $status = "Leave";
                            $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => '(leave_start_date <="' . $date . '" 
                                                                                AND leave_end_date >="' . $date . '") 
                                                                                AND employee_id="' . $employee_id . '"'));
                            if (!empty($arr_leave_details)) {
                                $status = MasLeave::model()->findbypk($arr_leave_details->leave_type)->leave_name;
                            } else {
                                if ($model_attendance->employeedetail->weekend_off1 == $weekvalue) {
                                    $status = "Weekend";
                                }
                                if ($model_attendance->employeedetail->weekend_off2 == $weekvalue) {
                                    $status = "Weekend";
                                }
                                if ($attendance_type == '') {
                                    $status = "Absent";
                                }
                            }
                        } else if (!empty($model_attendance) && $model_attendance->status == 4) {
                            $status = "Holiday";
                        } else if (!empty($model_attendance) && $model_attendance->status == 5) {
                            $status = "Weekend";
                        } else {
                            if ($status == '') {
                                $status = "";
                            }
                        }
                    //    if (!empty($model_attendance)) {
                            $attendance_date = date("d/m/Y", strtotime($date));
                            $data[] = array("id" => 0, "attendance_date" => $attendance_date, "login_time" => $login_time, "logout_time" => $logout_time, "status" => $status, "morning_late" => $morning_late, "variance" => $variance, "overtime" => $overtime, "working_hrs" => $working_hrs);
                    //    }
                    }
                    $date = date('Y-m-d', strtotime('-1 day', strtotime($date)));
                }
                $response = array('status' => "success", "msg" => "success", "data" => $data);
                // }
                if (empty($data)) {
                    //  $data[] = array('msg' => "No Data Available");
                    $response = array('status' => "error", "msg" => "No Records Found", "data" => $data);
                }
            } else {
                $response = array('status' => "error", "msg" => "Input variables missing", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "msg" => "Unauthorized user", "data" => $data);
        }
        echo json_encode($response);
    }

    public function actionPunchStatus() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            date_default_timezone_set('Asia/Dubai');
            $data_array = json_decode(file_get_contents('php://input'), true);
            $emp_id = $data_array["emp_id"];
            $current_date = date("Y-m-d");
            $date_from = date('Y-m-d', strtotime('-1 days', strtotime($date_from)));
            $active_status = 'LOG_OUT';
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $current_date . '" AND to_date>="' . $current_date . '") OR  (from_date BETWEEN  "' . $current_date . '" AND  "' . $current_date . '"
                                    OR to_date BETWEEN  "' . $current_date . '" AND  "' . $current_date . '")) AND employee_id="' . $emp_id . '"'));
            $type = $last_status_val = $last_time = $last_punch_date = '';
            $last_status = 0;
            $st_arr = array('LOG_IN' => 'Logged In', 'IN' => 'In', 'OUT' => 'Out', 'LOG_OUT' => 'Logged Out');
            $model_attendance_log = HrAttendanceLog::model()->find(array('condition' => 'log_date="' . $current_date . '" and emp_id="' . $emp_id . '"', 'order' => 'id desc'));
            if ($model_attendance_log->id > 0) {
                $last_punch_date = date("d/m/Y", strtotime($model_attendance_log->log_date));
                $type = $model_attendance_log->log_type;
                $last_status_val = $st_arr[$type];
                $last_time = $model_attendance_log->log_time;
                $last_status = 1;
                $active_status = $type;
            } else {
                $model_attendance_log_pv = HrAttendanceLog::model()->find(array('condition' => 'log_date="' . $date_from . '" and emp_id="' . $emp_id . '"', 'order' => 'id desc'));
                if ($model_attendance_log_pv->id > 0) {
                    $last_punch_date = date("d/m/Y", strtotime($model_attendance_log_pv->log_date));
                    $last_status_val = $st_arr[$model_attendance_log_pv->log_type];
                    $last_time = $model_attendance_log_pv->log_time;
                    $last_status = 1;
                    $active_status = $type;
                }
            }
            $log_in = $in = $out = $log_out = $last_day_logout = 0;
            if ($model_shift->id > 0) {
                if ($model_shift->shiftdetails->shift_type != 'N' && $type == 'LOG_IN') {
                    $out = $log_out = 1;
                } else if ($model_shift->shiftdetails->shift_type != 'N' && $type == 'IN') {
                    $out = $log_out = 1;
                } else if ($model_shift->shiftdetails->shift_type != 'N' && $type == 'OUT') {
                    $in = $log_out = 1;
                } else if ($model_shift->shiftdetails->shift_type != 'N' && $type == '') {
                    $log_in = 1;
                } else if ($model_shift->shiftdetails->shift_type == 'N') {
                    $previous_date = date('Y-m-d', strtotime('-1 days', strtotime($current_date)));
                    if ($model_attendance_log->id == '') {
                        $model_attendance_log_in = HrAttendanceLog::model()->find(array('condition' => 'log_date="' . $previous_date . '" and log_type="LOG_IN" and emp_id="' . $emp_id . '"'));
                        $model_attendance_log_out = HrAttendanceLog::model()->find(array('condition' => 'log_date="' . $previous_date . '" and log_type="LOG_OUT" and emp_id="' . $emp_id . '"'));
                        if ($model_attendance_log_in->id == '' && $model_attendance_log_out->id == '') {
                            $last_day_logout = 1;
                        }
                        $log_in = 1;
                    } else if ($type == 'LOG_IN') {
                        $out = $log_out = 1;
                    } else if ($type == 'IN') {
                        $out = $log_out = 1;
                    } else if ($type == 'OUT') {
                        $in = $log_out = 1;
                    } else {
                        $log_in = 1;
                    }
                }
            } else {
                if ($type == 'LOG_IN') {
                    $out = $log_out = 1;
                } else if ($type == 'IN') {
                    $out = $log_out = 1;
                } else if ($type == 'OUT') {
                    $in = $log_out = 1;
                } else if ($type == '') {
                    $log_in = 1;
                }
            }
            $data = array("log_in" => $log_in, "in" => $in, "out" => $out, "log_out" => $log_out, "last_day_logout" => $last_day_logout, "previous_date" => $previous_date, "current_date" => $current_date, "last_punch_date" => $last_punch_date, "last_status_val" => $last_status_val, "last_time" => $last_time, "last_status" => $last_status, "active_status" => $active_status);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $data = array('msg' => "No Data Available");
        }
        echo json_encode($data);
    }
    public function actionSaveAttendance() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            date_default_timezone_set('Asia/Dubai');
            $data_array = json_decode(file_get_contents('php://input'), true);
            $attendance_date = $data_array["attendance_date"];
            $employee_id = $data_array["employee_id"];
            $log_time = $data_array["log_time"];
            $user_id = $data_array["user_id"];
            $log_type = $data_array["log_type"];
            $latitude = $data_array["latitude"];
            $longitude = $data_array["longitude"];
            $model = new HrAttendanceLog();
            $model->emp_id = $employee_id;
            $model->log_date = $attendance_date;
            $model->log_time = $log_time;
            $model->log_type = $log_type;
            $model->latitude = $latitude;
            $model->longitude = $longitude;
            $model->created_date_time = date("Y-m-d H:i:s");
            $model->created_by = $user_id;
            $data = ["id" => "", "error_message" => "", "status" => "error", "date" => "", "time" => ""];
            if ($model->validate() && $model->save()) {
                $data["id"] = $model->id;
                $data["status"] = " success";
                $data["date"] = $model->log_date;
                $data["time"] = $model->log_time;
                $data["log_type"] = $model->log_type;
            } else {
                $data["error_message"] = $model->getErrors();
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $data = array('msg' => "No Data Available");
        }
        echo json_encode($data);
    }
}
