<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'ticket-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->dropdownlist($model, 'property_id', Properties::getProperty(), array('data-label' => 'Property <span style="color:red">*</span>', 'empty' => 'Select')); ?>
                <?php echo $form->error($model, 'property_id'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'ticket_no', array('data-label' => 'Ticket No  <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'ticket_no'); ?>
            </li>	

            <li class="col-sm-3">
            
             <?php 
             if(empty($model->ticket_date)){
                 $model->ticket_date=date('d/m/Y');
             }
             else{
                 $model->ticket_date=date('d/m/Y',strtotime($model->ticket_date));
             }
             echo $form->textField($model, 'ticket_date', array('class' => 'tooltipster datepicker', 'title' => 'Ticket Date','data-label'=>'Ticket Date <span style="color:red">*</span>')); ?>

            <?php echo $form->error($model, 'ticket_date'); ?>
            

        </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'raised_by', array(1 => 'Admin', 2 => 'user'), array('data-label' => 'Raised By')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'priority', array('CRITICAL' => 'Critical', 'HIGH' => 'High', 'MEDIUM' => 'Medium', 'LOW' => 'Low'), array('data-label' => 'Priority')); ?>
            </li>
            <li class="col-sm-3">

                <?php echo $form->dropdownlist($model, 'ticket_status', array('1' => 'Active', '2' => 'closed'), array('data-label' => 'Ticket Status <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'ticket_status'); ?>
            </li>

            <li class="col-sm-6">

                <?php echo $form->textArea($model, 'remarks', array('class' => 'tooltipster', 'title' => 'Remarks', 'data-label' => 'Address <span style="color:red">*</span>')); ?>

                <?php echo $form->error($model, 'remarks'); ?>
            </li> 



        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="header_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('/ticketheader/Save');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Details Saved Successfully!");
                                         $("#header_close").click();
                                        reloadTable("#tbl_header_details");
                                    } else { 
                                       $("#ticket-form .ticket-save-btn").prop("disabled", false);
                                        $("#ticket-form .ticket-save-btn").addClass("btn-theme").removeClass("btn_loding");
                                        $.each(data, function(key, val) {
                                                $("#ticket-form #"+key+"_em_").text(val).show(); 
                                                t8.error(""+val+""); 
                                        }); 
                                    } 
                            }',
        'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#ticket-form .ticket-save-btn").prop("disabled", true);
                                $("#ticket-form .ticket-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'ticket-save-btn btn btn-theme'));
    ?>


</div>


<?php $this->endWidget(); ?>










