<?php
$cs = Yii::app()->getClientScript();
?>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_wrkprogress_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            data.to_date = $("#to_date").val();
            data.from_date = $("#from_date").val();
            data.status_id = $("#status_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[0, "desc"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fm/ticket/GetProgressList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                AddContextMenu(nRow, aData);
                if (aData[7]['issue_priority'] == "CRITICAL") {
                    $("td", nRow).addClass("bg-danger");
                }
                if (aData[7]['issue_priority'] == "HIGH") {
                    $("td", nRow).addClass("bg-warning");
                }
                if (aData[7]['issue_priority'] == "MEDIUM") {
                    $("td", nRow).addClass("bg-info");
                }
                if (aData[7]['issue_priority'] == "LOW") {
                    $("td", nRow).addClass("bg-success");
                }
            }

        });
    });
    function AddContextMenu(row, datas) {
        var mas_edit = 0;
        var mas_disable = 0;
<?php //if (isset(Yii::app()->user->havePermissionOn['master_country_edit']) || Yii::app()->user->authorised_user == 1) {                     ?>
        var mas_edit = 1;
<?php //}                     ?>
<?php //if (isset(Yii::app()->user->havePermissionOn['master_country_disable']) || Yii::app()->user->authorised_user == 1) {                     ?>
        var mas_disable = 1;
<?php //}                     ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "edit": {

                    name: "Start Job",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("fm/jobtime/startjob&id=" + datas[0] + "&item_id=" + datas[7]['ticket_item_id'], "Start Job - " + datas[0], "lg");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_edit == '0') {
                            return !this.data('editDisabled');
                        }
                    }
                },
                "Stop": {
                    name: "Stop Job",
                    icon: "edit",
                    accesskey: "a",
                    callback: function () {
                        loadPopupModal("fm/jobtime/stopjob&id=" + datas[0] + "&item_id=" + datas[7]['ticket_item_id'], "Stop - " + datas[0], "lg");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_disable == '0') {
                            return !this.data('Disable_EnableDisabled');
                        }
                    }
                },
                "Request": {
                    name: "Request Material",
                    icon: "edit",
                    accesskey: "a",
                    callback: function () {
                        loadPopupModal("fm/ticket/requestmaterial&id=" + datas[0] + "&item_id=" + datas[7]['ticket_item_id'], "Request Material For - " + datas[0], "xl");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_disable == '0') {
                            return !this.data('Disable_EnableDisabled');
                        }
                    }
                },
                "Issue": {
                    name: "Issue Material",
                    icon: "edit",
                    accesskey: "a",
                    callback: function () {
                        loadPopupModal("fm/ticket/issuematerial&id=" + datas[0] + "&item_id=" + datas[7]['ticket_item_id'], "Issue Material For - " + datas[0], "xl");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (mas_disable == '0') {
                            return !this.data('Disable_EnableDisabled');
                        }
                    }
                },
                complete: {
                    name: "Work Completed",
                    icon: "quit",
                    callback: () => {

                        loadPopupModal("fm/jobtime/Jobcompleted&id=" + datas[0] + "&item_id=" + datas[7]['ticket_item_id'] + "&technician_id=" + datas[7]['id'], "Closing - " + datas[0], "lg");
                    }
                }

            }
        });
    }

</script>
<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=property/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_header_details').DataTable().ajax.reload()
                        t8.success(' Success!');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-list"></i> Work In Progress
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::dropdownList('display_type', '', array(1 => 'All Items', 2 => 'Job Order Details', 3 => 'Planned Maintenance'), array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_wrkprogress_details")')); ?>
        </div>
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::dropdownList('status_id', '', TicketAllotTechnicians::getStatusList(), array('class' => 'form-control', 'prompt' => 'Select All', 'onChange' => 'reloadTable("#tbl_wrkprogress_details")')); ?>
        </div>
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::textField('to_date', date("t/m/Y"), array('data-label' => 'Select End Date', 'class' => 'datepicker form-control', 'onChange' => 'reloadTable("#tbl_wrkprogress_details")')); ?>
        </div>
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::textField('from_date', date('01/m/Y'), array('data-label' => 'Select From Date', 'class' => 'datepicker form-control', 'onChange' => 'reloadTable("#tbl_wrkprogress_details")')); ?>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_wrkprogress_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Job ID</th>
                        <th>Technician Name</th>
                        <th>Issue Type</th>
                        <th>Issue Remark</th>
                        <th>Alloted Date</th>
                        <th>Works Starts From</th>
                        <th>Works Ends On</th>

                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>