<?php
$cs = Yii::app()->getClientScript();
?>

<script>
    $(document).ready(function () {

        var table_id = "#tbl_material_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.req_date = $("#req_date").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [[0, "desc"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fm/materialsummary/materiallist') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);

            }

        });
    });
    function AddContextMenu(row, datas) {
        param_index = 6;
        var met_view = 0;
        var met_issue = 0;
<?php if (isset(Yii::app()->user->havePermissionOn['materials_list_view']) || Yii::app()->user->authorised_user == 1) { ?>
            var met_view = 1;
<?php } ?>
<?php if (isset(Yii::app()->user->havePermissionOn['materials_list_issue']) || Yii::app()->user->authorised_user == 1) { ?>
            var met_issue = 1;
<?php } ?>
        $(row).contextMenu({
            selector: 'td',
            items: {
                "view": {

                    name: "View Ticket",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("fm/ticket/create&id=" + datas[param_index].ticket_id + '&type=view', "Edit - " + datas[param_index].ticket_id, "xl");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (met_view == 0) {
                            if (datas[param_index].view == 'N') {

                                return !this.data('viewDisabled');
                            }
                        }
                    }

                },
                "issued": {
                    name: "Issue Material",
                    icon: "fa-stack-overflow",
                    accesskey: "e",
                    callback: function () {
                        var good_issuse_id = datas[param_index].good_issuse_id.toString().trim();
                        var good_issuse_type = datas[param_index].good_issuse_type.toString().trim();
                        if (good_issuse_id === "" || good_issuse_id === "0") {
                            loadPopupModal("issues/create&ticket_id=" + datas[param_index].ticket_id, "Issue Material For - " + datas[param_index].ticket_id, "xl");
                        } else {
                            loadPopupModal("issues/create&id=" + good_issuse_id + "&status=" + good_issuse_type, "Issue Material For - " + datas[param_index].id, "xl");
                        }
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (met_issue == 0) {
                            return !this.data('issueDisabled');
                        }
                    }

                },
            }
        });
    }

</script>
<script>
    function Issued(id, status) {
        var r = confirm((status == "N") ? 'Are you sure to mark this as issued?' : 'Are you sure to enable this?');
        if (r == true)
        {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id,
                'url': $('#liveSite').val() + 'index.php?r=fm/ticket/IssuedMaterial',
                'cache': false,
                'success': function (data) {
                    if (data.status == '') {
                        t8.error('error');
                    } else {
                        $('#tbl_material_details').DataTable().ajax.reload()
                        t8.success(' Success');
                    }
                }
            });
        }


    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-bank"></i> Requested Materials
        <div class="top_controls_select col-sm-8 pull-right">
            <!--<div class="col-sm-1 pull-right">
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('fm/ticket/create', 'Add New Job Order', 'xl')"> <i class="fa fa-plus"></i> ADD</button>
            </div>-->
            <div class="col-sm-1 pull-right">
                <button class="btn btn-sm btn-theme" onclick="reloadTable('#tbl_material_details');"> <i class="fa fa-refresh"></i> LOAD</button>
            </div>
            <!--            <div class="col-sm-2 pull-right">
            <?php echo CHtml::textField('req_date', date('d/m/Y'), array('data-label' => 'Select Date', 'class' => 'datepicker form-control ')); ?>
                        </div>-->

        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_material_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Job ID</th>
                        <th>Product Description</th>
                        <th>Requested Quantity</th>
                        <th>Unit</th>
                        <th>Requested Date</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>