<?php
$job_id = (int) $model->job_id;
$snag_header = new FmSnag();
$snag_header = $snag_header->find(["condition" => "job_id = " . $job_id]);
$header_id = 0;
if (!empty($snag_header)) {
    $header_id = (int) $snag_header->id;
}
$area_model = new FmMasArea();
$condition = "t.isActive='Y' ";
$area_models = $area_model->findAll(["condition" => $condition, "order" => "sort_order"]);
$header_con_span = 6;
$key = 0;
?>


<style>
    .btn-right {
        text-align: right;
    }
    .btn-primary {
        background-color: #0073e6; /* Customize the button color */
        color: #fff; /* Customize the text color */
    }
    .btn-xs {
        font-size: 12px; /* Customize the font size */
        padding: 5px 10px; /* Customize the padding */
    }
</style>

<a class="btn btn-primary btn-xs btn-right" target="_blank" href="index.php?r=fm/snag/printJobCompletionReport&ticket_id=<?php echo $job_id; ?>">
    <i class="fa fa-file-pdf-o"></i> Print Completion Report
</a>

<?php foreach ($area_models as $j => $area) {
?>

    <table class="table table-bordered">
        <thead>
            <tr class="primary">
                <th colspan="<?= $header_con_span ?>">
                    <?php echo $area->name ?>
                </th>
            </tr>
            <tr>
                <th>#</th>
                <th>Item</th>
                <th style="width: 100px" class="text-right">Repair Qty</th>
                <th style="width: 100px" class="text-right">Replace Qty</th>
                <th style="width: 100px" class="text-right">Qty</th>
                <th>Chargeable</th>
                <th>Remark</th>

            </tr>
        </thead>
        <tbody>
            <?php
            $snag_model = new FmMasSnag();
            $condition = "t.isActive = 'Y' AND t.area_id = " . $area->id;
            $snag_models = $snag_model->findAll(["condition" => $condition]);
            foreach ($snag_models as $i => $value) {
                $condition_snag_item = "t.header_id = " . $header_id . " AND  t.snag_id = " . $value->id;

                $snag_item_model = new FmSnagItems();
                $snag_item_model = $snag_item_model->find(["condition" => $condition_snag_item]);
                if (empty($snag_item_model)) {
                    $snag_item_model = new FmSnagItems();
                    $snag_item_model->snag_id = $value->id;
                }

                $style = ($snag_item_model->qty > 0) ? "background-color:#FFCCCB;" : "";

            ?>
                <tr style="<?php echo $style;  ?>">
                    <td>
                        <label>
                            <?php echo ($i + 1) ?>
                        </label>
                    </td>
                    <td>
                        <?php echo $form->hiddenField($snag_item_model, "[$key]id"); ?>
                        <?php echo $form->hiddenField($snag_item_model, "[$key]snag_id"); ?>
                        <?php echo $form->textField($value, "[$key]name", ['readonly' => true, 'class' => 'form-control input-sm']); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($snag_item_model, "[$key]repair_qty", ['placeholder' => 'Repair Qty', 'class' => 'text-right form-control input-sm', 'onkeyup' => 'calculateQty(this.id)']); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($snag_item_model, "[$key]replace_qty", ['placeholder' => 'Replace Qty', 'class' => 'text-right form-control input-sm', 'onkeyup' => 'calculateQty(this.id)']); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($snag_item_model, "[$key]qty", ['placeholder' => 'Quantity', 'readonly' => 'true', 'class' => 'text-right form-control input-sm']); ?>
                    </td>

                    <td>
                        <?php echo $form->dropDownList($snag_item_model, "[$key]chargeable", ["N" => "No", "Y" => "Yes"], ['class' => 'form-control input-sm chargeable-select']); ?>
                    </td>
                    <td>
                        <?php echo $form->textField($snag_item_model, "[$key]remark", ['placeholder' => "Remark", 'class' => 'form-control input-sm']); ?>
                    </td>
                </tr>
            <?php
                $key++;
            }
            ?>
        </tbody>
    </table>
<?php } ?>
<script>
    function servicetypechnage(evt, val) {
        var tr = $(evt).closest('tr');
        console.log(tr);
        var class_name = 'type-' + val.toString().toLowerCase();
        console.log(class_name);
        $(tr).attr('class', class_name);
    }

    function calculateQty(field_id) {

        var field_array = field_id.split("_");
        var index = field_array[1];
        var repair_qty = Number($("#FmSnagItems_" + index + "_repair_qty").val());
        if (isNaN(repair_qty)) {
            repair_qty = 0;
            $("#FmSnagItems_" + index + "_repair_qty").val(0);
        }
        var replace_qty = Number($("#FmSnagItems_" + index + "_replace_qty").val());
        if (isNaN(replace_qty)) {
            replace_qty = 0;
            $("#FmSnagItems_" + index + "_replace_qty").val(0);
        }
        var qty = repair_qty + replace_qty;
        $("#FmSnagItems_" + index + "_qty").val(parseFloat(qty).toFixed(2));
    }
</script>
<style>


</style>