<ul class="clearfix form-ul material">
    <?php echo $form->hiddenField($model, 'id'); ?>
    <?php echo $form->hiddenField($model, 'job_id'); ?>
    <?php echo $form->hiddenField($model, 'unit_id'); ?>
    <?php echo $form->hiddenField($model, 'building_id'); ?>
    <li class="col-sm-3">
        <?php
        $model->building_name = $model->building_rel->building_name;
        $model->unit_name = $model->unit_rel->unit_name;
        echo $form->textField($model, 'building_name', array('data-label' => 'Building <span style="color:red">*</span>', 'readonly' => true));
        ?>
    </li>
    <li id="unit-li" class="col-sm-3">
        <?php echo $form->textField($model, 'unit_name', array('data-label' => 'Unit <span style="color:red">*</span>', 'readonly' => true)); ?>
    </li>
    <li class="col-sm-3">
        <?php
        if (empty($model->snag_date)) {
            $model->snag_date = date('d/m/Y');
        } else {
            $model->snag_date = date('d/m/Y', strtotime($model->snag_date));
        }
        echo $form->textField($model, 'snag_date', array('class' => '', 'title' => 'Date', 'data-label' => 'Snag Date <span style="color:red">*</span>'));
        ?>
        <?php echo $form->error($model, 'snag_date'); ?>
    </li>
    <li class="col-sm-3">
        <?php
        $date_model = new DateModel();
        if (empty($model->vacating_date)) {
            $model->vacating_date = date('d/m/Y');
        } else {
            $model->vacating_date = $date_model->displayDate($model->vacating_date);
        }
        echo $form->textField($model, 'vacating_date', array('class' => 'datepicker', 'title' => 'Date', 'data-label' => 'Vacating Date <span style="color:red" >*</span>'));
        ?>
        <?php echo $form->error($model, 'vacating_date'); ?>
    </li>
    <li class="col-sm-3">
        <?php
        if (empty($model->termination_date)) {
            $model->termination_date = date('d/m/Y');
        } else {
            $model->termination_date = $date_model->displayDate($model->termination_date);
        }
        echo $form->textField($model, 'termination_date', array('class' => 'datepicker', 'title' => 'Date', 'data-label' => 'Termination Date <span style="color:red">*</span>'));
        ?>
        <?php echo $form->error($model, 'termination_date'); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->dropdownlist($model, "technician_id", Technician::getSnagTechnician((int) $model->job_id), array('empty' => 'Select', 'data-label' => 'Technician')); ?>
    </li>
    <li class="col-sm-3">
        <?php
        if (!empty($model->type_list)) {
            $model->type_list = explode(",", $model->type_list);
        }

        echo $form->dropdownlist($model, "type_list", MasterIssueType::getIssueType(), array('data-label' => 'Type', 'multiple' => true));
        ?>
    </li>
    <li class="col-sm-4">
        <?php
        echo $form->textField($model, 'charges', array('class' => 'text-right', 'data-label' => 'Charges'));
        ?>
    </li>
    <li class="col-sm-4">
        <?php echo $form->textArea($model, 'observation', array('class' => 'tooltipster', 'title' => 'Description', 'data-label' => 'Observation')); ?>
        <?php echo $form->error($model, 'observation'); ?>
    </li>
</ul>
