<div class="popup_inner_element">
    <?php
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'sales-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false
    ));
    ?>
    <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
        <li class="active">
            <a href="#snag_general" data-toggle="tab">General</a>
        </li>
        <li>
            <a href="#snag_items" data-toggle="tab">Details</a>
        </li>

        <li>
            <a href="#snag_uploads" data-toggle="tab">Uploads</a>
        </li>

    </ul>
    <div class="tab-content">
        <div class="tab-pane active" id="snag_general">
            <?php
            $this->renderPartial('general', array('model' => $model, 'form' => $form));
            ?>
        </div>
        <div class="tab-pane" id="snag_items">
            <?php
            $this->renderPartial('snag_items', array('model' => $model, 'form' => $form));
            ?>
        </div>

        <div class="tab-pane" id="snag_uploads">
            <?php
           $this->renderPartial('snag_uploads', array('model' => $model, 'form' => $form));
            ?>
        </div>

    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-danger" id="qtn_close" data-dismiss="modal">Close</button>
        <?php
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_add"]) || ((int) Yii::app()->user->havePermissionOn["fm_snag_edit"])) {


            $url = Yii::app()->createUrl('fm/snag/save');
            echo CHtml::ajaxSubmitButton('Save', $url, array(
                'dataType' => 'json',
                'type' => 'post',
                'success' => 'function(data) {
                                    if(data.status=="success"){
                                        t8.success("Ticket Saved!","Success");
                                        $(".x.close").click();
                                        //location.href="index.php?r=fm/ticket/index";

                                        reloadTable(table_id);
                                    } else {
                                        $("#loader").hide();
                                        $("#sales-form .sales-save-btn").prop("disabled", false);
                                        $("#sales-form .sales-save-btn").addClass("btn-theme").removeClass("btn_loading");
                                        $.each(data, function(key, val) {
                                                $("#sales-form #"+key+"_em_").text(val).show();
                                                t8.error(""+val+"");
                                            });
                                    }
                            }',
                'beforeSend' => 'function(){
                            $(".toast8-error").hide();
                                    $(".toast8-error").hide();
                                    $("#loader").show();
                                    //$("#sales-form .sales-save-btn").prop("disabled", true);
                                  //  $("#sales-form .sales-save-btn").addClass("btn_loading").removeClass("btn-theme");
                            }',
                'complete' => 'function(){
                                $("#loader").hide();

                            }'
            ), array('id' => 'save_convert' . rand(), 'class' => 'sales-save-btn btn btn-theme'));
        }
        ?>
    </div>
    <?php $this->endWidget(); ?>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("documentupload", "function documentupload(type_id){
    jQuery.ajax({
      'data' :{'type_id':type_id},
    //  'dataType' : 'json',
      'type':'post',
      'url': '" . Yii::app()->createUrl('fm/ticket/documentupload') . "',
      'success': function(data) {
        $('#document_upload_2').show();
        $('#document_upload_2').html(data);
  }
 });
}", CClientScript::POS_HEAD);
?>