<?php
$cs = Yii::app()->getClientScript();
?>



<script>
    param_indexx = 7;
    $(document).ready(function() {
        table_id = "#tbl_job_details";
        table = $(table_id).on("preXhr.dt", function(e, settings, data) {

            data.contract_id = $("#contract_id").val();

            return data;
        }).DataTable({

            scrollY: "300px",
            pageLength: 50,
            processing: true,
            "order": [
                [0, "desc"]
            ],
            ajax: {

                url: "<?php echo Yii::app()->createUrl('fm/plannedmaintenance/GetContractJobList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            // "fnCreatedRow": function(nRow, aData, iDataIndex) {
            //     $(nRow).addClass("context-menu");
            // },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                // AddContextMenu(nRow, aData);
                //alert(aData[6].color_code);
                $("td", nRow).css("background-color", aData[param_indexx].color_code);
                var status_id = aData[param_indexx].status_id.toString().trim();
                if (status_id === "5") {
                    $("td", nRow).css("text-decoration", "line-through");
                }
            }



        });
    });

 /*    function AddContextMenu(row, datas) {

        var mas_edit = 0;
        var mas_disable = 0;

        <?php //if (isset(Yii::app()->user->havePermissionOn['job_order_edit']) || Yii::app()->user->authorised_user == 1) { ?>

            var mas_edit = 1;
        <?php //} ?>

        <?php //if (isset(Yii::app()->user->havePermissionOn['master_country_disable']) || Yii::app()->user->authorised_user == 1) { ?>

            var mas_disable = 1;
        <?php //} ?>

        $(row).contextMenu({

            selector: 'td',
            items: {

                "printjob": {

                    name: "Print Job",
                    icon: "fa-print",
                    accesskey: "e",
                    callback: function() {

                        var url = "index.php?r=fm/ticket/print&id=" + datas[param_indexx].id;
                        window.open(url);
                    },
                    disabled: function(key, opt) {

                        // this references the trigger element

                        if (mas_edit == '0') {

                            return !this.data('editDisabled');
                        }

                    }

                },



            }

        });
    } */
</script>

<section class="panel">

    <header class="panel-heading clearfix panel-theame">

        <i class="fa fa-bank"></i> Job Order
    </header>

    <div class="panel-body">

        <div class="custom-data-table">

           <?php echo CHtml::hiddenField('contract_id', $model->id); ?>

                <table class="table table-hover table-bordered personal-task" id="tbl_job_details" style="font-size:13px;">

                    <thead>

                        <tr>

                            <th>Job Order No</th>
                            <th>Issue Type</th>

                            <th>Unit</th>

                            <th>Notes</th>

                            <th>Ticket Date</th>

                            <th>Ticket Status</th>



                        </tr>

                    </thead>



                </table>

                <div>
                    <?php
                    $statusList = FmTicketStatus::model()->findAll(["condition" => "isActive ='Y' ", 'order' => 'status_name desc']);
                    foreach ($statusList as $key => $value) {
                    ?>
                        <div class="color-box" style="background: <?= $value->color_code ?>">
                            <?php echo ucwords($value->status_name) ?>
                        </div>
                    <?php
                    }
                    ?>
                </div>
         
        </div>

    </div>

</section>
<style>
    .status-Q {
        background: #04aa6d;
    }

    .status-I {
        background: #04aa6d;
    }

    .color-box {
        width: 150px;
        float: right;
        display: inline;
        padding: 2px;
        padding-left: 6px;
        margin: 4px;
        border: 1px #f3f6f4 solid;
        border-radius: 3px;
    }
</style>