<style>
    tfoot {
        background-color: #d0f5c5; 
    }
</style>


<script>
    $(document).ready(function() {
        loadIssueList();
    });
    function loadIssueList() {
        var table_id = "#tbl_issues_details";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.contract_id = $("#contract_id").val();
            return data;
        }).DataTable({
            //scrollY: "645px",
                scrollY: "300px",
            
            pageLength: 50,
            processing: true,
            columns: [{
                    className: "nw sl col-max-1"
                },
                {
                    className: "nw sl col-max-4"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-3"
                },
                {
                    className: "nw sl col-max-3 text-right"
                },
            ],
            "columnDefs": [{
                /*  "targets": [9, 8],
                 "visible": false, */
            }, ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fm/plannedmaintenance/GetContractIssueList') ?>",
                type: "POST",
                cache: false,
            },
             "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(5).footer()).html(Number(json.total).toFixed(2));
                            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            }
        });
        $('#tbl_issues_details tbody').on('mouseover', 'tr', function() {
            $.contextMenu('destroy');
        });
        $('#tbl_issues_details tbody').on('click', 'tr', function() {
            var data = table.row(this).data();
            var posted = data[4];

            var ticket = data[5];
            $.contextMenu({
                selector: '.context-menu',
                callback: function(key, options) {
                    var action_id = key;
                    var id = data[1];
                    var part_number = data[1];
                    if (action_id == "print") {
                        window.open($('#liveSite').val() + "/index.php?r=issues/PrintPDF&id=" + id, "_blank")
                    }
                },
                items: {
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_issue_view"])) { ?> "print": {
                            name: "Print Issue",
                            icon: "fa-print"
                        },
                    <?php } ?>
                }
            });
        });
    }
</script>



<div class="tab-content">
    <div class="tab-pane active" id="issue_index_2">
        <section class="panel">
            
             <header class="panel-heading clearfix panel-theame">
          
            <i class="fa fa-user"></i> Issues  

        </header>
        
         <?php echo CHtml::hiddenField('contract_id', $model->id); ?>
            <div class="panel-body">

                    <div class="custom-data-table">
                        <table class="table table-hover table-bordered personal-task" id="tbl_issues_details" style="font-size:13px;">
                            <thead>
                                <tr>
                                    <th>Job Order No</th>
                                    <th>Issue No</th>
                                    <th>Issue Date</th>
                                    <th>Customer</th>
                                    <th>Reference</th>
                                     <th>Amount</th>
                                </tr>
                            </thead>
                <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th>Total:</th>
                        <th></th>
                       
                    </tr>
                </tfoot>
                        </table>
                    </div>
             
            </div>
        </section>
    </div>


</div>