
<table class="table table-hover table-bordered personal-task" id="tbl-planned-list">
    <thead style="background-color: #1f67b2; color:white">
        <tr>
            <th style="width: 2%">#</th>
            <th style="width: 8%">Planned Dates</th>
            <th>Remark</th>
            <th class="text-center">
                <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="addPlannedTableRow($('#tbl-planned-list'));">
                    <i class="fa fa-plus"></i>
                </a>
            </th>
    </thead>
    <tbody>
        <?php
        foreach ($planned_services as $key => $planned_service_each) {
            $is_converted = ($planned_service_each->is_converted == "Y");
            ?>
            <tr style="background-color: <?= ($is_converted) ? "#aef2a7" : "" ?>">
                <td>
                    <label>
                        <?php echo ($key + 1) ?>
                    </label>
                </td>
                <td>
                    <?php
                    if (!empty($planned_service_each->planned_date)) {
                        $planned_service_each->planned_date = date("d/m/Y", strtotime($planned_service_each->planned_date));
                    }


                    echo CHtml::activeTextField($planned_service_each, "[$key]planned_date", [
                        'class' => 'form-control go datepicker',
                        'readonly' => $is_converted])
                    ?>
                    <?php echo CHtml::activeHiddenField($planned_service_each, "[$key]id") ?>
                    <?php echo CHtml::activeHiddenField($planned_service_each, "[$key]is_converted") ?>
                </td>
                <td>
                    <?php
                    echo CHtml::activeTextArea($planned_service_each, "[$key]remark", ['class' => 'form-control go',
                        'readonly' => $is_converted
                    ])
                    ?>
                </td>
                <td class="text-center" >
                    <?php if ($planned_service_each->is_converted != "Y") { ?>
                        <a class="btn btn-xs btn-danger " onclick="removePannedDateTableRow($('#tbl-planned-list'), this)" title="Remove this item" href="javascript:void(0);">
                            <i class="fa fa-times"></i>
                        </a>
                    <?php } ?>
                </td>
            </tr>
            <?php
        }
        ?>
    </tbody>
</table>
<script>
    function removePannedDateTableRow(jQtable, evt) {
        var dResult = confirm("Do you want to delete this?");
        if (dResult) {
            formIdStarter = jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows = jQtable.find('tr:gt(0)').length;
            var input_array = $(evt).parents('tr').find('input:first').attr('id').toString().split("_");
            var row_index = input_array[1];

            var id = $("#FmPlannedSchedule_" + row_index + "_id").val();
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=fm/plannedmaintenance/deleteplanned',
                cache: false,
                data: {id: id},
                success: function (data) {
                    if (data.status == "success") {
                        if (num_rows > 1) {
                            $(evt).parents('tr').remove();
                        } else {
                            $(evt).parents('tr').find('input, textarea, select').val('');
                        }
                        var i = 0;
                        jQtable.find('tr:gt(0)').each(function () {
                            $(this).find('input,select,textarea,.errorMessage').each(function () {
                                old_id = $(this).attr('id');
                                new_id = old_id.replace(/\d+/, i);
                                $(this).attr('id', new_id);
                                old_name = $(this).attr('name');
                                if (old_name !== undefined) {
                                    new_name = old_name.replace(/\d+/, i);
                                    $(this).attr('name', new_name);
                                }
                            });
                            $(this).find('td:first label').html(++i);
                        });
                    } else {
                        $.each(data, function (key, val) {
                            $("#plate-type-form #" + key + "_em_").text(val).show();
                            t8.error("" + val + "");
                        });
                    }
                },
            });
        }
    }
</script>
<script>
    function addPlannedTableRow(jQtable) {
        formId = jQtable.attr('id');
        formIdStarter = jQtable.attr('id').split(/_(.+)?/)[0];
        lastId = jQtable.find('tr:last input:first').attr('id');
        thenum = lastId.match(/\d+/g);        //alert(lastId);
        newId = Number(thenum) + 1;
        newrow = jQtable.find('tr:last').clone();
        //newrow= jQtable.find('tr:last').clone();
        newrow.find('label:first').html(newId + 1);
        newrow.attr('class', newId);
        newrow.find('.hasDatepicker').removeClass('hasDatepicker');
        newrow.find('.datetimepicker').siblings().remove();
        newrow.find('.datetimepicker').datetimepicker('destroy');
        newrow.find('div,input,textarea,checkbox,td,select,.errorMessage,a,span').each(function () {
            this.id = this.id.replace(/\d+/, newId);
            if (!$(this).is(':checkbox'))
                this.value = '';
            else
                $(this).prop('checked', false);
            (this.name !== undefined) ? this.name = this.name.replace(/\d+/, newId) : this.style = '';
        });
        jQtable.append(newrow);
        $('#FmPlannedSchedule_' + newId + '_planned_date').datetimepicker({
            format: 'DD/MM/YYYY'
        });
    }

</script>
