<?php
$condition = "t.header_id= '$model->id' AND is_converted ='N' ";
$planned_services = FmPlannedSchedule::model()->findAll(["condition" => $condition, 'order' => "planned_date"]);
$condition_completed = "t.header_id= '$model->id' AND is_converted ='Y' ";
$completed_services = FmPlannedSchedule::model()->findAll(["condition" => $condition_completed, 'order' => "planned_date"]);

if (!empty($completed_services)) {
    ?>
    <div class="table-responsive">
        <table class="table table-hover table-bordered personal-task">
            <thead style="background-color: green; color:white">

                <tr>
                    <th>Planned Date</th>
                    <th>Remark</th>
                    <th>Job Order #</th>
                    <th>Job Created</th>
                    <th>Job Status</th>
                    <th></th>
                </tr>
            </thead>
            <?php foreach ($completed_services as $key => $value) {
                ?>
                <tr>
                    <td>
                        <?php echo date("d/m/Y", strtotime($value->planned_date)); ?>
                    </td>
                    <td>
                        <?php echo nl2br($value->remark) ?>
                    </td>
                    <td>
                        <?php echo $value->ticket_id ?>
                    </td>
                    <td>
                        <?php echo date("d/m/Y", strtotime($value->job->ticket_date)) ?>
                    </td>
                    <td>
                        <?php echo $value->job->status_details->status_name ?>
                    </td>
                    <td class="text-center">
                        <a class="btn btn-xs btn-danger" href="javascript:void(0);" onclick="loadPopupModal('fm/ticket/create&id=<?= $value->ticket_id ?>', 'Job Order # <?= $value->ticket_id ?>', 'xl')">
                            <i class="fa fa-edit"></i>
                        </a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </table>

    </div>
    <?php
}
if (empty($planned_services)) {
    $planned_services = [new FmPlannedSchedule()];
}
if ($model->isNewRecord) {
    ?>
    <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="generatePlannedDate()">
        <i class="fa fa-plus"></i> Generate Schedule
    </a>
    <?php
}
?>
<div class="table-responsive" id="div-planned-container">
    <?php $this->renderpartial('planned_date_table', ['planned_services' => $planned_services,]); ?>
</div>
<script>
    function generatePlannedDate() {
        jQuery.ajax({
            dataType: 'html',
            type: 'POST',
            url: 'index.php?r=fm/Plannedmaintenance/generateschedule',
            cache: false,
            data: $("form").serialize(),
            success: function (data) {
                $("#div-planned-container").html(data);
            },
            complete: function () {
                $("#loader").hide();
            },
            beforeSend: function () {
                $("#loader").show();
            }
        });
    }


</script>