<ul class="clearfix form-ul material">

    <?php echo $form->hiddenField($model, 'id'); ?>

    <li class="col-sm-3">
        <?php echo $form->dropdownlist($model, 'property_id', FmMasBuilding::getBuildings(), array('data-label' => 'Building <span style="color:red">*</span>', 'onchange' => 'onbuildingChange()', 'empty' => 'Select', 'data-search' => true)); ?>
    </li>

    <li id="unit-li" class="col-sm-3">
        <?php echo $form->dropdownlist($model, 'unit_id', MasBuildingUnit::getUnit((int) $model->property_id), array('data-label' => 'Unit <span style="color:red">*</span>', 'empty' => 'Select', 'data-search' => true,'onchange' => 'getCustName(this.value)')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'contract_start_date', array('data-label' => 'Contract Start Date <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->textField($model, 'contract_end_date', array('data-label' => 'Contract End Date <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->dropdownList($model, 'contract_type_id', MasterPeriodType::getPeriodType(), array('data-label' => 'Contract Type ', 'empty' => '-Select-')); ?>
        <?php echo $form->error($model, 'contract_type'); ?>
    </li>
    <li class="col-sm-3">
        <?php echo $form->dropdownList($model, 'service_frequency_id', FmMasFrequency::getAll(), array('data-label' => 'Contract Frequency ', 'empty' => '-Select-')); ?>
        <?php echo $form->error($model, 'service_frequency'); ?>
    </li>

    <li class="col-sm-3">
        <?php

        $modproject_classification = new MasProjectClassification();
        echo $form->dropDownList($model, 'project_classification_id', $modproject_classification->getProjectClassification(), array('class' => '', 'data-label' => 'Project Classification', 'empty' => '-Select-'));
        ?>

    </li>
    <li class="col-sm-3">
       

        <?php
        $customer_name = '';
        if ($model->id > 0) {
            $customer = new Customer();
            $customer = $customer->findbypk((int)$model->customer_id);
            $customer_name = $customer->customer_name;
            $MasBuildingUnit = new MasBuildingUnit();
            $MasBuildingUnit = $MasBuildingUnit->findbypk((int)$model->unit_id);
            $unit_address = $MasBuildingUnit->address;
        }
        echo CHtml::textField('customer_name', $customer_name, array('data-label' => 'Customer ', 'readonly' => true));  ?>
        <?php echo $form->hiddenField($model, 'customer_id', array('value' => $model->customer_id)); ?>
   
        
    </li>
    <li class="col-sm-2">
        <?php


        echo $form->textField($model, 'contract_amount', array('data-label' => 'Contract Amount', 'class' => '')); ?>

    </li>
    <li class="col-sm-2">
        <?php
        if ($model->id > 0) {
            $collected_amount = Yii::app()->db->createCommand("select IFNULL(SUM(grand_total),0)  from {{invoice}} where invoice_status='Y'  AND (contract_id ='" . $model->id . "')")->queryScalar();
        } else {
            $collected_amount = 0;
        }

        echo   CHtml::TextField('collected_amount',   Yii::app()->numberFormatter->formatCurrency($collected_amount, ""), array('disabled' => true, 'data-label' => 'Invoiced Amount', 'class' => '')); ?>

    </li>
    <li class="col-sm-2">
        <?php
        if ($model->id > 0) {
            $balace_contract = $model->contract_amount - (float)$collected_amount;
        } else {
            $balace_contract = 0;
        }

        echo   CHtml::TextField('balace_contract',   Yii::app()->numberFormatter->formatCurrency($balace_contract, ""), array('disabled' => true, 'data-label' => 'Balance Contract', 'class' => '')); ?>

    </li>
    <li class="col-sm-6">
        <?php echo $form->textArea($model, 'remark', array('data-label' => 'Remark')); ?>
    </li>


</ul>



<script>
function getCustName(val) {

        jQuery.ajax({
            'type': 'post',
            'dataType': 'json',
            'url': '<?php echo Yii::app()->createUrl('fm/Ticket/getCustName') ?>',
            'data': {
                'unit_id': val
            },
            'cache': false,
            'success': function(data) {
                if (data.status == 'success') {
                    $('#customer_name').val(data.cust_name);
                    $('#customer_ph').val(data.cust_ph);
                    $('#unit_address').val(data.unit_address);
                    $('#FmPlannedMaintenance_customer_id').val(data.cust_id);
                    $('#customer_name').focus();
                    $('#customer_ph').focus();
                    $('#unit_address').focus();

                }
            }
        });
    }
    
    function onbuildingChange() {
        var building_id = $("#FmPlannedMaintenance_property_id").val();
        jQuery.ajax({
            dataType: 'html',
            type: 'POST',
            url: 'index.php?r=fm/dropdown/plannedbuildingunit',
            cache: false,
            data: {
                building_id: building_id
            },
            success: function(data) {
                $("#unit-li").html(data);
            },
            complete: function() {

            },
            beforeSend: function() {
                //   $("#loader").show();
            }
        });
    }
</script>