<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'period-type-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-4">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'name', array('data-label' => 'Name<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'name'); ?>
            </li>
            <li class="col-sm-4">
                <?php echo $form->dropDownList($model, 'area_id', FmMasArea::getAll(), array('data-label' => 'Area<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
                <?php echo $form->error($model, 'area_id'); ?>
            </li>
            <li class="col-sm-4">
                <?php
                if (!empty($model->service_id)) {
                    $model->service_name = $model->service_rel->description;
                }

                echo $form->hiddenField($model, 'service_id');
                ?>
                <?php echo $form->textField($model, 'service_name', array('data-label' => 'Service Name<span style="color:red">*</span>', 'data-validation' => 'required')); ?>
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="period_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('fm/massnag/Save');
    echo CHtml::ajaxSubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){

                                         t8.success("Details Saved successfully!");

                                         $("#period_close").click();

                                         reloadTable(table_id);

                                         //location.reload();

                                    } else {

                                        $("#period_type-form .period_type-btn").prop("disabled", false);

                                         $.each(data, function(key, val) {

                                                $("#period_type-form #"+key+"_em_").text(val).show();

                                                t8.error(""+val+"");

                                            });

                                    }

                                    }',
        'beforeSend' => 'function(){
$("#loader").show();
                                        $(".toast8-error").hide();

                                        $("#period_type-form .period_type-save-btn").prop("disabled", true);

                                        //$("#period_type-form .period_type-save-btn").addClass("btn_loding").removeClass("btn-theme");

                                    }'
            ), array('id' => 'mybtn' . rand(), 'class' => 'period_type-save-btn btn btn-theme'));
    ?>
</div>

<?php $this->endWidget(); ?>
<script>
    // on ready function
    $(document).ready(function () {
        var url = "index.php?r=fm/massnag/getservice";
        $('#FmMasSnag_service_name').autocomplete({
            minLength: 1,
            source: function (request, response) {
                autoCompleteSource(request, response, url)
            },
            select: function (event, ui) {
                event.preventDefault();
                var product_id = ui.item.value;
                var label = ui.item.label;
                $('#FmMasSnag_service_id').val(product_id);
                $('#FmMasSnag_service_name').val(label);
            }
        });

    });

</script>