<?php

/**
 * This is the model class for table "{{fm_ticket_request_materials}}".
 *
 * The followings are the available columns in table '{{fm_ticket_request_materials}}':
 * @property integer $id
 * @property integer $ticket_id
 * @property string $ticket_item_id
 * @property string $description
 * @property string $quantity
 * @property integer $unit_id
 * @property string $unit_name
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class TicketRequestMaterials extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_ticket_request_materials}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ticket_id, ticket_item_id, description, quantity, unit_id, unit_name', 'required'),
            array('ticket_id, unit_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('ticket_item_id', 'length', 'max' => 25),
            array('quantity', 'length', 'max' => 15),
            array('unit_name', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, ticket_id, ticket_item_id, description, quantity, unit_id, unit_name, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ticket_det' => array(self::BELONGS_TO, 'TicketHeader', 'ticket_id'),
            'unit_det' => array(self::BELONGS_TO, 'Unit', 'unit_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'ticket_id' => 'Ticket',
            'ticket_item_id' => 'Ticket Item',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_id' => 'Unit',
            'unit_name' => 'Unit Name',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('ticket_id', $this->ticket_id);
        $criteria->compare('ticket_item_id', $this->ticket_item_id, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('quantity', $this->quantity, true);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('unit_name', $this->unit_name, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return TicketRequestMaterials the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
