<?php

/**
 * This is the model class for table "{{fm_ticket_job_time}}".
 *
 * The followings are the available columns in table '{{fm_ticket_job_time}}':
 * @property integer $id
 * @property integer $ticket_id
 * @property integer $technician_id
 * @property integer $ticket_item_id
 * @property string $job_start_time
 * @property string $job_end_time
 * @property string $status
 * @property integer $created_by
 * @property string $created_date_time
 * @property string rate
 * @property string working_hours,
 * @property string total_cost
 */
class TicketJobTime extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_ticket_job_time}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ticket_id, technician_id, ticket_item_id, allot_type_id', 'required'),
            array('ticket_id, technician_id, ticket_item_id, created_by, allot_type_id', 'numerical', 'integerOnly' => true),
            array('rate, working_hours, total_cost', 'numerical'),
            array('status', 'length', 'max' => 3),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, ticket_id, technician_id, ticket_item_id, job_start_time, job_end_time, status, created_by, created_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'technician_det' => array(self::BELONGS_TO, 'Technician', 'technician_id'),
            'ticket_header_det' => array(self::BELONGS_TO, 'TicketHeader', 'ticket_id'),
            'allot_type' => array(self::BELONGS_TO, 'FmAllotType', 'allot_type_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'ticket_id' => 'Ticket',
            'technician_id' => 'Technician',
            'ticket_item_id' => 'Ticket Item',
            'job_start_time' => 'Job Start Time',
            'job_end_time' => 'Job End Time',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('ticket_id', $this->ticket_id);
        $criteria->compare('technician_id', $this->technician_id);
        $criteria->compare('ticket_item_id', $this->ticket_item_id);
        $criteria->compare('job_start_time', $this->job_start_time, true);
        $criteria->compare('job_end_time', $this->job_end_time, true);
        $criteria->compare('status', $this->status, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return TicketJobTime the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function calculateCost() {
        if (!empty($this->id)) {
            $this->rate = $this->technician_det->unit_hour_rate;
            if ($this->status == "OUT") {
                $starttimestamp = strtotime($this->job_start_time);
                $stoptimestamp = strtotime($this->job_end_time);
                $this->working_hours = abs($stoptimestamp - $starttimestamp) / (60 * 60);
                $this->total_cost = $this->rate * $this->working_hours;
            }
        }
    }

}
