<?php

/**
 * This is the model class for table "{{fm_ticket_details}}".
 *
 * The followings are the available columns in table '{{fm_ticket_details}}':
 * @property integer $id
 * @property integer $ticket_id
 * @property integer $issue_id
 * @property string $issue_remarks
 * @property integer $issue_status
 * @property string $notes
 * @property integer $created_by
 * @property string $created_date_time
 */
class TicketDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fm_ticket_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ticket_id,issue_status', 'required'),
			array('ticket_id, issue_id, issue_status, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, ticket_id, issue_id, issue_remarks, issue_status, notes, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		     'issue_details' => array(self::BELONGS_TO, 'MasterIssueType','issue_id'),
		     'ticket_header_det' => array(self::BELONGS_TO, 'TicketHeader','ticket_id'),
		);
	}


	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ticket_id' => 'Ticket',
			'issue_id' => 'Issue',
			'issue_remarks' => 'Issue Remarks',
			'issue_status' => 'Issue Status',
			'notes' => 'Notes',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('ticket_id',$this->ticket_id);
		$criteria->compare('issue_id',$this->issue_id);
		$criteria->compare('issue_remarks',$this->issue_remarks,true);
		$criteria->compare('issue_status',$this->issue_status);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return TicketDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	
	public static function getPriority() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $model = self::model()->findAll(array('order'=>'id'));
        return CHtml::listData($model, 'id', 'issue_priority');
    }
    public function getStatus() {
	    $status = '-';
	    if($this->issue_status==1){
	        $status = 'Open';
	    }
	    else if($this->issue_status==2){
	        $status = 'Allotted';
	    }
	    else if($this->issue_status==3){
	        $status = 'Completed';
	    }else if($this->issue_status==4){
	        $status = 'Closed';
	    }
        return $status;
    }
    public static function getIssueStatus() {
        $status_array = array("1"=>"Open","2"=>"Allotted","3"=>"Completed","4"=>"Closed");
        return $status_array;
    }
    /*public static function findticketdet($ticketid) {
        $condition = '1=1';
        if ($ticketid > 0) {
            $condition .= ' AND ticket_id="' . $branch . '"';
        }
        $model_details = self::model()->findAll(array('condition' => $condition));
        $arr_id = array();
        foreach ($model_details as $key => $value) 
        {
            
        }    
    }*/
}
