<?php

/**
 * This is the model class for table "{{fm_technician}}".
 *
 * The followings are the available columns in table '{{fm_technician}}':
 * @property integer $id
 * @property string $technician_name
 * @property string $mobile_no
 * @property string $remarks
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Technician extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_technician}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
// NOTE: you should only define rules for those attributes that
// will receive user inputs.
        return array(
            array('technician_name,technician_type,mobile_no,sort_order', 'required'),
            array('created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('sort_order', 'numerical', 'min' => 0, 'integerOnly' => true),
            array('technician_name, mobile_no,unit_hour_rate', 'length', 'max' => 255),
            array('unit_hour_rate', 'numerical', 'min' => 0),
            array('technician_name', 'unique'),
            array('remarks', 'length', 'max' => 5000),
            array('is_active', 'length', 'max' => 1),
            array('sort_order', 'unique'),
            // The following rule is used by search().
// @todo Please remove those attributes that should not be searched.
            array('id, technician_name,technician_type, mobile_no, remarks, is_active, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
// NOTE: you may need to adjust the relation name and the related
// class name for the relations automatically generated below.
        return array(
            'technician_type_det' => array(self::BELONGS_TO, 'MasterTechnicianType', 'technician_type'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'technician_name' => 'Technician Name',
            'mobile_no' => 'Mobile No',
            'remarks' => 'Remarks',
            'is_active' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
            'sort_order' => 'Sort Order',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
// @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('technician_name', $this->technician_name, true);
        $criteria->compare('mobile_no', $this->mobile_no, true);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('is_active', $this->is_active, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('sort_order', $this->sort_order, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Technician the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getTechnician() {
        $condition = 'is_active =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
        return CHtml::listData($model, 'id', 'technician_name');
    }

    public static function getFreeTechnician() {
        $condition = "is_active =  'Y' AND t.id NOT IN ( select distinct technician_id  from {{fm_ticket_job_time}} where status ='IN' ) ";
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
        return CHtml::listData($model, 'id', 'technician_name');
    }

    public static function getSnagTechnician($ticket_id) {
        $condition = "is_active =  'Y' AND t.id IN ( select distinct technician_id  from {{fm_ticket_allot_technicians}} where ticket_id = $ticket_id AND allot_type_id = " . FmAllotType::TYPE_INSPECTION . " ) ";
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
        return CHtml::listData($model, 'id', 'technician_name');
    }

}
