<?php

/**
 * This is the model class for table "{{fm_master_period_type}}".
 *
 * The followings are the available columns in table '{{fm_master_period_type}}':
 * @property integer $id
 * @property string $period_type
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 */
class MasterPeriodType extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_master_period_type}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('period_type,sort_order', 'required'),
            array('created_by', 'numerical', 'integerOnly' => true),
               array('sort_order', 'numerical','min'=>0, 'integerOnly' => true),
            array('period_type', 'length', 'max' => 255),
            array('is_active', 'length', 'max' => 1),
            array('period_type', 'unique'),
            array('sort_order', 'unique'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, period_type, is_active, created_by, created_date_time,sort_order', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'period_type' => 'Period Type',
            'is_active' => 'Is Active',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'sort_order' => 'Sort Order',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('period_type', $this->period_type, true);
        $criteria->compare('is_active', $this->is_active, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('sort_order', $this->created_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasterPeriodType the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getPeriodType() {
        //$condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id;
        $condition = 'is_active =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'period_type'));
        return CHtml::listData($model, 'id', 'period_type');
    }

}
