<?php

/**
 * This is the model class for table "{{fm_machinery}}".
 *
 * The followings are the available columns in table '{{fm_machinery}}':
 * @property integer $id
 * @property string $machine_name
 * @property string $machine_id
 * @property string $make
 * @property string $model_no
 * @property string $year_of_manufacture
 * @property string $serial_no
 * @property string $location
 * @property string $item_type
 * @property string $capacity
 * @property string $preferred_vendor
 * @property string $period_type
 * @property string $start_date
 * @property string $end_date
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class Machinery extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fm_machinery}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('machine_name, machine_id, make,start_date, end_date', 'required'),
			array('machine_id', 'unique'),
			array('created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('machine_name, machine_id, make, model_no, serial_no, location, capacity, preferred_vendor,main_item_id', 'length', 'max'=>255),
			array('year_of_manufacture', 'length', 'max'=>4),
			array('item_type, is_active', 'length', 'max'=>1),
			array('period_type', 'length', 'max'=>8),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, machine_name, machine_id, make, model_no, year_of_manufacture, serial_no, location, item_type, capacity, preferred_vendor, period_type, start_date, end_date, is_active, created_by, created_date_time, updated_by, updated_date_time,main_item_id', 'safe', 'on'=>'search'),
	
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'period_details' => array(self::BELONGS_TO, 'MasterPeriodType','period_type'),
                    'machinery_details' => array(self::BELONGS_TO, 'Machinery','id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'machine_name' => 'Machine Name',
			'machine_id' => 'Machine',
			'make' => 'Make',
			'model_no' => 'Model No',
			'year_of_manufacture' => 'Year Of Manufacture',
			'serial_no' => 'Serial No',
			'location' => 'Location',
			'item_type' => 'Item Type',
			'capacity' => 'Capacity',
			'preferred_vendor' => 'Preferred Vendor',
			'period_type' => 'Period Type',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'is_active' => 'Is Active',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('machine_name',$this->machine_name,true);
		$criteria->compare('machine_id',$this->machine_id,true);
		$criteria->compare('make',$this->make,true);
		$criteria->compare('model_no',$this->model_no,true);
		$criteria->compare('year_of_manufacture',$this->year_of_manufacture,true);
		$criteria->compare('serial_no',$this->serial_no,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('item_type',$this->item_type,true);
		$criteria->compare('capacity',$this->capacity,true);
		$criteria->compare('preferred_vendor',$this->preferred_vendor,true);
		$criteria->compare('period_type',$this->period_type,true);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Machinery the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getMainitem() 
	{
        $condition = 'is_active =  "Y" AND item_type = "M"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'machine_name');
    }
    
    public static function getMachinery() {
        $condition = 'is_active =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'machine_id', 'machine_name');
    }
    
    public static function listYears($less,$high) {
        $arr_years = array();
        $cur_year  = date("Y");
        $start_year = $cur_year-$less;
        $end_year = $cur_year+$high;
        for ($i=$start_year;$i<=$end_year;$i++){
          $arr_years[$i]=$i;
        }
        return $arr_years;
    }
}
