<?php

/**
 * This is the model class for table "{{fm_machine_maintenance_schedules}}".
 *
 * The followings are the available columns in table '{{fm_machine_maintenance_schedules}}':
 * @property integer $id
 * @property string $planned_date
 * @property string $actual_date
 * @property string $maintanance_value
 * @property string $added_by
 * @property string $remarks
 * @property integer $period_type
 * @property integer $created_by
 * @property string $created_date_time
 */
class MachineMaintenanceSchedules extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fm_machine_maintenance_schedules}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('planned_date', 'required'),
			array('period_type, created_by', 'numerical', 'integerOnly'=>true),
			array('maintanance_value', 'length', 'max'=>15),
			array('remarks', 'length', 'max'=>1000),
			array('added_by', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, planned_date, actual_date, maintanance_value, added_by, remarks, period_type, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'machinery' => array(self::BELONGS_TO, 'Machinery','machinery_id'),
                    'period_details' => array(self::BELONGS_TO, 'MasterPeriodType','period_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'planned_date' => 'Planned Date',
			'actual_date' => 'Actual Date',
			'maintanance_value' => 'Maintanance Value',
			'added_by' => 'Added By',
			'remarks' => 'Remarks',
			'period_type' => 'Period Type',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('planned_date',$this->planned_date,true);
		$criteria->compare('actual_date',$this->actual_date,true);
		$criteria->compare('maintanance_value',$this->maintanance_value,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('remarks',$this->remarks,true);
		$criteria->compare('period_type',$this->period_type);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MachineMaintenanceSchedules the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
