<?php

/**
 * This is the model class for table "{{fm_ticket_status}}".
 *
 * The followings are the available columns in table '{{fm_ticket_status}}':
 * @property integer $id
 * @property string $status_name
 */
class FmTicketStatus extends CActiveRecord {

    const OPEN = 1;
    const ALLOTED = 2;
    const COMPLETED = 3;
    const CLOSED = 4;
    const CANCELLED = 5;
    const WORK_IN_PROGRESS = 6;
    const WORK_FINISHED = 7;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_ticket_status}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
// NOTE: you should only define rules for those attributes that
// will receive user inputs.
        return array(
            array('status_name', 'required'),
            array('status_name', 'length', 'max' => 20),
            // The following rule is used by search().
// @todo Please remove those attributes that should not be searched.
            array('id, status_name', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
// NOTE: you may need to adjust the relation name and the related
// class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'status_name' => 'Status Name',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
// @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('status_name', $this->status_name, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmTicketStatus the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getAll() {
        $condition = "isActive = 'Y' ";
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'status_name');
    }

}
