<?php

/**
 * This is the model class for table "{{fm_snag}}".
 *
 * The followings are the available columns in table '{{fm_snag}}':
 * @property integer $id
 * @property integer $job_id
 * @property integer $unit_id
 * @property integer $building_id
 * @property string $snag_date
 * @property string $time_in
 * @property string $time_out
 * @property integer $technician_id
 * @property string $observation
 * @property string $charges
 */
class FmSnag extends CActiveRecord {

    public $building_name;
    public $unit_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_snag}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('job_id, unit_id, building_id, snag_date, time_in, time_out, technician_id', 'required'),
            array('job_id, unit_id, building_id, technician_id', 'numerical', 'integerOnly' => true),
            array('observation, signature', 'length', 'max' => 1024),
            array('charges', 'numerical', 'min' => 0),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, job_id, unit_id, building_id, snag_date, time_in, time_out, technician_id, observation, charges', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'building_rel' => array(self::BELONGS_TO, 'FmMasBuilding', 'building_id'),
            'unit_rel' => array(self::BELONGS_TO, 'MasBuildingUnit', 'unit_id'),
            'technician_rel' => array(self::BELONGS_TO, 'Technician', 'technician_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'job_id' => 'Job',
            'unit_id' => 'Unit',
            'building_id' => 'Building',
            'snag_date' => 'Snag Date',
            'time_in' => 'Time In',
            'time_out' => 'Time Out',
            'technician_id' => 'Technician',
            'observation' => 'Observation',
            'charges' => 'Charges',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('building_id', $this->building_id);
        $criteria->compare('snag_date', $this->snag_date, true);
        $criteria->compare('time_in', $this->time_in, true);
        $criteria->compare('time_out', $this->time_out, true);
        $criteria->compare('technician_id', $this->technician_id);
        $criteria->compare('observation', $this->observation, true);
        $criteria->compare('charges', $this->charges, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmSnag the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
