<?php

/**
 * This is the model class for table "{{fm_service_planned}}".
 *
 * The followings are the available columns in table '{{fm_service_planned}}':
 * @property integer $id
 * @property integer $contract_id
 * @property string $planned_date
 * @property string $remark
 * @property string $is_converted
 */
class FmServicePlanned extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_service_planned}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('contract_id, planned_date, remark, is_converted', 'required'),
            array('contract_id', 'numerical', 'integerOnly' => true),
            array('is_converted', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, contract_id, planned_date, remark, is_converted', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'contract_id' => 'Contract',
            'planned_date' => 'Planned Date',
            'remark' => 'Remark',
            'is_converted' => 'Is Converted',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('contract_id', $this->contract_id);
        $criteria->compare('planned_date', $this->planned_date, true);
        $criteria->compare('remark', $this->remark, true);
        $criteria->compare('is_converted', $this->is_converted, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmServicePlanned the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function updatePlannedDate($model) {
        //$model = new FmServiceContract();
        $condition = "contract_id ='" . $model->id . "' ";
        FmServicePlanned::model()->deleteAll(["condition" => $condition]);
        $start_date = new DateTime($model->contract_start_date);
        $end_date = new DateTime($model->contract_end_date);
        $interval = $start_date->diff($end_date);
        $days_difference_from_start_end = $interval->days;

        /* @var $service_frequency_in_days int for weekly 7 d, monthly 30 */
        $service_frequency_in_days = $model->frequency_rel->days;

        $number_of_service_cycle = self::findServiceCycle($days_difference_from_start_end, $service_frequency_in_days);
        for ($index = 0; $index < $number_of_service_cycle; $index++) {
            $plannedModel = new FmServicePlanned();
            $plannedModel->is_converted = "N";
            $plannedModel->planned_date = $start_date->format("Y-m-d");
            $plannedModel->remark = "";
            $plannedModel->contract_id = $model->id;
            $plannedModel->save();
            $start_date->modify(" + $service_frequency_in_days days");
        }
    }

    /**
     * @return int
     */
    public static function findServiceCycle($total_days, $one_service_period) {
        $cycle = 0;
        if (empty($cycle)) {
            $rem = $total_days % $one_service_period;
            $cycle = (int) ($total_days / $one_service_period);
            $rem_percentage = $rem / $one_service_period;
            // default rounding is not used because
            // 0.50 threshold may changed in future;
            if ($rem_percentage > 0.25) {
                $cycle++;
            }
        }
        return $cycle;
    }

}
