<?php

/**
 * This is the model class for table "{{fm_service_contract_machine}}".
 *
 * The followings are the available columns in table '{{fm_service_contract_machine}}':
 * @property integer $id
 * @property integer $contract_id
 * @property integer $machine_id
 */
class FmServiceContractMachine extends CActiveRecord {

    public $machine_name;
    public $machine_no;
    public $machine_serial_no;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_service_contract_machine}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('contract_id, machine_id', 'required'),
            array('contract_id, machine_id', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, contract_id, machine_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'contract_rel' => array(self::BELONGS_TO, 'FmServiceContract', 'contract_id'),
            'machine_rel' => array(self::BELONGS_TO, 'Machinery', 'machine_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'contract_id' => 'Contract',
            'machine_id' => 'Machine',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('contract_id', $this->contract_id);
        $criteria->compare('machine_id', $this->machine_id);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmServiceContractMachine the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
