<?php

/**
 * This is the model class for table "{{fm_service_contract}}".
 *
 * The followings are the available columns in table '{{fm_service_contract}}':
 * @property integer $id
 * @property string $contract_start_date
 * @property string $contract_end_date
 * @property string $created_date_time
 * @property integer $created_by
 * @property integer $contract_type
 * @property integer $contract_amount
 * @property integer $service_frequency
 * @property integer $vendor_id
 * @property string $status
 */
class FmServiceContract extends CActiveRecord {

    public $vendor_name;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_service_contract}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('contract_start_date, contract_end_date, created_date_time, created_by, contract_type, contract_amount, service_frequency, vendor_id, status', 'required'),
            array('created_by, contract_type, contract_amount, service_frequency, vendor_id, update_by', 'numerical', 'integerOnly' => true),
            array('status', 'length', 'max' => 1),
            array('updated_date_time,created_date_time', 'length', 'max' => 60),
            array('contract_end_date', 'validatecontractdate'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, contract_start_date, contract_end_date, created_date_time, created_by, contract_type, contract_amount, service_frequency, vendor_id, status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'vendor_rel' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
            'frequency_rel' => array(self::BELONGS_TO, 'FmMasFrequency', 'service_frequency'),
            'type_rel' => array(self::BELONGS_TO, 'MasterPeriodType', 'contract_type'),
            'planned_rel' => array(self::HAS_MANY, 'FmServicePlanned', 'contract_id'),
            'machine_rel' => array(self::HAS_MANY, 'FmServiceContractMachine', 'contract_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'contract_start_date' => 'Contract Start Date',
            'contract_end_date' => 'Contract End Date',
            'created_date_time' => 'Created Date Time',
            'created_by' => 'Created By',
            'contract_type' => 'Contract Type',
            'contract_amount' => 'Contract Amount',
            'service_frequency' => 'Service Frequency',
            'vendor_id' => 'Vendor',
            'status' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('contract_start_date', $this->contract_start_date, true);
        $criteria->compare('contract_end_date', $this->contract_end_date, true);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('contract_type', $this->contract_type);
        $criteria->compare('contract_amount', $this->contract_amount);
        $criteria->compare('service_frequency', $this->service_frequency);
        $criteria->compare('vendor_id', $this->vendor_id);
        $criteria->compare('status', $this->status, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmServiceContract the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function validatecontractdate($attribute, $params) {
        $start = strtotime($this->contract_start_date);
        $end = strtotime($this->contract_end_date);
        if ($start >= $end) {
            $this->addError('contract_end_date', "Contract end date must be greater than start date.");
        }

        if (!empty($this->service_frequency)) {
            $date1 = new DateTime($this->contract_start_date);
            $date2 = new DateTime($this->contract_end_date);
            $interval = $date1->diff($date2);
            $days_difference = $interval->days;
            if ($days_difference < 31) {
                $this->addError('contract_end_date', "Contract period must be 1 month long.");
            }
        }
    }

}
