<?php



class TechnicianController extends Controller {



    public function accessRules() {



        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'), //,'UploadItemsFromDummy'

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable', 'Documentupload', 'GetDocumentList', 'SaveTechnician', 'DeleteDocument', 'UploadDocuments', 'downloaddocument'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users$model

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        $this->render('index');

    }



    public function actionGetList() {

        $model = new Technician();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'technician_name',

            2 => 'mobile_no',

            3 => 'remarks',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = 't.is_active="N"';

            $condition = "(technician_name LIKE '%" . $searchString . "%' OR mobile_no LIKE '%" . $searchString . "%' OR technician_type_det.technician_type LIKE '%" . $searchString . "%' )";

        } else {

            $condition = 't.is_active= "Y"';

        }

        $count = $model->with('technician_type_det')->count(array('condition' => $condition));

        $model = $model->with('technician_type_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {





            $rowData[] = array($m,

                $row['technician_name'],

               // $row['technician_type_det']['technician_type'],

                $row['mobile_no'],

                $row['remarks'],

                array('id' => $row['id'], 'code' => $row['technician_name'], 'status' => $row->is_active),);

            $m++;

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionCreate() {

        $model = new Technician();

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = $model->findByPk($id);

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, 'jquery-2.1.4.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('technician_form', array('model' => $model), false, false);

    }



    public function actionDisable() {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        $model = new Technician();

        $model = $model->findByPk($id);

        $model->is_active = ($status == "Y" ) ? "N" : "Y";

        $model->save();

        echo json_encode(array("status" => "success"));

    }



    public function actionDocumentupload() {

        $type_id = Yii::app()->request->getparam("type_id");

        $modelDocument = FmDocuments::model()->find(array('condition' => 'type_id = "' . $type_id . '" AND document_type="TECHNICIAN"'));

        if (empty($modelDocument)) {

            $modelDocument = new FmDocuments();

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'type_id' => $type_id), false, true);

    }



    public function actionGetDocumentList() {



        $model = new FmDocuments();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.type_id',

            1 => 't.document_name',

            2 => 't.created_by',

            3 => 't.created_datetime',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.type_id > 0 AND t.document_type="TECHNICIAN" and t.type_id = "' . $_POST['type_id'] . '"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (document_name LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $button_string = "";

            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));

            // if (isset(Yii::app()->user->havePermissionOn['allow_delete_document'])) {

            $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteTechnicianDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';

            //}

            $button_string .= ' <a href ="' . Yii::app()->createUrl('fm/technician/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';

            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:i:s", strtotime($row['created_date_time'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');

        }

        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionSaveTechnician() {



        $model = new Technician;

        $other = array();



        if (isset($_POST['Technician'])) {

            $model->created_by = Yii::app()->user->id;

            $model->created_date_time = date("Y-m-d H:i:s");

            if ((int) $_POST['Technician']['id'] > 0) {

                $model = $model->findByPK($_POST['Technician']['id']);

                $model->updated_by = Yii::app()->user->id;

                $model->updated_date_time = date("Y-m-d H:i:s");

            }

            $model->attributes = $_POST['Technician'];

            $model->technician_name = trim($_POST['Technician']['technician_name']);

            $model->mobile_no = trim($_POST['Technician']['mobile_no']);

           

            $valid = $model->validate();

        }



        if ($valid) {

            $model->save(false);





            if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {

                $modelDocument = new FmDocuments;

                $modelDocument->document_type = "TECHNICIAN";

                $modelDocument->type_id = $model->id;

                $modelDocument->created_by = Yii::app()->user->id;

                $modelDocument->created_date_time = date('Y-m-d H:i:s');

                $modelDocument->document_name = $_POST['FmDocuments']['document_name'];

                $modelDocument->file_name = $_POST['Icon']['file'];

                $modelDocument->save(false);

            }







            $jsonData['Technician'] = $model;

            $jsonData['id'] = $model->id;

            $jsonData['status'] = 'success';



            echo CJSON::encode($jsonData);

        } else {





            $error1 = json_decode(CActiveForm::validate($model, '', false), true);

//                

            $error = CJSON::encode(array_merge_recursive($error1, $other));



            if ($error != '[]')

                echo $error;

        }

    }



    public function actionDeleteDocument() {

        $id = $_POST['id'];

        $modelDocument = new FmDocuments();

        $model_doc = FmDocuments::model()->findbyPK($id);

        $document_details = explode(',', $model_doc->file_name);

        foreach ($document_details as $value) {

            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;

            unlink($path);

        }

        $modelDocument->deleteByPk($id);

        echo "success";

    }



    public function actiondownloaddocument() {

        $id = (int) Yii::app()->request->getParam('id');

        $arr_technician_doc = FmDocuments::model()->findByPk($id);

        $file = $arr_technician_doc->file_name;

        $arr_doc_val = explode(',', $arr_technician_doc->file_name);

        if (count($arr_doc_val) > 1) {

            $zip = new ZipArchive();

            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_technician_doc->file_name . "_" . date('d-m-Y') . ".zip";

            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {

                for ($i = 0; $i < count($arr_doc_val); $i++) {

                    $path = "images/attachment/" . $arr_doc_val[$i];

                    // Add the files to the .zip file

                    $zip->addFile($path, $arr_doc_val[$i]);

                }

                // Closing the zip file

                $zip->close();

            }

            header("Content-type:application/zip"); //for pdf file

            //if you want to read text file using text/plain header

            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');

            header('Content-Length: ' . filesize($zip_file_path));

            readfile($zip_file_path);

            Yii::app()->end();

        } else {

            $file = $arr_technician_doc->file_name;

            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;

            header("Content-type:application/octet-stream"); //for txt file

            header("Content-Type: application/download");

            //header('Content-Type:text/plain; charset=ISO-8859-15');

            //if you want to read text file using text/plain header

            header('Content-Disposition: attachment; filename="' . basename($path) . '"');

            header('Content-Length: ' . filesize($path));

            readfile($path);

            Yii::app()->end();

        }

    }



}

