<?php



class ScheduledController extends Controller {



    public $title = "Scheduled Maintenance List";



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('index', 'GetList'

                ),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function actionIndex() {

        $this->render('index');

    }



    public function actionGetList() {

        $model = new FmPlannedSchedule();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.planned_date',

            1 => 'name',

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = 'planned_date asc';

        $condition = '1=1 ';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (planned_date LIKE '%".$searchString."%')";
            

        }

        if (isset($_POST['converted_id']) && $_POST['converted_id'] != "") {

            $converted_id = trim($_POST['converted_id']);

            $condition .= " AND (t.is_converted = '$converted_id' )";

        }

        if (isset($_POST['to_date']) && !empty($_POST['to_date'])) {

            $to_date = DateModel::toSqlDate($_POST['to_date']);

            $condition .= " AND t.planned_date >= '$to_date' ";

        }

        if (isset($_POST['from_date']) && !empty($_POST['from_date'])) {

            $from_date = DateModel::toSqlDate($_POST['from_date']);

            $condition .= " AND t.planned_date <= '$from_date' ";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $unit_name = $row->header->unit_rel->unit_name . " - " . $row->header->building_rel->building_name;

            $param = ["id" => $row->id,

                'header_id' => $row->header_id,

                'ticket_id' => $row->ticket_id,

                "is_converted" => $row->is_converted];

            $is_converted = ($row->is_converted == "Y") ? "Yes (JOB ID#:" . $row->ticket_id . ")" : "No";

            $rowData[] = array($m,

                $row->header_id,

                date("d/m/Y", strtotime($row->planned_date)),

                $unit_name,

                $row->header->type_rel->period_type,

                $row->header->frequency_rel->name,

                $is_converted,

                $param,

            );

            $m++;

        }

        $data['data'] = $rowData;

        $data['cond'] = $condition;

        echo json_encode($data);

    }



}

