<?php

class PlannedmaintenanceController extends Controller
{

    public $title = "Planned Maintenance";

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'index', 'Create', 'Save', 'GetList', 'Generateschedule',
                    'deleteplanned', 'print', 'GetContractJobList', 'GetContractIssueList', 'GetContractInvoiceList','GetContractPurchaseInvoiceList'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {

        $this->render('index', array());
    }

    public function actionCreate()
    {
        $model = new FmPlannedMaintenance();
        $id = (int) Yii::app()->request->getParam('id');
        $view_frm = Yii::app()->request->getParam('view');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->contract_start_date = date("d/m/Y", strtotime($model->contract_start_date));
            $model->contract_end_date = date("d/m/Y", strtotime($model->contract_end_date));
        } else {
            $model->contract_start_date = date("d/m/Y");
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('create', array('model' => $model,'view_frm'=>$view_frm), false, true);
    }

    public function actionSave()
    {
        $model = new FmPlannedMaintenance();
        $machineList = [];
        $plannedList = [];
        $other_error = [];
        if ((int) @$_POST['FmPlannedMaintenance']['id'] > 0) {
            $id = (int) @$_POST['FmPlannedMaintenance']['id'];
            $model = $model->findByPk($id);
        } else {
            $model->created_date_time = date("Y-m-d H:i");
            $model->created_by = Yii::app()->user->id;
        }
        $model->updated_date_time = date("Y-m-d H:i");
        $model->update_by = Yii::app()->user->id;

        $model->attributes = $_POST['FmPlannedMaintenance'];
        $model->contract_amount = $_POST['FmPlannedMaintenance']['contract_amount'];
        $model->customer_id = $_POST['FmPlannedMaintenance']['customer_id'];
        $model->project_classification_id = $_POST['FmPlannedMaintenance']['project_classification_id'];

        $model->contract_start_date = DateModel::toSqlDate($_POST['FmPlannedMaintenance']['contract_start_date']);
        $model->contract_end_date = DateModel::toSqlDate($_POST['FmPlannedMaintenance']['contract_end_date']);

        $valid = $model->validate();
        $key = 0;
        foreach ($_POST['FmPlannedSchedule'] as $value) {
            if ($value["is_converted"] != "Y") {
                $plannedList[$key] = new FmPlannedSchedule();
                if (!empty($value['id'])) {
                    $plannedList[$key] = FmPlannedSchedule::model()->findByPk($value['id']);
                }
                $plannedList[$key]->header_id = 0;
                $plannedList[$key]->attributes = $value;
                $plannedList[$key]->planned_date = DateModel::toSqlDate($value['planned_date']);
                $plannedList[$key]->remark = $value['remark'];
                $valid = $valid && $plannedList[$key]->validate();
                $planned_date = strtotime($plannedList[$key]->planned_date);
                if ((strtotime($model->contract_start_date) > $planned_date) || (strtotime($model->contract_end_date) < $planned_date)) {
                    $valid = false;
                    $other_error[] = $value['planned_date'] . " out of range of contract.";
                }
                $key++;
            }
        }
        if (empty($plannedList)) {
            $other_error[] = "Please add atleat one planned date";
            $valid = false;
        }
        if ($valid) {
            $model->save();

            foreach ($plannedList as $key => $value) {
                $value->header_id = $model->id;
                $value->save();
            }

            $jsonData['status'] = 'success';
            //$jsonData['frm'] = $_POST['Song'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error_2 = [];
            $error_1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
            if (!empty($plannedList)) {
                $error_2 = json_decode(CActiveForm::validateTabular($plannedList, '', false), true);
            }
            $error = CJSON::encode(array_merge_recursive($error_1, $error_2, $other_error));
            if ($error != '[]') {
                echo $error;
            }
        }
    }

    public function actionGenerateschedule()
    {
        $planned_services = [];

        $start_date_str = DateModel::toSqlDate($_POST['FmPlannedMaintenance']['contract_start_date']);
        $end_date_str = DateModel::toSqlDate($_POST['FmPlannedMaintenance']['contract_end_date']);

        $start_date = new DateTime($start_date_str);
        $end_date = new DateTime($end_date_str);
        $interval = $start_date->diff($end_date);
        $days_difference_from_start_end = $interval->days;
        /* @var $service_frequency_in_days int for weekly 7 d, monthly 30 */
        $service_frequency = $_POST['FmPlannedMaintenance']['service_frequency_id'];
        $frequency = FmMasFrequency::model()->findByPk($service_frequency);
        $service_frequency_in_days = $frequency->days;

        $number_of_service_cycle = FmServicePlanned::findServiceCycle($days_difference_from_start_end, $service_frequency_in_days);

        for ($index = 0; $index < $number_of_service_cycle; $index++) {
            $planned_services[$index] = new FmPlannedSchedule();
            $planned_services[$index]->planned_date = $start_date->format("Y-m-d");
            $planned_services[$index]->remark = "";
            $planned_services[$index]->header_id = 0;
            $start_date->modify(" + $service_frequency_in_days days");
        }
        if (empty($planned_services)) {
            $planned_services = [new FmServicePlanned()];
        }
        $this->renderpartial('planned_date_table', ['planned_services' => $planned_services]);
    }

    public function actionGetList()
    {
        $model = new FmPlannedMaintenance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = 't.id desc';
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR unit_rel.unit_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('unit_rel')->count(array('condition' => $condition));
        $model = $model->with('unit_rel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $unit_name = $row->unit_rel->unit_name . " - " . $row->building_rel->building_name;
            $param = [
                "id" => $row->id,
                "status" => ""
            ];
            $rowData[] = array(
                $m,
                $row->id,
                $unit_name,
                $row->type_rel->period_type,
                $row->frequency_rel->name,
                date("d/m/Y", strtotime($row->contract_start_date)),
                date("d/m/Y", strtotime($row->contract_end_date)),
                $row->getScheduledstatus(),
                $param,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteplanned()
    {
        $id = $_REQUEST['id'];

        if (!empty($id)) {
            // need to check hsitory before delete.
            // thats part no developed yet
            $model = new FmPlannedSchedule();
            $model->deleteByPk($id);
            echo json_encode(["status" => "success", 'id' => $id]);
        } else {
            // no data to delete
            echo json_encode(["status" => "success", 'id' => $id]);
        }
    }

    public function actionPrint()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('print', array('id' => $id), true));
        $mPDF1->Output("CONTRACT_$id.pdf", 'I');
    }


    public function actionGetContractJobList()
    {

        $model = new TicketHeader();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 't.id',
            2 => 'remarks',
            3 => 'ticket_date',
            4 => 'ticket_status',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';


        if ((int)$_POST['contract_id'] > 0) {

            $condition .= ' AND (t.contract_id = "' . (int)$_POST['contract_id'] . '")';
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (remarks LIKE '%" . $searchString . "%' "
                . " OR building_details.building_name LIKE '%" . $searchString . "%' OR unit_details.unit_name LIKE '%" . $searchString . "%' )";
        }



        $count = $model->with('building_details', 'unit_details')->count(array('condition' => $condition));

        $model = $model->with('building_details', 'unit_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $model_condition = $condition;
        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $ticket_date = date("d/m/Y h:i A", strtotime($row['ticket_date']));

            if ($row['raised_by'] == 1) {
                $raised = "Admin";
            } else if ($row['raised_by'] == 2) {
                $raised = "User";
            }

            if ($row['type'] == "T") {
                $machine_prop_name = $row->building_details->building_name;
                $unit_name = $row->unit_details->unit_name;
                $machine_prop_name .= " - " . $unit_name;
                $machine_prop_name .= " <span title='" . $row->priority_details->name . "' style='color:" . $row->priority_details->color_code . "' ><i class='fa fa-exclamation-circle'></i></span>";
            } else {

                $machine_prop_name = "";
            }
            $current_process_status = "";
            $status_name = $row->status_details->status_name;
            $issue_type = $row['issue_details']['issue_type'];
            if (!empty($row->master_file_id)) {
                $file = MasterFile::model()->findByPK($row->master_file_id);
                $current_process_status = $file->current_process_status;
                $status_name .= " <span class= 'status-$current_process_status badge'>$current_process_status</span";
            }
            $goods_issuse_id = "0";
            $goods_issuse_type = "GI";
            $condition = "ticket_id = $row->id ";
            $goods_issuses = InventoryGoodsIssue::model()->findAll(["condition" => $condition]);
            if (!empty($goods_issuses)) {
                $condition = "ticket_id = '$row->id' AND stock_updated='N' ";
                $goods_issuse = InventoryGoodsIssue::model()->find(["condition" => $condition]);
                if (!empty($goods_issuse)) {
                    $goods_issuse_id = $goods_issuse->id;
                }
                $issue_type .= "&nbsp;<span style='color:green' ><i class='fa fa-location-arrow' ></span>";
            }
            $view = 'N';
            if ($row->ticket_status == 3) {
                $view = 'Y';
            }
            $param = [
                "id" => $row->id,
                "status_id" => $row->ticket_status,
                "title" => $row->id,
                "color_code" => $row->status_details->color_code,
                "quotation_id" => $row->quotation_id,
                "master_file_id" => $row->master_file_id,
                "invoice_status" => $current_process_status,
                "good_issuse_id" => $goods_issuse_id,
                "good_issuse_type" => $goods_issuse_type,
                "view" => $view
            ];

            $rowData[] = array(
                $row['id'],
                $issue_type,
                $machine_prop_name,
                $row['description'],
                $ticket_date,
                $status_name,
                $row['ticket_details']['issue_priority'],
                $param,
            );

            $m++;
        }



        $data['data'] = $rowData;
        $data['condition'] = $model_condition;

        echo json_encode($data);
    }


    public function actionGetContractIssueList()
    {
        $model = new InventoryGoodsIssue();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'goods_issue_date',
            1 => 'customer_id',
            2 => 'project'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.stock_updated="Y"';
           if ((int)$_POST['contract_id'] > 0) {

            $condition .= ' AND (t.contract_id = "' . (int)$_POST['contract_id'] . '")';
        }

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR t.goods_issue_date LIKE '%" . $searchString . "%' OR t.project_id LIKE '%" . $searchString . "%')";
        }
        
        $total = Yii::app()->db->createCommand('SELECT SUM(H.rate * H.picked_qty)  AS total  FROM {{inventory_goods_issue_item}} H
        LEFT JOIN {{inventory_goods_issue}} t ON t.id = H.inventory_goods_issue_id    WHERE ' . $condition)->queryAll();


        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            
            $total_amount = Yii::app()->db->createCommand("select IFNULL(SUM(cost_price*quantity),0)  from erp_stock_ledger where transaction_from='GOODS_ISSUE'  AND (header_id ='" . $row['id'] . "')")->queryScalar();

            $date_d = date("d/m/Y", strtotime($row->goods_issue_date));
            $ticket =  ((int)$row['ticket_id'] > 0) ? 'Y' : 'N';
            $rowData[] = array($row['ticket_id'],$row['id'], $date_d, $row->customer->customer_name, $row['reference'],abs($total_amount), $row['posted'], $ticket);
            $m++;
        }
          
        $data['total'] = (float)abs( $total[0]['total']);
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionGetContractInvoiceList()
    {
           $model = new Invoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 't.order_id',
            3 => 't.invoice_date',
            4 => 'customer.customer_name',
            5 => 'leadowner.first_name',
            6 => 't.total_tax_amount',
            7 => 't.grand_total',
            8 => 't.received_cash_amount',
            9 => 't.received_card_amount',
            10 => 't.receipt_type',
            11 => 't.id',
            12 => 't.id',
            13 => 't.id',
            18 => 't.created_datetime'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy = 't.invoice_no DESC';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';

        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->level > 3) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }
        //user_level=3 means branch head. SO need to see all items in branch--added on 24/01/23 --start
        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->level == 3) {
            $condition .= ' AND (t.warehouse_id= "' . Yii::app()->user->user_warehouse_id . '")';
        }
        
        if ((int)$_POST['contract_id'] > 0) {

            $condition .= ' AND (t.contract_id = "' . (int)$_POST['contract_id'] . '")';
        }
        
        if ($_POST['invoice_date_from'] != '' && $_POST['invoice_date_to'] != '') {
            $invoice_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['invoice_date_from'])));
            $invoice_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['invoice_date_to'])));
            $condition .= ' AND (invoice_date>="' . $invoice_start_date . '" AND invoice_date<="' . $invoice_end_date . '")';
        }

        if ($_POST['invoice_type'] != '') {
            $condition .= ' AND posted="' . $_POST['invoice_type'] . '"';
        }
        if ($_POST['warehouse_id'] != '') {
            $condition .= ' AND t.warehouse_id="' . $_POST['warehouse_id'] . '"';
        }

        if ($_POST['invoice_lead_owner'] != '') {
            $condition .= ' AND t.lead_owner_id="' . $_POST['invoice_lead_owner'] . '"';
        }
        if ($_POST['invoice_payment_type'] != '') {
            $condition .= ' AND t.receipt_type="' . $_POST['invoice_payment_type'] . '"';
        }
        /*
          if (Yii::app()->user->authorised_user  != 1) {
          $warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');
          $condition .= ' AND t.warehouse_id="' . $warehouse_id . '"';

          }
         */
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' 
            OR t.custom_invoice_no LIKE '%" . $searchString . "%' 
            OR t.file_id LIKE '%" . $searchString . "%'
            OR t.order_id LIKE '%" . $searchString . "%' 
            OR invoice_status LIKE '%" . $searchString . "%')";
        }
        
        $total = Yii::app()->db->createCommand('SELECT SUM(t.grand_total- t.total_tax_amount)  AS total_amount ,SUM(t.total_tax_amount)  AS total_tax ,SUM(t.grand_total)  AS grand_total   FROM {{invoice}} t  WHERE ' . $condition)->queryAll();


        $count = $model->with('customer', 'file', 'leadowner', 'currencyname', 'warehouse')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'leadowner', 'warehouse')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            $div = '';
            $balance = 0.00;
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["invoice_print"]))) {
                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=invoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '&frm=tax"><i class="fa fa-file-pdf-o"></i></a>';
            }

            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["customer_activity"])) {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Activity" onclick="loadPopupModal(\'activity/create&customer_id=' . $row['customer']['id'] . '\',\'' . $row['customer']['id'] . ' : ' . $row['customer']['customer_name'] . ' - Activities ' . '\',\'lg\')"><i class="fa fa-certificate"></i></button>';
            }
            $creditnote = Creditnote::model()->find(array('condition' => 'invoice_id = ' . $row['id']));
            ($creditnote->id > 0) ? $cn_state = 'Yes' : $cn_state = 'No';
            //Max invoice id
            $model_max_invoice = Invoice::model()->find(array('select' => 'max(id) as id', 'condition' => 'order_id ="' . $row['order_id'] . '"'));
            $show_invoice_cancel = 'N';
            $balance = $row['grand_total'] - $row['received_amount'];
            $array_recept = array('CH' => 'Cash', 'CA' => 'Card', 'CC' => 'Card + Cash');
            if ($model_max_invoice->id == $row['id']) {
                $show_invoice_cancel = 'Y';
            }

            $rowData[] = array(
                $row['ticket_id'],
                $row['invoice_no'], 
                $row['order_id'], 
                date("d/m/Y", strtotime($row['invoice_date'])),
                $row['customer']['customer_name'], 
                 Yii::app()->numberFormatter->formatCurrency($row['grand_total']-$row['total_tax_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""),
                $row->created_user,
                '<span title="' . date('d/m/Y h:i:s', strtotime($row->created_datetime)) . '">' . date('d/m/Y h:i:s', strtotime($row->created_datetime)) . '</span>',
                $row['invoice_status'],
               
                );
        }
        
        $data['total_amount'] = (float) $total[0]['total_amount'];
        $data['total_tax'] = (float) $total[0]['total_tax'];
        $data['grand_total'] = (float) $total[0]['grand_total'];
        $data['data'] = $rowData;
        echo json_encode($data);
    }

   public function actionGetContractPurchaseInvoiceList() {
        $model = new PurchasingInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.invoice_no',
            1 => 't.po_id',
            2 => 't.id',
            3 => 't.materialreceived',
            4 => 'vendor_details.vendor_name',
            5 => 't.invoice_date',
            6 => 't.grand_total',
            7 => 't.file_id',
            8 => 't.currency_id',
            9 => 'file.current_process_status',
            10 => ''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        
        if ((int)$_POST['contract_id'] > 0) {

            $condition .= ' AND (t.contract_id = "' . (int)$_POST['contract_id'] . '")';

        }
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            //materialreceived
        //    $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%' OR  t.materialreceived LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR awb_no LIKE '%" . $searchString . "%' OR t.po_id LIKE '%" . $searchString . "%')";
       
                   $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%' 
                  
                   OR  t.materialreceived LIKE '%" . $searchString . "%' OR  
                   t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' 
                 
                   OR t.po_id LIKE '%" . $searchString . "%')";

        }
        
        $total = Yii::app()->db->createCommand('SELECT SUM(t.grand_total- t.total_tax_amount)  AS total_amount ,SUM(t.total_tax_amount)  AS total_tax ,SUM(t.grand_total)  AS grand_total   FROM {{purchasinginvoice}} t  WHERE ' . $condition)->queryAll();




        $count = $model->with('file', 'vendor_details')->count(array('condition' => $condition));
        $model = $model->with('file', 'vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            switch ($row['file']['current_process_status']) {
                case 'P_I':
                    $status = 'PI';
                    break;
                case 'M_R':
                    $status = 'MR';
                    break;
                case 'Q_C':
                    $status = 'QC';
                    break;
            }
            if ($row['is_direct_invoice'] == 'Y') {
                //Code commented by mereena on 28/02/2020
                //$row['file_id'] = '##DP';
                $row['po_id'] = '##DP';
                //$row['invoice_no'] = '##DP';
                //end
                $row['materialreceived'] = '##DP';
            }

            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_invoice_pdf"])) {
                $div .= '<a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=purchaseinvoice/PrintInvoiceReportPDF&id=' . $row['id'] . '&c_id=' . $row['crm_user_id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            }
            $debitnote = Purchasingdebitnote::model()->find(array('condition' => 'purchasing_invoice_id =' . $row['id']));
            ($debitnote->id > 0) ? $dn_status = 'Yes' : $dn_status = 'No';
            $service_invoice = 'N';
            if ($row['purchase_invoice'] == 'LC' && !empty($row['purchase_invoice_id'])) {
                $service_invoice = 'Y';
            }
            $have_landing_cost = 'N';
            $check_landing_cost = PurchasingInvoice::model()->find(array('condition' => 'purchase_invoice_id like "' . $row['id'] . '" OR purchase_invoice_id like "' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . ',%" OR purchase_invoice_id like "%,' . $row['id'] . '"'));
            if (!empty($check_landing_cost)) {
                $have_landing_cost = 'Y';
            }
            $rowData[] = array($row['ticket_id'],
            $row['po_id'],
            $row['id'],
            $row['materialreceived'],
            $row['vendor_details']['vendor_name'],
            date("d/m/Y", strtotime($row['invoice_date'])),
            $row['grand_total']-$row['total_tax_amount'],
            $row['total_tax_amount'],
            $row['grand_total'],
            $row['crmUser']['first_name'] . ' ' . $row['crmUser']['last_name'], $row['crm_user_id'],
            );
        }
        $data['total_amount'] = (float) $total[0]['total_amount'];
        $data['total_tax'] = (float) $total[0]['total_tax'];
        $data['grand_total'] = (float) $total[0]['grand_total'];
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
}
