<?php



class MasterissuetypeController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        $this->render('index');

    }



    public function actionGetList() {



        $model = new MasterIssueType();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'issue_type',

            2 => 'id',

            3 => 'color',

            4 => 'is_active'

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = 'issue_type';

        $condition = 't.is_active="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "  (issue_type LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {





            $rowData[] = array($m,

                $row['issue_type'],

                $row['id'],

                $row['color'],

                $row['is_active'],

            );



            $m++;

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionCreate() {

        $model = new MasterIssueType();

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = $model->findByPk($id);

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);



        $this->renderPartial('create', array('model' => $model), false, true);

    }



    public function actionSave() {

        $model = new MasterIssueType();

        if (isset($_POST['MasterIssueType'])) {



            if ((int) @$_POST['MasterIssueType']['id'] > 0) {

                $id = (int) @$_POST['MasterIssueType']['id'];

                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date("Y-m-d H:i:s");
                

            } else {

                //$model->id = (int) @$_POST['MasterIssueType']['id'];

                $model->created_by = Yii::app()->user->id;

                $model->created_date_time = date("Y-m-d H:i:s");

            }



            $model->attributes = $_POST['MasterIssueType'];

            $model->issue_type= ucfirst(trim($_POST['MasterIssueType']['issue_type']));

            if ($model->save()) {





                $jsonData['status'] = 'success';

                //$jsonData['frm'] = $_POST['Song'];

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);

            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }

        }

    }



    public function actionDisable() {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        $model = new MasterIssueType();

        $model = $model->findByPk($id);

        $model->is_active = ($status == "Y" ) ? "N" : "Y";

        $model->save();

        echo json_encode(array("status" => "success"));

    }



}

