<?php

class MasbuildingController extends Controller
{

        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Deletebuilding','Save','GetBuildingList','GetList', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new FmMasBuilding();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                    
                     0 =>'t.id',
                     1 =>'building_name',
                     2 =>'isActive',
                 
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (building_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div='';
                    
                    $rowData[]=array($m,
                        $row['building_name'],
              '<div class="btn-wrap text-center">'.$div.'</div>',
                        
                     
                            
                      array('id' => $row['id'],'code'=>$row['building_name'] , 'status' => $row->isActive));       
                    
                    
                    
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new FmMasBuilding(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
             Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('building_form', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $model = new FmMasBuilding();
            if (isset($_POST['FmMasBuilding']))
            {   
            
            if ((int) @$_POST['FmMasBuilding']['id'] > 0)
                {   
                    $id= (int) @$_POST['FmMasBuilding']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                    $model->scenario ='edit';
                    $edit_flag=1;
                }else{
                    $audit_type = 'CREATED';
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                    $model->scenario ='add';
                }
                $model->attributes    = $_POST['FmMasBuilding'];
                $model->building_name    = ucfirst(trim($_POST['FmMasBuilding']['building_name']));
                
                $model->isActive    = 'Y';
                
                if($model->save())
                {
                                        
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'Building_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with name: - {$model->building_name}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['id'] = $model->id;
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
                       echo $error;
                }

            }
        }
    public function actionDeletebuilding()
      {
         $id = $_POST['id'];
         $jsonData=[];
         $model = new FmMasBuilding();
         $modelunit = new MasBuildingUnit();        
         $modelunit=$modelunit->find(array('condition'=>'building_id="'.$id.'" '));
         if(empty($modelunit)) {
            $model->deletebypk($id);
            $jsonData['status'] = 'success';
           
         } 
         else{
             $jsonData['status'] = 'fail';
         } 
          header('Content-Type: application/json; charset=utf-8');  
          echo CJSON::encode($jsonData);
      }
    
  
        
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new FmMasBuilding();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}