<?php

//modified by jisha on 09-11-21
class MachineryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable', 'Pushtoticket',
                    'Deletemaintenanceschedule', 'removemaintenance', 'autocomplete'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 30-04-21.
     */
    public function actionIndex() {
        $this->render('index');
    }

    /*
     * function to list all machines
     * modified by jisha on 30-04-21.
     */

    public function actionGetList() {
        $model = new Machinery();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.machine_name',
            2 => 'make',
            3 => 'model_no',
            4 => 'serial_no',
            5 => 'year_of_manufacture',
            6 => 'location',
            7 => 't.machine_id',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];
            $condition = "t.machine_name LIKE '%" . $searchString .
                    "%' OR make LIKE '%" . $searchString . "%' OR model_no LIKE '%" . $searchString .
                    "%'OR serial_no LIKE '%" . $searchString . "%' OR year_of_manufacture LIKE '%" . $searchString . "%' OR location LIKE '%" . $searchString . "%' OR machine_id LIKE '%" . $searchString . "%' ";
        } else {
            $condition = 't.is_active= "Y"';
        }
        //$count          = $model->with('cust_det')->count(array('condition' => $condition));
        //$model          = $model->with('cust_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $rowData[] = array($m,
                $row['machine_id'],
                $row['machine_name'],
                $row['make'],
                $row['model_no'],
                $row['serial_no'],
                $row['year_of_manufacture'],
                $row['location'],
                array('id' => $row['id'], 'code' => $row['machine_name'], 'status' => $row->is_active, 'type' => $row->type),);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create machines details
     * modified by jisha on 30-04-21.
     */

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Machinery();

        $modelDetails = array(new MachineMaintenanceSchedules());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $condition = 'machinery_id = "' . $id . '" ';
            $modelDetails = MachineMaintenanceSchedules::model()->findAll(array('condition' => $condition));

            if (empty($modelDetails)) {
                $modelDetails = array(new MachineMaintenanceSchedules());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, 'jquery-2.1.4.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'modelDetails' => $modelDetails), false, false);
    }

    public function actionDeletemaintenanceschedule() {
        $id = $_POST['id'];
        if ($id > 0) {
            $modelDetails = MachineMaintenanceSchedules::model()->findByPk($id);
            $modelDetails->status = 'N';
            $modelDetails->save();
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionSave() {
        $model = new Machinery();
        $other = array();
        if (isset($_POST['Machinery'])) {

            if ((int) @$_POST['Machinery']['id'] > 0) {
                $id = (int) @$_POST['Machinery']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date("Y-m-d H:i:s");
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date("Y-m-d H:i:s");
            }
            $model->attributes = $_POST['Machinery'];
            $model->machine_id = trim($_POST['Machinery']['machine_id']);
            $model->machine_name = trim($_POST['Machinery']['machine_name']);
            $model->make = trim($_POST['Machinery']['make']);
            $model->model_no = trim($_POST['Machinery']['model_no']);
            $model->serial_no = trim($_POST['Machinery']['serial_no']);
            $model->year_of_manufacture = trim($_POST['Machinery']['year_of_manufacture']);
            $model->location = trim($_POST['Machinery']['location']);
            if ($_POST['Machinery']['start_date'] != '') {
                $model->start_date = str_replace('/', '-', $_POST['Machinery']['start_date']);
                $model->start_date = date("Y-m-d H:i:s", strtotime($model->start_date));
            }


            if ($_POST['Machinery']['end_date'] != '') {
                $model->end_date = str_replace('/', '-', $_POST['Machinery']['end_date']);
                $model->end_date = date("Y-m-d H:i:s", strtotime($model->end_date));
            }


            $valid = $model->validate();
            $p = 0;
            $arr_machine_scheduleids = array();
            if (is_array($_POST['MachineMaintenanceSchedules'])) {
                foreach ($_POST['MachineMaintenanceSchedules'] as $i => $item) {
                    $modelDetails[$p] = new MachineMaintenanceSchedules;
                    if ((int) $item['id'] > 0) {
                        $arr_machine_scheduleids[] = $item['id'];
                        $modelDetails[$p] = MachineMaintenanceSchedules::model()->findByPK((int) $item['id']);
                    }

                    $modelDetails[$p]->attributes = $item;
                    $modelDetails[$p]->machinery_id = 0;
                    if ($item['planned_date'] != '') {
                        $modelDetails[$p]->planned_date = str_replace('/', '-', $item['planned_date']);
                        $modelDetails[$p]->planned_date = date("Y-m-d H:i:s", strtotime($modelDetails[$p]->planned_date));
                    }
                    $modelDetails[$p]->created_by = Yii::app()->user->id;
                    $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                    $valid = $valid && $modelDetails[$p]->validate();
                    $p++;
                }
            }

            if ($valid) {
                $model->save();
                if (!empty($modelDetails)) {
                    foreach ($modelDetails as $eachModel) {
                        $eachModel->machinery_id = $model->id;
                        $eachModel->save(false);
                    }
                }
                $jsonData['status'] = 'success';
                //$jsonData['frm'] = $_POST['Song'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelDetails))
                    $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
                else
                    $error2[] = "Please add atleast one schedule";
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');

        $model = new Machinery();
        if ((int) $id > 0) {
            $model = $model->findByPk($id);
            $model->is_active = ($status == "Y" ) ? "N" : "Y";
            $model->save();
            $status = 'success';
        } else {
            $status = 'error';
        }
        echo json_encode(array("status" => $status));
    }

    public function actionPushtoticket() {

        $id = (int) Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $type = Yii::app()->request->getparam('type');
        $model = new Machinery();

        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelMacSch = new MachineMaintenanceSchedules();
            $condition = "t.push_to_ticket='N' AND machinery_id= " . $id;
            $modelMacSch = $modelMacSch->findAll(array('condition' => $condition));
            $modelTicketHeader = [];
            $valid = $model->validate();
            foreach ($modelMacSch as $key => $eachmacsch) {
                $model->type = "T";
                $modelTicketHeader[$key] = new TicketHeader();
                $modelTicketHeader[$key]->type = "MS";
                $modelTicketHeader[$key]->priority_id = FmPriority::HIGH;
                $modelTicketHeader[$key]->issue_type_id = MasterIssueType::MAINTENANCE_SCHEDULE;
                $modelTicketHeader[$key]->description = $model->machine_name . " - Machine Maintenance";
                $modelTicketHeader[$key]->property_id = $model->machine_id;
                $modelTicketHeader[$key]->ticket_date = $eachmacsch->planned_date;
                $modelTicketHeader[$key]->raised_by = Yii::app()->user->id;
                $modelTicketHeader[$key]->remarks = $eachmacsch->remarks;
                $modelTicketHeader[$key]->ticket_status = "1";
                $modelTicketHeader[$key]->created_by = Yii::app()->user->id;
                $modelTicketHeader[$key]->created_date_time = date("Y-m-d H:i:s");
                $modelTicketHeader[$key]->schedule_maintenance_id = $eachmacsch->id;
                $valid = $valid && $modelTicketHeader[$key]->validate();
                if (!$valid) {
                    break;
                }
            }

            if ($valid) {
                foreach ($modelTicketHeader as $ticket) {
                    $ticket->save();
                    MachineMaintenanceSchedules::model()->updateByPK($ticket->schedule_maintenance_id, [
                        'push_to_ticket' => 'Y',
                        'ticket_id' => $ticket->id
                    ]);
                }
                echo json_encode(["status" => "success"]);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($modelTicketHeader))
                    $error2 = json_decode(CActiveForm::validateTabular($modelTicketHeader, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        } else {
            echo json_encode(["Error" => "Error in saving"]);
        }
    }

    public function actionRemovemaintenance() {
        $id = (int) Yii::app()->request->getparam('id');
        $model = MachineMaintenanceSchedules::model()->findByPk($id);
        $error_message = [];
        if ($model->push_to_ticket == "N" && empty($model->ticket_id)) {
            $model->deleteByPk($model->id);
            echo json_encode(['status' => 'success']);
        } else {
            $error_message[] = ["Already scheduled maintenance ticket generated. You can't delete this row."];
            echo json_encode($error_message);
        }
    }

    public function actionAutocomplete() {
        $term = Yii::app()->request->getparam('term');
        $condition = "machine_name LIKE '$term%' OR  machine_id LIKE '$term%' OR  serial_no LIKE '$term%'";
        $models = Machinery::model()->findAll(["condition" => $condition,
            'select' => "id,machine_name,machine_id,serial_no ",
            "order" => "machine_name"
        ]);

        $data = [];
        foreach ($models as $value) {
            $data[] = [
                "value" => $value->id,
                "label" => $value->machine_name,
                "machine_id" => $value->machine_id,
                "serial_no" => $value->serial_no,
            ];
        }
        echo json_encode($data);
    }

}
