<?php

class FmServicePlannedController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('generateschedule'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionGenerateschedule() {
        $planned_services = [];

        $start_date_str = DateModel::toSqlDate($_POST['FmServiceContract']['contract_start_date']);
        $end_date_str = DateModel::toSqlDate($_POST['FmServiceContract']['contract_end_date']);

        $start_date = new DateTime($start_date_str);
        $end_date = new DateTime($end_date_str);
        $interval = $start_date->diff($end_date);
        $days_difference_from_start_end = $interval->days;
        /* @var $service_frequency_in_days int for weekly 7 d, monthly 30 */
        $service_frequency = $_POST['FmServiceContract']['service_frequency'];
        $frequency = FmMasFrequency::model()->findByPk($service_frequency);
        $service_frequency_in_days = $frequency->days;

        $number_of_service_cycle = FmServicePlanned::findServiceCycle($days_difference_from_start_end, $service_frequency_in_days);
        for ($index = 0; $index < $number_of_service_cycle; $index++) {
            $planned_services[$index] = new FmServicePlanned();
            $planned_services[$index]->is_converted = "N";
            $planned_services[$index]->planned_date = $start_date->format("Y-m-d");
            $planned_services[$index]->remark = "auto generated";
            $planned_services[$index]->contract_id = 0;
            $start_date->modify(" + $service_frequency_in_days days");
        }
        if (empty($planned_services)) {
            $planned_services = [new FmServicePlanned()];
        }
        $this->renderpartial('application.modules.fm.views.servicecontract.planned_date_table', ['planned_services' => $planned_services]);
    }

}
