<?php

class DropdownController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('ticketbuildingunit', 'plannedbuildingunit'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionTicketBuildingunit() {
        $building_id = $_REQUEST["building_id"];
        $model = new TicketHeader();
        $list = MasBuildingUnit::getUnit($building_id);
        $ddl = CHtml::activeDropDownList($model, 'unit_id', $list, array('data-label' => 'Unit <span style="color:red">*</span>', 'data-search' => true,'onchange' => 'getCustName(this.value)'));
        echo $ddl;
    }

    public function actionPlannedBuildingunit() {
        $building_id = $_REQUEST["building_id"];
        $model = new FmPlannedMaintenance();
        $list = MasBuildingUnit::getUnit($building_id);
        $ddl = CHtml::activeDropDownList($model, 'unit_id', $list, array('data-label' => 'Unit <span style="color:red">*</span>', 'data-search' => true));
        echo $ddl;
    }

}
