<?php

class ApimaterialController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'Requestmaterial'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $token = trim($_SERVER['HTTP_TOKEN']);
            $user_array = explode(".", $token);
            if (isset($user_array[0])) {
                $user_id = $user_array[0];
                $user = new User();
                $user = $user->findBytoken($token);
                if ($user != null && $user->isActive === "Y") {
                    $valid_user = true;
                }
            }
        }
        if ($valid_user) {
            $this->ChangeDB();
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionRequestmaterial() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $ticket_id = (int) $variables["ticket_id"];
        $items = $variables["items"];
        $modelRequestDetails = [];
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        $valid = true;
        foreach ($items as $p => $item) {
            $modelRequestDetails[$p] = new TicketRequestMaterials();
            $modelRequestDetails[$p]->created_by = $user->id;
            $modelRequestDetails[$p]->created_date_time = date("Y-m-d H:i:s");
            $modelRequestDetails[$p]->attributes = $item;
            $modelRequestDetails[$p]->ticket_id = $ticket_id;
            $modelRequestDetails[$p]->ticket_item_id = 0;
            $modelRequestDetails[$p]->description = $item['description'];
            $modelRequestDetails[$p]->quantity = $item['quantity'];
            $modelRequestDetails[$p]->unit_id = $item['unit_id'];
            $unit_model = Unit::model()->findByPk((int) $item['unit_id']);
            $modelRequestDetails[$p]->unit_name = $unit_model->unit_name;
            $modelRequestDetails[$p]->updated_by = $user->id;
            $modelRequestDetails[$p]->updated_date_time = date("Y-m-d H:i:s");
            $valid = $valid && $modelRequestDetails[$p]->validate();
        }
        if ($valid) {
            foreach ($modelRequestDetails as $value) {
                $value->save();
            }
            echo json_encode(["status" => "success", "message" => ""]);
        } else {
            $error = json_decode(CActiveForm::validateTabular($modelRequestDetails, '', false), true);
            echo json_encode(["status" => "error", "error_log" => $error]);
        }
    }

}
