<?php

class ApimasterController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'UnitList', 'BuildingList', 'TechnicianList', 'PeriodType',
                    'IssueType', 'priority', 'uom'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $this->ChangeDB();
            $token = trim($_SERVER['HTTP_TOKEN']);
            $appAuthentication = new AppAuthentication($token);
            $valid_user = $appAuthentication->login();
        }
        if ($valid_user) {
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionUnitlist() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $customer_model = new Customer();
        $customer_model = $customer_model->findBytoken($token);
        $condition = ' isActive="Y" ';
        if (!empty($customer_model)) {
            $condition .= " AND t.customer_id = " . $customer_model->id;
        }
        $building_id = isset($variables["building_id"]) ? $variables["building_id"] : "0";
        if (!empty($building_id)) {
            $condition .= " AND t.building_id = $building_id ";
        } else {
            $condition .= " AND t.building_id = 0 ";
        }
        $unit = MasBuildingUnit::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
        if (!empty($unit)) {
            foreach ($unit as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "unit" => $each->unit_name,
                    "building" => $each->building->building_name
                ];
            }
        }
        $data = array('status' => "success", 'data' => $data, "message" => "");
        echo json_encode($data);
    }

    public function actionBuildingList() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $customer_model = new Customer();
        $customer_model = $customer_model->findBytoken($token);
        $condition = " isActive='Y' ";
        if (!empty($customer_model)) {
            $condition .= " AND units_rel.customer_id = " . $customer_model->id;
        }
        $data = [];
        $unit = new FmMasBuilding();
        $unit = $unit->with('units_rel')->findAll(array('condition' => $condition));
        if (!empty($unit)) {
            foreach ($unit as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "building" => $each->building_name
                ];
            }
        }

        $data = array('status' => "success", 'data' => $data, "message" => "");
        echo json_encode($data);
    }

    public function actionTechnicianList() {

        $technician = Technician::model()->findAll(array('condition' => 'is_active="Y"'));
        if (!empty($technician)) {
            foreach ($technician as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "technician" => $each->technician_name
                ];
            }
        }
        $dataJson = array('status' => "success", 'data' => $data, "messsage" => "");
        echo json_encode($dataJson);
    }

    public function actionIssueType() {

        $data = [];
        $issue = MasterIssueType::model()->findAll(array('condition' => 'is_active="Y"'));
        foreach ($issue as $i => $each) {
            $data[] = [
                "id" => $each->id,
                "issue_type" => $each->issue_type,
            ];
        }
        $dataJson = array('status' => "success", 'data' => $data, "messsage" => "");
        echo json_encode($dataJson);
    }

    public function actionPeriodType() {
        $period = MasterPeriodType::model()->findAll(array('condition' => 'is_active="Y"'));
        if (!empty($period)) {
            foreach ($period as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "period" => $each->period_type,
                ];
            }
        }
        $dataJson = array('status' => "success", 'data' => $data, "msg" => " ");
        echo json_encode($dataJson);
    }

    public function actionPriority() {
        $period = FmPriority::model()->findAll(array('condition' => 'isActive="Y"'));
        if (!empty($period)) {
            foreach ($period as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "name" => $each->name,
                    "color_code" => $each->color_code,
                ];
            }
        }
        $dataJson = array('status' => "success", 'data' => $data, "message" => " ");
        echo json_encode($dataJson);
    }

    public function actionUom() {
        $units = Unit::model()->findAll(['condition' => 'isActive="Y"']);
        foreach ($units as $i => $each) {
            $data[] = [
                "id" => $each->id,
                "name" => $each->unit_name,
                "symbol" => $each->symbol,
            ];
        }

        $dataJson = array('status' => "success", 'data' => $data, "message" => " ");
        echo json_encode($dataJson);
    }

}
