<?php

class ApiloginController extends Controller {


    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login',
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
   
    
    public function connectMainDB($company_db_name) {
        Yii::app()->db->setActive(false);
        if (empty($company_db_name)) {
            $company_db_name = '=blskysoftware_erp_fm_main';
        }
        Yii::app()->db->connectionString = 'mysql:host=e-sell.me;dbname=blskysoftware_erp_fm_main';
        Yii::app()->db->username = 'blskysoftware_erpfm';
        Yii::app()->db->password = 'lrKMxSj&Jelk';
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
    public function beforeAction($action) {
        $company_db_name = "blskysoftware_erp_fm";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return true;
    }
    public function actionLogin() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $code = trim($variables['code']);
        $username = trim($variables['username']);
        $password = trim($variables['password']);
        $model = new LoginForm;
        $model->company_code = $code;
        $model->username = $username;
        $model->password = $password;
        $isLogin = $model->validate() && $model->login();
        $user_id = "";
        $name = "";
        $user = new User();
        if ($isLogin) {
            $condition = "t.username = '" . $username . "' ";
            $user = User::model()->find(array('condition' => $condition));
            $user->_generate_token;
            $user_id = $user->id;
            $name = $user->fullname;
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            $data = array('status' => "success", "data" => ["user_id" => $user_id, "name" => $name,"_token"=>$user->token]);            
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data['status'] = 'failed';
            $data['msg'] = 'Unauthorized user';
        }
        
        echo json_encode($data);
    }
}