<?php

/**
 * Booking Module
 * Author  : Jisha
 * Created :  03/12/2021
 */
class ApiController extends Controller {

    
    public $round_off = '2';

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login','TicketList','TicketSave','PropertyList','IssuesList','Documentupload','TicketsSave','ALottedJobList','GetUnits','StartJobList','StopJobList',
                    'TechnicianList','StartedJobList','StartJobSave','StoppedJobList','StopJobSave','RequestMaterialList','Requestmaterialsave','UnitList'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function format_currency($value) {
        return number_format(round((float) $value, $this->round_off), $this->round_off, '.', '');
    }

    public function convert_date($date = null) {

        $date_converted = date('Y-m-d');

        if ($date != null) {
            //yyyy-mm-dd
            $arr_date = explode('-', $date);
            //mm/dd/yyyy
            if (checkdate($arr_date[1], $arr_date[2], $arr_date[0])) {
                $date_converted = date('Y-m-d', strtotime(str_replace('/', '-', $date)));
            }
        }
        return $date_converted;
    }

    
    public function connectMainDB($company_db_name) {
        Yii::app()->db->setActive(false);
        if (empty($company_db_name)) {
            $company_db_name = '=blskypro_erp_2021_keyhost_main';
        }
        Yii::app()->db->connectionString = 'mysql:host=e-sell.me;dbname=blskypro_erp_2021_keyhost_main';
        Yii::app()->db->username = 'blskypro_keyhost';
        Yii::app()->db->password = '05F$2.lQD(wN';
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
    public function beforeAction($action) {
        $company_db_name = "blskypro_erp_2021_keyhost";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return true;
    }
    public function actionLogin() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $code = trim($variables['code']);
        $username = trim($variables['username']);
        $password = trim($variables['password']);
        $model = new LoginForm;
        $model->company_code = $code;
        $model->username = $username;
        $model->password = $password;
        $isLogin = $model->validate() && $model->login();
        $user_id = "";
        $name = "";
        $user = new User();
        if ($isLogin) {
            $condition = "t.username = '" . $username . "' ";
            $user = User::model()->find(array('condition' => $condition));
            $user->_generate_token;
            $user_id = $user->id;
            $name = $user->fullname;
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            $data = array('status' => "success", "data" => ["user_id" => $user_id, "name" => $name,"_token"=>$user->token]);            
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data['status'] = 'failed';
            $data['msg'] = 'Unauthorized user';
        }
        
        echo json_encode($data);
    }
    
    public function actionTechnicianList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        /*if ($userModel->id > 0) 
        {*/
            $model = new Technician();
            $condition = 't.is_active= "Y"';
            $model = $model->findAll(array('condition' => $condition, 'limit' => 100));
            foreach ($model as $row) {
                $data[] = [
                    "technician_id" => $row['id'],
                    "technician_name" => $row['technician_name']
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        /*}else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        echo json_encode($data);
    }
    
    public function actionTicketList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $from_date = "2021-12-01";
        $to_date = "2021-12-31";
        if ($userModel->id > 0) 
        {
            $model = new TicketHeader();
            $model = $model->with()->findAll(array('condition' => '	ticket_status != 4  AND ticket_date >= "' . $from_date . '" AND ticket_date <= "' . $to_date . '"'));
            foreach ($model as $i => $row) 
            {
                if($row['property_details']['property_name'] == "")
                {
                    $modelMachinery = Machinery::model()->find(array('condition' => 'machine_id = "' . $row['property_id'] . '"'));
                    $machine_prop_name = $modelMachinery->machine_name;
                }
                else 
                {
                    $machine_prop_name = $row['property_details']['property_name'];
                }
                $data[] = [
                    "id" => $row['id'],
                    "type" => $row['type'],
                    "unit_name" => $machine_prop_name,
                    "remaks" => $row['remarks'],
                    "ticket_date" => date('d/m/Y',strtotime($row['ticket_date'])),
                    "ticket_status" => $row['ticket_status'],
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
     public function actionGetUnits(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        
        if ($userModel->id > 0) 
        {
            $items = Unit::model()->findAll(array('condition' => 'isActive="Y"'));
            foreach ($items as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "unit" => $each->unit_name
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            
            
        }else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    public function actionStartJobList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        /*if ($userModel->id > 0) 
        {*/
            $data_array = json_decode(file_get_contents('php://input'), true);
            $ticket_id =(int)$data_array['ticket_id'];
            $ticket_item_id =(int)$data_array['ticket_item_id'];
            $condition = 'ticket_id="' . $ticket_id . '" AND ticket_item_id ="' . $ticket_item_id . '" AND status ="IN"';
        
            $modelTicketJobTime = TicketJobTime::model()->with('technician_det')->findAll(array('condition' => $condition));
          
            if(!empty($modelTicketJobTime)){
                foreach ($modelTicketJobTime as $i => $each)
                {
                    $data['items'][]= [
                            "technician_id" => $each['technician_id'],
                            "technician_name" => $each['technician_det']['technician_name'],
                            "job_start_time"  => $each['job_start_time'],
                    ];
                }
                $data['status'] = 'success';
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
            }else{
                $data = array('status' => "success", "msg"=>"No One Started Job","items"=>[]); 
            }
        /*}else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        echo json_encode($data);
    }
    public function actionStopJobList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $ticket_id =(int)$_REQUEST['ticket_id'];
            $ticket_item_id =(int)$_REQUEST['ticket_item_id'];
            $condition = 'ticket_id="' . $ticket_id . '" AND ticket_item_id ="' . $ticket_item_id . '" AND status ="IN"';
        
            $modelTicketJobTime = TicketJobTime::model()->with('technician_det')->findAll(array('condition' => $condition));
          
            if(!empty($modelTicketJobTime)){
                foreach ($modelTicketJobTime as $i => $each)
                {
                    $data['items'][]= [
                            "technician_id" => $each['technician_id'],
                            "technician_name" => $each['technician_det']['technician_name'],
                            "job_end_time"  => $each['job_end_time'],
                    ];
                }
                $data['status'] = 'success';
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
            }else{
                $data = array('status' => "success", "msg"=>"No One in Job","items"=>[]); 
            }
        }else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    public function actionALottedJobList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $from_date = "2021-12-01";
        $to_date = "2021-12-31";
        if ($userModel->id > 0) 
        {
            $modelTechnicianalot = new TicketAllotTechnicians;
            $condition = 't.from_time >= "' . $from_date . '" AND t.from_time <= "' . $to_date . '" ';
            $modelTechnicianalot = $modelTechnicianalot->with('technician_details', 'issue_details','ticket_details')->findAll(array('condition' => $condition));
            
            foreach ($modelTechnicianalot as $i => $row) 
            {
                $data[] = [
                    "id" => $row['id'],
                    "ticket_id" => $row['ticket_id'],
                    "ticket_item_id" => $row['ticket_item_id'],
                    "issue_remarks" => $row['issue_remarks'],
                    "issue_id" =>  $row['issue_details']['id'],
                    "technician_id" => $row['technician_details']['id'],
                    "issue_name" =>  $row['issue_details']['issue_type'],
                    "technician_name" => $row['technician_details']['technician_name'],
                    "allotted_date" => date('d/m/Y',strtotime($row['allotted_date'])),
                    "from_time" => date('d/m/Y',strtotime($row['from_time'])),
                    "to_time" => date('d/m/Y',strtotime($row['to_time'])),
                    "remarks" => $row['remarks'],
                    "status" => $row['status'],
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    
    public function actionPropertyList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $model_prop = new Properties();
            $model_prop = $model_prop->with()->findAll(array('condition' => 'is_active ="Y"'));
            foreach ($model_prop as $i => $row) {
                $data[] = [
                    "id" => $row['id'],
                    "flat_no" => $row['flat_no'],
                    "apartment_name" => $row['apartment_name'],
                    "property_name" => $row['property_name'],
                    "title_deed" => $row['title_deed'],
                    "real_owner" => $row['real_owner'],
                    "no_of_beds" => $row['no_of_beds'],
                    "location" => $row['location'],
                    "makani_no" => $row['makani_no'],
                    "developer" => $row['developer'],
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    
    public function actionIssuesList(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $model_issue = new MasterIssueType();
            $model_issue = $model_issue->with()->findAll(array('condition' => 'is_active ="Y"'));
            foreach ($model_issue as $i => $row) {
                $data[] = [
                    "id" => $row['id'],
                    "issue_type" => $row['issue_type'],
                    "color" => $row['color'],
                    "is_maintenance_schedule" => $row['is_maintenance_schedule'],
                ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    
    
    
    public function actionTicketSave() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        
        $data_array = json_decode(file_get_contents('php://input'), true);
        if ($userModel->id > 0) 
        {
            $errorMessage = "";
            $input = file_get_contents('php://input');
            error_log('ticket save');
            error_log($input);
            $data_array = json_decode($input, true);
            
            $model = new TicketHeader();
            $model->type = "T";
            $model->property_id = $data_array["property_id"];
            $model->ticket_date = date("Y-m-d H:i:s");
            $model->raised_by = $data_array["raised_by"];
            $model->remarks = $data_array["remarks"];
            $model->ticket_date = date("Y-m-d H:i:s");
            $mod_his = TicketHeader::model()->find(array('order' => 'id Desc'));
            if (empty($mod_his)) 
            {
                $model->ticket_no = 1001;
            } 
            else 
            {
                $model->ticket_no = (int) $mod_his->ticket_no + 1;
            }
            $model->ticket_status = "1";
            $model->rating = $data_array["rating"];
            $model->rating_remarks = $data_array["rating_remarks"];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date("Y-m-d H:i:s");
            
            $validate = $model->validate();
            $list = $data_array["issueslist"];
            $model_details = new TicketDetails();
            foreach ($list as $p => $item)
            {
                $list[$p]->ticket_id = 0;
                $list[$p]->issue_id = $item['issue_id'];
                $list[$p]->issue_remarks = $item['description'];
                $list[$p]->issue_priority = $item['priority'];
                $list[$p]->created_by = Yii::app()->user->id;
                $list[$p]->created_date_time = date("Y-m-d H:i:s");
                $validate = $validate && $list[$p]->validate();
            }
            
            
            
            
            
            
            /*$model_details = new TicketDetails();
            foreach ($_POST['TicketDetails'] as $p => $item)
            {
                $model_details[$p]->ticket_id = 0;
                $model_details[$p]->issue_id = $item['issue_id'];
                $model_details[$p]->notes = $item['notes'];
                $model_details[$p]->issue_remarks = $item['notes'];
                $model_details[$p]->issue_priority = $item['issue_priority'];
                $model_details[$p]->created_by = Yii::app()->user->id;
                $model_details[$p]->created_date_time = date("Y-m-d H:i:s");
                $valid = $valid && $model_details[$p]->validate();
            }*/
    
    
    
            /*$list = $data_array["list"];
            $imagelist = $data_array["imageslist"];
            ///image list 
            $imageStack = [];
            foreach ($imagelist as $key => $row) {
                $imageStack[] = $row["file_name"];
            }
            if (!empty($imageStack)) {
                $job->file_name = implode(",", $imageStack);
            }
            $job->service_adviser_id = $data_array["service_adviser_id"];
            //Image list
            $items = [];
            $validate = $job->validate();
            $validate = $validate && (count($list) > 0);
            foreach ($list as $key => $row) {
                $items[$key] = new JobOrderDetails();
                $items[$key]->remarks = $row["remark"];
                $items[$key]->job_id = 0;
                $items[$key]->sl_no = $key + 1;
                $items[$key]->job_type_id = $row["type_id"];
                $items[$key]->job_sub_type_id = $row["sub_type_id"];
                $validate = $validate && $items[$key]->validate();
            }
            if ($validate) {
                $job->save();
                //saving file svg
                $file_name = "sign_{$job->id}.svg";
                $url = Yii::getPathOfAlias('webroot') . "/uploads/vehicle/{$file_name}";
                $file = fopen($url, "w");
                fwrite($file, $data_array["sign"]);
                fclose($file);
                $job->sign_svg = $file_name;
                $job->save();
                //saving and writing  Completed 
                foreach ($items as $row) {
                    $row->job_id = $job->id;
                    $row->save();
                }
            }*/
        }
        if ($validate) 
        {
            $model->save();
            /*foreach ($model_details as $eachModel) 
            {
                $eachModel->ticket_id = $model->id;
                $eachModel->save(false);
            }*/
        }
        echo json_encode([
            "id" => "0",
            "status" => $validate,
            "message" => $validate ? "" : "Error in saving",
            "error" => $model->getErrors()
        ]);
    }
    
    
    
    public function actionTicketsSave() 
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        
        $data_array = json_decode(file_get_contents('php://input'), true);
        if ($userModel->id > 0) 
        {
            $model = new TicketHeader();
            $model->type = "T";
            $model->property_id = $data_array["property_id"];
            $model->ticket_date = date("Y-m-d H:i:s");
            $model->raised_by = $data_array["raised_by"];
            $model->remarks = $data_array["remarks"];
            $model->ticket_date = date("Y-m-d H:i:s");
            $mod_his = TicketHeader::model()->find(array('order' => 'id Desc'));
            if (empty($mod_his)) 
            {
                $model->ticket_no = 1001;
            } 
            else 
            {
                $model->ticket_no = (int) $mod_his->ticket_no + 1;
            }
            $model->ticket_status = "1";
            $model->rating = $data_array["rating"];
            $model->rating_remarks = $data_array["rating_remarks"];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date("Y-m-d H:i:s");
            $validate = $model->validate();
            $model_details = new TicketDetails();
            if(!empty($model_details))
            {
                 foreach($model_details as $each)
                 {
                     if((int)$each['id']>0)
                     {
                        $modelDetails[$p] =  TicketDetails::model()->findByPK((int)$each['id']);
                     }
                     $each[$i]->ticket_id = 0;
                     $modelDetails[$p]->issue_id = $each['issue_id'];
                     $modelDetails[$p]->notes =$each['notes'];
                     $modelDetails[$p]->issue_remarks = $each['notes'];
                     $modelDetails[$p]->issue_priority = $each['issue_priority'];
                     $modelDetails[$p]->created_by = Yii::app()->user->id;
                     $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                     $validate = $validate && $modelDetails[$p]->validate();
                     if ($validate) 
                     {
                        $model->save();
                        foreach ($modelDetails as $eachModel) 
                        {
                            $eachModel->ticket_id = $model->id;
                            $eachModel->save(false);
                        }
                        $modelDocument = new FmDocuments;
                        $modelDocument->document_type = "TICKET";
                        $modelDocument->type_id = $model->id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_date_time = date('Y-m-d H:i:s');
                        $modelDocument->document_name = $_POST['FmDocuments']['document_name'];
                        $modelDocument->file_name = $_POST['Icon']['file'];
                        $modelDocument->save(false);
                     }
                 }
            }
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    
     public function actionDocumentupload($folder = null) 
     {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        
        $data_array = json_decode(file_get_contents('php://input'), true);
        if ($userModel->id > 0) 
        {   
            Yii::import("ext.EAjaxUpload.qqFileUploader");
            $field_id = "";
            if(isset($_GET['field_id']))
            {
                $field_id = Yii::app()->request->getParam('field_id');
            }
            
            $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
            // make the directory to store the pic:
            if (!is_dir($folder)) {
                mkdir($folder, 0777, TRUE);
            }
            $allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
            $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
            $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
            $result = $uploader->handleUpload($folder);
            $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
            $result['field_id'] = $field_id;
            $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
            $fileName = $result['filename']; //GETTING FILE NAME
            
            $imagename	=	Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $fileName;
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
        
    }

    public function actionStartedJobList()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $ticket_id =(int)$_REQUEST['ticket_id'];
            $ticket_item_id =(int)$_REQUEST['ticket_item_id'];
            //$ticket_id = '2';
            //$ticket_item_id = '4';
            $arr_room = "";
            if ($ticket_id > 0) 
            {
                $model  = new TicketJobTime();
                $condition = 'ticket_id ="' . $ticket_id.'" AND ticket_item_id ="' . $ticket_item_id . '" AND status ="IN"';
                $model = $model->with('technician_det')->findAll(array('condition' => $condition));
                $data =[];
                if(!empty($model))
                {
                    foreach ($model as $key => $row) 
                    {
                        $job_end_time = "";
                        if($row['job_end_time'] != "0000-00-00 00:00:00")
                        {
                            $job_end_time = date('d/m/Y h:i a',strtotime($row['job_end_time']));
                        }
                        $arr_room[$key] = [
                        "id" => $row['id'],
                        "technician_id" => $row['technician_id'],
                        "technician_name" => $row['technician_det']['technician_name'],
                        "ticket_item_id" => $row['ticket_item_id'],
                        "job_start_time" => date('d/m/Y h:i a',strtotime($row['job_start_time'])),
                        "job_end_time" => $job_end_time
                        ]; 
                    }
                }
                else 
                {
                    $arr_room = [];
                }
                $data= [
                    "started_list" => $arr_room
                    ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        //echo '<pre>'; print_r($data);
        echo json_encode($data);
    }
    
    
    public function actionStoppedJobList()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $ticket_id =(int)$_REQUEST['ticket_id'];
            $ticket_item_id =(int)$_REQUEST['ticket_item_id'];
            //$ticket_id = '4';
            $arr_room = "";
            if ($ticket_id > 0) 
            {
                $model  = new TicketJobTime();
                $condition = 'ticket_id ="' . $ticket_id.'" AND ticket_item_id ="' . $ticket_item_id . '" AND status ="OUT"';
                $model = $model->with('technician_det')->findAll(array('condition' => $condition));
                $data =[];
                if(!empty($model))
                {
                    foreach ($model as $key => $row) 
                    {
                        $job_end_time = "";
                        if($row['job_end_time'] != "0000-00-00 00:00:00")
                        {
                            $job_end_time = date('d/m/Y h:i a',strtotime($row['job_end_time']));
                        }
                        $arr_room[$key] = [
                        "id" => $row['id'],
                        "technician_id" => $row['technician_id'],
                        "technician_name" => $row['technician_det']['technician_name'],
                        "ticket_item_id" => $row['ticket_item_id'],
                        "job_start_time" => date('d/m/Y h:i a',strtotime($row['job_start_time'])),
                        "job_end_time" => $job_end_time
                        ]; 
                    }
                } 
                $data= [
                    "started_list" => $arr_room
                    ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        //echo '<pre>'; print_r($data);
        echo json_encode($data);
    }
    
    public function actionStopJobSave() 
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        /*if ($userModel->id > 0) 
        {*/
            if ((int)$data_array['ticket_id'] > 0) 
            {
                $id = (int) $data_array['ticket_id'];
                $ticket_item_id = (int)$data_array['ticket_item_id'];
                $model = $model->findByPk($id);
                $valid = $model->validate();
                
                $p=0;
                foreach ($data_array['jobtimes'] as $i => $item) 
                {
                    $modelTicketJobTime[$p] = new TicketJobTime;
                    if((int)$item['id']>0)
                    {
                        $modelTicketJobTime[$p] =  TicketJobTime::model()->findByPK((int)$item['id']);
                        $condition = 'status = "IN" and ticket_id ="' . $ticket_id.'" AND ticket_item_id ="' . $data_array['ticket_item_id']. '" AND technician_id ='.$item['technician_id'];
                        $mod_history = TicketJobTime::model()->find(array('condition'=>$condition));
                        if(!empty($mod_history))
                        {
                            $modelTicketJobTime[$p]->status = "OUT";
                            $modelTicketJobTime[$p]->job_end_time = date("Y-m-d H:i:s");
                        }
                    }
                    
                    $modelTicketJobTime[$p]->attributes = $item;
                    $modelTicketJobTime[$p]->ticket_id = $data_array['ticket_id'];
                    $modelTicketJobTime[$p]->ticket_item_id = $data_array['ticket_item_id'];
                    $modelTicketJobTime[$p]->technician_id = $item['technician_id'];
                    
                    //$modelTicketJobTime[$p]->created_by = $userModel->id;
                    $valid = $valid && $modelTicketJobTime[$p]-> validate();
                    $p++;
                    
                }
            }
                        if($valid){
                if(!empty($modelTicketJobTime)){
                    foreach ($modelTicketJobTime as $eachModel) 
                    {
                        $eachModel->save();
                    }
                }
                $data['id'] = $model->id;
                $data['status'] = 'success';

            } else {
                $data['status'] = 'error';
                $error2 = json_decode(CActiveForm::validateTabular($modelTicketJobTime, '', false), true);
                $error = array_merge_recursive($error2);
                foreach($error as $a=>$eacherror){
                    $other[]= $eacherror[0];
                }      
                if ($error != '[]')
                {
                    $data['msg'] =  $other;
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');

        /*}
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        echo json_encode($data);

    }
    
    
    public function actionStartJobSave() 
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $data_array = json_decode(file_get_contents('php://input'), true);
            //{"booking_id":"21","visitors":[{"id":"","visitor_name":"Arun","booking_id":"21","mobile_no":"73654777","email_id":"","passport_no":"8768558","address":"-","relation":"FAMILY"},{"id":"","visitor_name":"kiran","booking_id":"21","mobile_no":"076578875","email_id":"","passport_no":"85558","address":"-","relation":"FAMILY"}]}
            $user_id   = $userModel->id;
            $valid=true;
            $model = new TicketHeader;
            if ((int)$data_array['ticket_id'] > 0) {
                $ticket_id =  (int)$data_array['ticket_id'];
                $model = $model->findByPK($ticket_id);
                $valid = $model->validate();
            }
            if (is_array($data_array['jobtimes'])) 
            {
                foreach ($data_array['jobtimes'] as $p => $item) 
                {
                    $mod_history = TicketJobTime::model()->find(array('condition'=>'status="IN" AND technician_id='.(int)$item['technician_id']));
                    if(!empty($mod_history))
                    {
                        $valid=false;
                        $other[] = 'Technician '.$mod_history->technician_det->technician_name.' already started Job';
                    }
                    $modelDetails[$p] = new TicketJobTime();
                    $modelDetails[$p]->created_by = $userModel->id;
                    $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                    $modelDetails[$p]->attributes = $item;
                    $modelDetails[$p]->ticket_id = $data_array['ticket_id'];
                    $modelDetails[$p]->ticket_item_id = $data_array['ticket_item_id'];
                    $modelDetails[$p]->technician_id = $item['technician_id'];
                    $modelDetails[$p]->job_start_time = date("Y-m-d H:i:s");
                    $modelDetails[$p]->job_end_time = '0';
                    $valid = $valid && $modelDetails[$p]-> validate();
                }
            }
            if($valid){
                if(!empty($modelDetails)){
                    foreach ($modelDetails as $eachModel) 
                    {
                        $eachModel->save();
                    }
                }
                $data['id'] = $model->id;
                $data['status'] = 'success';

            } else {
                $data['status'] = 'error';
                $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
                $error = array_merge_recursive($error2);
                foreach($error as $a=>$eacherror){
                    $other[]= $eacherror[0];
                }      
                if ($error != '[]'){
                    $data['msg'] =  $other;
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($data);
    }
    
    public function actionRequestMaterialList()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $ticket_id =(int)$_REQUEST['ticket_id'];
            $ticket_item_id =(int)$_REQUEST['ticket_item_id'];
            //$ticket_id = '2';
            //$ticket_item_id = '4';
            $arr_requested_material = "";
            if ($ticket_id > 0) 
            {
                $model  = new TicketRequestMaterials();
                $condition = 'ticket_id ="' . $ticket_id.'" AND ticket_item_id ="' . $ticket_item_id . '"';
                
                $model = $model->findAll(array('condition' => $condition));
                $data =[];
                if(!empty($model))
                {
                    foreach ($model as $key => $row) 
                    {
                        $arr_room[$key] = [
                        "id" => $row['id'],
                        "description" => $row['description'],
                        "quantity" => $row['quantity'],
                        "unit_id" => $row['unit_id'],
                        "unit_name" => $row['unit_name']
                        ]; 
                    }
                }
                else 
                {
                    $arr_room = [];
                }
                $data= [
                    "request_material_list" => $arr_room
                    ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        //echo '<pre>'; print_r($data);
        echo json_encode($data);
    }
    
    public function actionRequestmaterialsave() 
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        /*if ($userModel->id > 0) 
        {*/
            $data_array = json_decode(file_get_contents('php://input'), true);
            //{"booking_id":"21","visitors":[{"id":"","visitor_name":"Arun","booking_id":"21","mobile_no":"73654777","email_id":"","passport_no":"8768558","address":"-","relation":"FAMILY"},{"id":"","visitor_name":"kiran","booking_id":"21","mobile_no":"076578875","email_id":"","passport_no":"85558","address":"-","relation":"FAMILY"}]}
            $user_id   = $userModel->id;
            $valid=true;
            $model = new TicketHeader;
            if ((int)$data_array['ticket_id'] > 0) {
                $ticket_id =  (int)$data_array['ticket_id'];
                $model = $model->findByPK($ticket_id);
                $valid = $model->validate();
            }
            
            if (is_array($data_array['request_item'])) 
            {
                foreach ($data_array['request_item'] as $p => $item) 
                {
                    if((int)$item['id']>0)
                    {
                        $modelRequestDetails[$p] =  TicketRequestMaterials::model()->findByPK((int)$item['id']);
                    }else{
                        //$modelRequestDetails[$p]->created_by = Yii::app()->user->id;
                        $modelRequestDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                    }
                    $modelRequestDetails[$p]->attributes = $item;
                    $modelRequestDetails[$p]->ticket_id = $data_array['ticket_id'];
                    $modelRequestDetails[$p]->ticket_item_id = $data_array['ticket_item_id'];
                    $modelRequestDetails[$p]->description = $item['description'];
                    $modelRequestDetails[$p]->quantity = $item['quantity'];
                    $modelRequestDetails[$p]->unit_id = $item['unit_id'];
                    //$unit_model=Unit::model()->findByPk((int)$item['unit_id']);
                    $modelRequestDetails[$p]->unit_name = $item['unit_name'];
                    //$modelRequestDetails[$p]->updated_by = Yii::app()->user->id;
                    $modelRequestDetails[$p]->updated_date_time = date("Y-m-d H:i:s");
                    $valid = $valid && $modelRequestDetails[$p]-> validate();
                }
            }
            if($valid){
                if(!empty($modelRequestDetails)) 
                {
                    foreach ($modelRequestDetails as $eachModel) 
                    {
                        $eachModel->save();
                    }
                }
                $data['id'] = $model->id;
                $data['status'] = 'success';

            } else {
                $data['status'] = 'error';
                $error2 = json_decode(CActiveForm::validateTabular($modelRequestDetails, '', false), true);
                $error = array_merge_recursive($error2);
                foreach($error as $a=>$eacherror){
                    $other[]= $eacherror[0];
                }      
                if ($error != '[]'){
                    $data['msg'] =  $other;
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        /*}
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        //echo '<pre>'; print_r($data);
        echo json_encode($data);
    }
    
    public function actionUnitList()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) 
        {
            $model = new Unit();
            $condition = "1=1";
            $model = $model->findAll(array('condition' => $condition));
            $data =[];
            if(!empty($model))
            {
                foreach ($model as $key => $row) 
                {
                    $arr_unit[$key] = [
                    "id" => $row['id'],
                    "unit_name" => $row['unit_name']
                    ]; 
                }
                $data= [
                    "unit_list" => $arr_unit
                    ];
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }
        else
        {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        //echo '<pre>'; print_r($data);
        echo json_encode($data);
    }
           
    
}