<?php 
$cs = Yii::app()->getClientScript();

$cs->registerScript("getTotal", " 
function getTotal() { 
    var qty = $('#FixedAssetRegister_quantity').val().replace(/,/g,'');
    var rate = $('#FixedAssetRegister_rate').val().replace(/,/g,'');

    var tot = Number(qty) * Number(rate);
    tot = Number(tot).toFixed(2);

    $('#FixedAssetRegister_total_value').val(tot);
    $('#FixedAssetRegister_current_book_value').val(tot); // hidden field
    $('#FixedAssetRegister_current_book_value').trigger('input');

    var master_id = $('#FixedAssetRegister_master_id').val();

    jQuery.ajax({
        dataType:'json',
        data:{master_id:master_id},
        type:'post',
        url: '" . Yii::app()->createUrl('fixedasset/register/getDepreciation') . "',
        cache:false,
        success:function(data){
            if(data.status=='success'){
                var month=data.val;
                if(month>0){
                    var depreciation_val = Number(tot/month).toFixed(2);
                    $('#FixedAssetRegister_monthly_depreciation').val(depreciation_val);
                    $('#FixedAssetRegister_monthly_depreciation').addClass('filled');
                }
            }
        }
    });
}
", CClientScript::POS_HEAD);


$cs->registerScript("getDetails", " 
function getDetails(val){
    jQuery.ajax({
        dataType:'json',
        data:{master_id:val},
        type:'post',
        url:'" . Yii::app()->createUrl('fixedasset/register/getMasterDetails') . "',
        cache:false,
        success:function(data){
            if(data.status=='success'){
                var no = data.val;
                $('#FixedAssetRegister_part_no').val(no).addClass('filled');
                $('#FixedAssetRegister_serial_no').val(no).addClass('filled');
            }
        }
    });
}
", CClientScript::POS_HEAD);


$cs->registerScript("autoDepEndDate_fixed", "
(function(){
    window.deprMonths = null;

    function parseDMY(str){
        if(!str) return null;
        var p = str.split('/');
        if(p.length!=3) return null;
        return new Date(p[2], p[1]-1, p[0]);
    }

    function formatDMY(dt){
        return ('0'+dt.getDate()).slice(-2) + '/' +
               ('0'+(dt.getMonth()+1)).slice(-2) + '/' +
               dt.getFullYear();
    }

    function addMonthsEOM(date, months){
        let d = date.getDate();
        let newDate = new Date(date.getFullYear(), date.getMonth()+months, d);
        if(newDate.getDate() < d){
            newDate.setDate(0);
        }
        return newDate;
    }

    function updateDepEndDate(){
        var startStr = $('#FixedAssetRegister_depreciation_start_date').val();
        var startDt = parseDMY(startStr);
        var months = window.deprMonths;
        if(!startDt || !months) return;

        let endDt = addMonthsEOM(startDt, months);
        endDt.setDate(endDt.getDate() - 1);
        $('#FixedAssetRegister_depr_date').val(formatDMY(endDt)).addClass('filled');
    }

    $('#FixedAssetRegister_master_id').change(function(){
        window.deprMonths = null;
        updateDepEndDate();
        var mid = $(this).val();
        if(mid){
            jQuery.ajax({
                dataType:'json',
                type:'post',
                data:{master_id:mid},
                url:'" . Yii::app()->createUrl('fixedasset/register/getDepreciation') . "',
                success:function(data){
                    if(data.status=='success'){
                        window.deprMonths = Number(data.val);
                        updateDepEndDate();
                    }
                }
            });
        }
    });

    $('#FixedAssetRegister_depreciation_start_date').on('change blur', updateDepEndDate);

})();
", CClientScript::POS_HEAD);

$cs->registerScript("commaFormatting", "
function formatWithComma(selector){
    $(document).on('input', selector, function(){
        if ($('body').hasClass('no-format')) return;
        let value = $(this).val().replace(/,/g, '');
        if(isNaN(value) || value==''){ 
            $(this).val(''); 
            return; 
        }
        let formatted = Number(value).toLocaleString('en-IN');
        $(this).val(formatted);
    });
}
", CClientScript::POS_HEAD);


$cs->registerScript("removeCommaBeforeSubmit", "
$('#bank-form').on('submit', function(){

    // FIXED: remove all commas before validation
    $('#FixedAssetRegister_rate').val(function(i,v){ return v.replace(/,/g,''); });

    // FIXED: ensure CURRENT BOOK VALUE is number
    $('#FixedAssetRegister_current_book_value').val(function(i,v){ 
        return (v+'').replace(/,/g,''); 
    });

});
", CClientScript::POS_END);


$cs->registerScript("applyFormatting", "
$(function(){
    formatWithComma('#FixedAssetRegister_rate');
});
", CClientScript::POS_END);


$cs->registerScript("removeCommaOnBlur", "
$('#FixedAssetRegister_rate').on('blur', function(){
    var v = $(this).val().replace(/,/g,'');
    $(this).val(v);
});
");
?>

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'bank-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">

            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>             
                <?php echo $form->dropdownlist($model, 'master_id',
                    FixedAssetMaster::getAllMaster(),
                    array('class'=>'tooltipster','data-label'=>'Type *','prompt'=>'--select--','onchange'=>'getDetails(this.value)')
                ); ?>
            </li>

            <li class="col-sm-3">
                <?php 
                $purchase_date = ($model->purchase_date!='') ? date('d/m/Y', strtotime($model->purchase_date)) : date('d/m/Y');
                echo $form->textField($model,'purchase_date',array('data-label'=>'Purchase Date *','class'=>'datepicker','value'=>$purchase_date)); ?>
            </li>

            <li class="col-sm-3">
                <?php
                $start_date = ($model->depreciation_start_date!='') ? date('d/m/Y', strtotime($model->depreciation_start_date)) : date('d/m/Y');
                echo $form->textField($model,'depreciation_start_date',array('data-label'=>'Depreciation Start Date *','class'=>'datepicker','value'=>$start_date)); ?>
            </li>

            <li class="col-sm-3">
                <?php 
                $depr_date = ($model->depr_date!='') ? date('d/m/Y', strtotime($model->depr_date)) : date('d/m/Y');
                echo $form->textField($model,'depr_date',array('data-label'=>'Depreciation End Date','readonly'=>true,'value'=>$depr_date));
                echo $form->hiddenField($model, 'depr_last_date'); 
                ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->textField($model,'part_no',array('data-label'=>'Fixed Asset No *','readonly'=>true)); ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->textField($model,'description',array('data-label'=>'Description *')); ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->textField($model,'serial_no',array('data-label'=>'Serial No')); ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->hiddenField($model,'quantity',array('value'=>1)); ?>

                <?php echo $form->textField($model,'rate',array(
                    'data-label'=>'Purchasing Rate',
                    'class'=>'text-right',
                    'onkeypress'=>'return isNumberKey(event)',
                    'onkeyup'=>'getTotal()'
                )); ?>

                <?php echo $form->hiddenField($model,'total_value',array('readonly'=>true)); ?>

                <?php echo $form->hiddenField($model,'current_book_value'); // FIXED ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->textField($model,'location',array('data-label'=>'Location')); ?>
            </li>

            <li class="col-sm-3">
                <?php echo $form->textArea($model,'notes',array('data-label'=>'Notes')); ?>
            </li>

        </ul>
    </div>
</div>

<div class="modal-footer">
<button type="button" class="btn btn-default" id="bank_close" data-dismiss="modal">Close</button>

<?php
if(!isset($type) && $type!="V"){
$url = Yii::app()->createUrl('fixedasset/Register/Save');
echo CHtml::ajaxSubmitButton('Save', $url, array(
    'dataType'=>'json',
    'type'=>'post',
    'beforeSend'=><<<JS
function(){
    $('body').addClass('no-format');

    $('#FixedAssetRegister_rate').val(function(i,v){ return v.replace(/,/g,''); });
    $('#FixedAssetRegister_current_book_value').val(function(i,v){ return v.replace(/,/g,''); });

    $("#loader").show();
    $(".toast8-error").hide(); 
    $("#bank-form .bank-save-btn").prop("disabled", true);
    $("#bank-form .bank-save-btn").addClass("btn_loding").removeClass("btn-theme");
}
JS
,
    'success'=>'function(data){
        $("body").removeClass("no-format");
        $("#loader").hide();
        if(data.status=="success"){  
             t8.success("Asset Saved Successfully!");
             $("#bank_close").click();
             reloadTable("#tbl_register_fixed_asset_details");
        } else { 
            $("#bank-form .bank-save-btn").prop("disabled", false)
                .addClass("btn-theme").removeClass("btn_loding");

            $.each(data, function(key, val){
                t8.error(""+val+""); 
            });
        } 
    }',
), array('id'=>'mybtn'.rand(),'class'=>'bank-save-btn btn btn-theme'));
}
?>

</div>

<?php $this->endWidget(); ?>
