<script>
    $(document).ready(function () {
        var table_id = "#tbl_master_fixed_asset_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fixedasset/default/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        });
    });

    function AddContextMenu(row, datas) {
        // Build menu items dynamically
        var menuItems = {};

        <?php if (isset(Yii::app()->user->havePermissionOn['fixed_asset_master_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            menuItems.edit = {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    loadPopupModal(
                        "fixedasset/default/create&id=" + datas[5].id,
                        "Edit Fixed Asset Type",
                        "x1"
                    );
                }
            };
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['fixed_asset_master_delete']) || Yii::app()->user->authorised_user == 1) { ?>
            //     menuItems.delete = {
            //  name: "Delete",
            //     icon: "delete",
            //     accesskey: "d",
            //     callback: function () {
            //         var r = confirm('Are you sure to delete this?');
            //         if (r == true){
            //             jQuery.ajax({
            //                 'type'  : 'post',
            //                 'data'  : 'id=' + datas[5].id,
            //                 'url'  : $('#liveSite').val()+'index.php?r=fixedasset/default/DeleteFixedAssetMaster',
            //                 'cache': false,
            //                 'success':function(data){
            //                     if(data == 'failure'){
            //                         t8.error('An error occured. Please try agian');
            //                     } else {
            //                         t8.success('Fixed asset deleted successfully');
            //                         reloadTable("#tbl_master_fixed_asset_details");
            //                     }
            //                 }
            //             });
            //         }
            //     }
            //  };
            // <?php } ?>

        // Attach context menu only if at least one item exists
        if (Object.keys(menuItems).length > 0) {
            $(row).contextMenu({
                selector: 'td',
                items: menuItems
            });
        }
    }
</script>


<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-dollar"></i> -->
        Fixed Assets Type
        <div class="top_controls_select col-sm-8 pull-right">
            <div class="col-sm-1 pull-right">
                <?php if (isset(Yii::app()->user->havePermissionOn['fixed_asset_master_add']) || Yii::app()->user->authorised_user == 1) { ?>
                    <a class="ad-btn"
                        onclick="loadPopupModal('fixedasset/default/create','Add New Master Fixed Asset','xl')" title="Add">
                        <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
                            class="pluss-ad">
                            <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                            <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                            <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round" />
                        </svg>
                    </a>
                <?php } ?>
            </div>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_master_fixed_asset_details">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Dep.(in months)</th>
                        <th>Dep.%(Per Year)</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>