<?php

class DefaultController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'SaveMasterFixedAsset', 'GetList', 'DeleteFixedAssetMaster'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        //setting the layout as the fixed asset module layout
        $this->layout='layout';
        $this->render('index');
    }

    // action to create master fixed asset form
    public function actionCreate(){
        $model = new FixedAssetMaster();
        if (!empty($_GET['id'])) {
            $model = $model->findByPk($_GET['id']);
            $disabled = array(
                                'starting_series_number' => 1,
                            );
        }else{
            $disabled = array(
                                'starting_series_number' => 0,
                            );
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('masterfixedasset', array('model' => $model, 'disabled' => $disabled), false, false);
    }

    // action to save master fixed assets
    public function actionSaveMasterFixedAsset(){
        $model = new FixedAssetMaster();
        if (isset($_POST['FixedAssetMaster'])) {
            try{
                $type = (!empty($_POST['FixedAssetMaster']['id'])) ? 'UPDATES' : 'SAVE';
                if ($type == 'UPDATES') $audit_type = 'UPDATED'; // audit log changes
                else $audit_type = 'CREATED'; // audit log changes
                if (!$this->isDuplicate($_POST['FixedAssetMaster'], $type)){
                    //condition to check for update
                     if (!empty($_POST['FixedAssetMaster']['id'])){
                        $model = $model->findByPk($_POST['FixedAssetMaster']['id']); 
                        $model->updated_by = Yii::app()->user->id;
                        $model->updated_date_time = date('Y-m-d h:i:s');
                    }else{
                        $model->created_by = Yii::app()->user->id;
                        $model->created_date_time = date('Y-m-d h:i:s');
                        $model->starting_series_number = $_POST['FixedAssetMaster']['starting_series_number']; 
                    }
                    $model->fixed_asset_name = $_POST['FixedAssetMaster']['fixed_asset_name'];
                    $model->description = $_POST['FixedAssetMaster']['description'];
                    $model->depreciation_period = $_POST['FixedAssetMaster']['depreciation_period'];
                    $model->depreciating_debit_account = $_POST['FixedAssetMaster']['depreciating_debit_account'];
                    $model->depreciating_credit_account = $_POST['FixedAssetMaster']['depreciating_credit_account'];
                    $model->isActive = 1;
                
                    if ($model->save()){

                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'FIXED_ASSET_MASTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with Master No: - {$model->id}  "
                        );
                        // end audit log 

                        // creating json response
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['masterfixedasset'];
                        $jsonData['id'] = $model->id;
                        echo CJSON::encode($jsonData);
                    }else{
                        // check for validation errors from the form and displaying the errors back
                        echo CActiveForm::validate($model);
                    }
                }else{
                    $jsonData['msg'] = 'Fixed asset already exist with same name or series number';
                    echo CJSON::encode($jsonData);
                }
            }catch(\yii\db\Exception $e){
                $jsonData['msg'] = "An error occured. Please try again";
                echo CJSON::encode($jsonData);
            }
        }
    }

    // action to get list of master fixed assets
    public function actionGetList() {
        $model = new FixedAssetMaster();
        $num = 0;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'fixed_asset_name',
            2 => 'depreciation_period',
            3 => '',
        );
        $filterColumn = (!empty($columns[$_POST['order'][0]['column']])) ? $columns[$_POST['order'][0]['column']] : 'fixed_asset_name';
        $filterOrder = (!empty($_POST['order'][0]['dir'])) ? $_POST['order'][0]['dir'] : 'asc';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="1"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (fixed_asset_name LIKE '%" . $searchString . "%' OR id LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {
            $div = '';
            $rowData[] = array(
                ++$num,
                $row['fixed_asset_name'],
                $row['depreciation_period'],
                number_format(100/($row['depreciation_period']/12), 2, '.', ''),
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'],'depreciation_period'=>$row['depreciation_period']),);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    //action to delete fixed asset
    public function actionDeleteFixedAssetMaster(){
        $id = $_POST['id'];
        $model = new FixedAssetMaster();
        try {
            $model->deleteByPk($id);

            // inserting to audit log
            AuditLog::saveAuditLogs(
                'FIXED_ASSET_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with Master No: - {$id}  "
            );
            // end audit log

            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } catch (\yii\db\Exception $e) {
            $jsonData['status'] = 'failure';
            echo CJSON::encode($jsonData);
        }
    }

    //check for duplicates for fixed asset master
    private function isDuplicate($request, $type){
        if ($type == 'SAVE'){
            $fixed_asset = Yii::app()->db->createCommand()
                                            ->select('id')
                                            ->from('erp_fixed_asset_master as fm')
                                            ->where('fm.fixed_asset_name = :name or fm.starting_series_number = :num', array(':name' => $request['fixed_asset_name'], ':num' => $request['starting_series_number']))
                                            ->queryRow();
        }
        if ($type == 'UPDATES'){
            $fixed_asset = Yii::app()->db->createCommand()
                                            ->select('id')
                                            ->from('erp_fixed_asset_master as fm')
                                            ->where('fm.id <> :id and (fm.fixed_asset_name = :name or fm.starting_series_number = :num)', array(':name' => $request['fixed_asset_name'], ':id' => $request['id'], ':num' => $request['starting_series_number']))
                                            ->queryRow();
        }
        if(!empty($fixed_asset)) return true;
        else return false; 
    }

}
