<style type="text/css">
    .align-right {
        text-align: right;
        max-width: 80px
    }
</style>
<script>
    $(document).ready(function () {
        var table_id = "#tbl_depreciate_aggregate_details";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            columnDefs: [
                {
                    targets: [2],
                    className: 'align-right'
                }
            ],
            order: [[0, "asc"], [1, "asc"]],
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fixedasset/depreciate/GetListAggregate') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }

        });
    });

    function AddContextMenu(row, datas) {
        $(row).contextMenu({
            selector: "td",
            items: {
                <?php if (isset(Yii::app()->user->havePermissionOn['aggregate_edit']) || Yii::app()->user->authorised_user == 1) { ?>
                "edit": {
                        name: "View",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                            // loadPopupModal('fixedasset/register/CreateSerialize&id=' + datas[8].id, 'Edit', 'xl');
                        }
                    }
            <?php } ?>
            }
        });
    }


</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!-- <i class="fa fa-plus"></i> -->
        Aggregate of Fixed Assets Depreciated
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_depreciate_aggregate_details">
                <thead>
                    <tr>
                        <th>Month</th>
                        <th>Fixed Asset Type</th>
                        <th> Depreciated Book Value </th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>