<?php
class FixedAssetMaster extends CActiveRecord {

    public function tableName() {
        return '{{fixed_asset_master}}';
    }   

    public function rules()
    {
        return array(
                        array('fixed_asset_name, depreciation_period, depreciating_debit_account, depreciating_credit_account, starting_series_number', 'required'),
                        // array('starting_series_number', 'numerical'),
                        array('depreciation_period', 'numerical'),
                        array('id,fixed_asset_name, depreciation_period, depreciating_debit_account, depreciating_credit_account, starting_series_number', 'safe', 'on' => 'search'),
        );
    }
    public function search()
	{
		$criteria = new CDbCriteria;
		$criteria->compare('id', $this->id);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
    }
    public static function model($className=__CLASS__)
	{
	return parent::model($className);
    }
    public static function getAllMaster(){
    $model=FixedAssetMaster::model()->findAll(array('order'=>'fixed_asset_name'));
	return CHtml::listData($model, 'id', 'fixed_asset_name');
	}
}
