<?php

class RegisterController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'SaveRegisterFixedAsset',
                    'GetList',
                    'DeleteFixedAssetMaster',
                    'GetInvoiceFromPurchase',
                    'CreateSerialize',
                    'GetSerialNumber',
                    'GetDepreciation',
                    'save',
                    'GetMasterDetails',
                    'PostRegister',
                    'UnPostRegister',
                    'Sold',
                    'Scrap',
                    'SaveSold',
                    'SaveScrap',
                    'createDepreciation',
                    'SaveDepreciateData',
                    'DepreciateDataMonth'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        //setting the layout as the fixed asset module layout
        $this->layout = 'layout';
        $this->render('index');
    }

    // action to create master fixed asset form
    public function actionCreate()
    {
        $model = new FixedAssetRegister();
        $id = $_GET['id'];
        $type = $_GET['type'];
        if (!empty($id)) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'type' => $type), false, false);
    }

    // action to create master fixed asset form
    public function actionCreateSerialize()
    {
        $model = new FixedAssetRegister();
        if (!empty($_GET['id'])) {
            $model = $model->findByPk($_GET['id']);
            $type = 'UPDATES';
        } else {
            $type = 'CREATES';
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render(
            'serialize',
            array(
                'model' => $model,
                'master_fixed_asset' => new FixedAssetMaster(),
                'product_id' => $_GET['product_id'],
                'invoice' => $_GET['invoice'],
                'purchase_order' => $_GET['purchase_order'],
                'qty' => $_GET['qty'],
                'rate' => $_GET['rate'],
                'type' => $type
            ),
            false,
            false
        );
    }
    public function actionSave()
    {
        if (isset($_POST['FixedAssetRegister'])) {
            $model = new FixedAssetRegister();
            $id = $_POST['FixedAssetRegister']['id'];
            if ($id > 0) {
                $audit_type = 'UPDATED';
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['FixedAssetRegister'];
            // $model->monthly_depreciation=round(($model->quantity*$model->rate/$model->master->depreciation_period),2);
            if (!empty($model->master->depreciation_period) && $model->master->depreciation_period > 0) {
                $model->monthly_depreciation = round(((float) $model->quantity * (float) $model->rate) / (float) $model->master->depreciation_period, 2);
            } else {
                $model->monthly_depreciation = 0; // or handle differently if you need an error flag
            }


            // $model->daily_depreciation=round(($model->monthly_depreciation/30),2);
            if (!empty($model->monthly_depreciation)) {
                $model->daily_depreciation = round(((float) $model->monthly_depreciation / 30), 2);
            } else {
                $model->daily_depreciation = 0;
            }
            $model->purchase_date = (count(explode('/', $_POST['FixedAssetRegister']['purchase_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['purchase_date']))) : date('Y-m-d');
            $model->depreciation_start_date = (count(explode('/', $_POST['FixedAssetRegister']['depreciation_start_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['depreciation_start_date']))) : date('Y-m-d');
            $model->depr_date = (count(explode('/', $_POST['FixedAssetRegister']['depr_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['depr_date']))) : "date('Y-m-d')";
            $model->depr_last_date = (count(explode('/', $_POST['FixedAssetRegister']['depr_last_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['depr_last_date']))) : "0000-00-00";
            if ($model->master->depreciation_period > 0 && $model->depr_date != "0000-00-00" && $model->depr_last_date == "0000-00-00")
                $model->depr_last_date = date('Y-m-d', strtotime($model->depr_date . "" . $model->master->depreciation_period . " months"));
            /////////////////////////////////////////////////////////////////////////////
//      $val1 =  number_format(100/($model->master->depreciation_period/12), 2, '.', '');
//     $daily_dep  = (($val1*$model->total_value)/100)/365;

            //     $current_date = date("Y-m-d");  // e.g. 2025-09-01
//   // $depr_date    =  $row['depr_date'];
//     $start_date   = $row['depreciation_start_date'];
//     $datetime1 = new DateTime($start_date);
//     //$datetime3 = new DateTime($depr_date);
//     $datetime2 = new DateTime($current_date);
//     //$interval = $datetime1->diff($datetime3);  
//     $intervall = $datetime1->diff($datetime2);  
//     //$days = (int)($interval->days);
//     $un_days = (int)($intervall->days);
//     //$days_depr =   $row['depr_value'];//$days* number_format($daily_dep,3);
//     $days_depr2 = $un_days* number_format($daily_dep,3);
//     $model->undepr_value = $days_depr2;

            //////////////////////////////////////////////////////////////////////////////


            if ($model->save()) {
                if ($audit_type == 'CREATED') {
                    $master = FixedAssetMaster::model()->findByPk($model->master_id);
                    $master->last_number = $model->part_no;
                    $master->save(false);
                }
                Depreciate::model()->deleteAll(array('condition' => 'fixed_asset_register=' . $model->id));
                $max = $model->current_book_value / $model->monthly_depreciation;
                $last_date = $model->depreciation_start_date;
                for ($i = 0; $i < $max; $i++) {
                    $depreciation = new Depreciate();
                    $date = new DateTime($last_date);
                    if ($i != 0) {
                        $date->modify('+1 month');
                    }
                    $depreciation->depreciated_date = $date->format('Y-m-d');
                    $depreciation->depreciation_amount = $model->monthly_depreciation;
                    $depreciation->fixed_asset_register = $model->id;
                    $depreciation->save(false);
                    $last_date = $depreciation->depreciated_date;
                }
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'FIXED_ASSET_REGISTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with register No: - {$model->id}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    // action to save fixed assets register
    public function actionSaveRegisterFixedAsset()
    {
        if (isset($_POST['FixedAssetRegister'])) {
            try {
                $type = (!empty($_POST['FixedAssetRegister']['id'])) ? 'UPDATES' : 'SAVE';
                if ($type == 'SAVE') {
                    $audit_type = 'CREATED'; // audit log changes
                    for ($i = 0; $i < (int) $_POST['FixedAssetRegister']['qty']; $i++) {
                        $model = new FixedAssetRegister();
                        $model->created_by = Yii::app()->user->id;
                        $model->created_at = date('Y-m-d h:i:s');
                        $model->isActive = 1;
                        $serial_number = $this->actionGetSerialNumber('array', $_POST['FixedAssetRegister']['fixed_asset_master_number']);
                        if (!empty($serial_number['series_number']))
                            $model->fixed_asset_register_number = $serial_number['series_number'];
                        else
                            $model->fixed_asset_register_number = $serial_number['existing_series_number'] + 1;
                        $model->description = $_POST['FixedAssetRegister']['description'];
                        $model->fixed_asset_master_number = $_POST['FixedAssetRegister']['fixed_asset_master_number'];
                        $model->depreciation_start_date = date("Y-m-d h:i", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['depreciation_start_date'])));
                        $model->current_book_value = $_POST['FixedAssetRegister']['rate'];

                        if ($model->save()) {
                            // inserting to audit log
                            AuditLog::saveAuditLogs(
                                'FIXED_ASSET_REGISTER',
                                Yii::app()->user->id,
                                $audit_type,
                                " with register No: - {$model->id}  "
                            );
                            // end audit log 
                            $jsonData['status'] = 'success';
                        } else {
                            // check for validation errors from the form and displaying the errors back
                            echo CActiveForm::validate($model);
                            exit;
                        }
                    }
                }

                if ($type == 'UPDATES') {
                    $audit_type = 'UPDATED'; // audit log changes
                    $model = new FixedAssetRegister();
                    $model = $model->findByPk($_POST['FixedAssetRegister']['id']);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_at = date('Y-m-d h:i:s');
                    $model->description = $_POST['FixedAssetRegister']['description'];
                    $model->location = $_POST['FixedAssetRegister']['location'];
                    $model->department = $_POST['FixedAssetRegister']['department'];
                    $model->used_by = $_POST['FixedAssetRegister']['used_by'];
                    $model->serial_number = $_POST['FixedAssetRegister']['serial_number'];
                    if ($model->save()) {
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'FIXED_ASSET_REGISTER',
                            Yii::app()->user->id,
                            $audit_type,
                            " with register No: - {$model->id}  "
                        );
                        // end audit log
                        $jsonData['status'] = 'success';
                    } else {
                        // check for validation errors from the form and displaying the errors back
                        echo CActiveForm::validate($model);
                    }
                }
                echo CJSON::encode($jsonData);

            } catch (\yii\db\Exception $e) {
                $jsonData['msg'] = "An error occured. Please try again";
                echo CJSON::encode($jsonData);
            }
        }
    }

    // action to get list of fixed asset register
    public function actionGetList()
    {
        $model = new FixedAssetRegister();
        $num = 0;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            0 => 'purchase_date',
        );
        //sort by fixest_asset_id
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        //sort by fixed asset type
        $filterColumn2 = $columns[$_POST['order'][1]['column']];
        $filterOrder2 = $_POST['order'][1]['dir'];
        $condition = '1=1';
        $orderBy = $filterColumn . " " . $filterOrder . "," . $filterColumn2 . " " . $filterOrder2;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (part_no LIKE '%" . $searchString . "%' OR description LIKE '%" . $searchString . "%' OR serial_no LIKE '%" . $searchString . "%' OR location LIKE '%" . $searchString . "%'))";
        }
        $registers = FixedAssetRegister::model()->with('master')->findAll(array('condition' => $condition));
        $count = count($registers);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $div = '';
        $m = 1;
        foreach ($registers as $row) {
            $div = '<div class="btn-wrap text-center">';
            // //if((Yii::app()->user->havePermissionOn['fixed_asset_master_edit'] ||  Yii::app()->user->authorised_user == 1) && $row->posted=="N" && $row->active=="Y")
            // {
            // $div .= ' <button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'fixedasset/register/Create&id=' . $row['id'] . '\',\'' . $row['part_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            // }
            // //if((Yii::app()->user->havePermissionOn['fixed_asset_master_edit'] ||  Yii::app()->user->authorised_user == 1) && $row->posted=="Y" && $row->active=="Y")
            // {
            // $div .= ' <button class="btn btn-primary btn-xs" title ="Sold" onclick="loadPopupModal(\'fixedasset/register/Sold&id=' . $row['id'] . '\',\'' . $row['part_no'].'\',\'xl\')"><i class="fa fa-dollar"></i></button>';
            // }
            // //if((Yii::app()->user->havePermissionOn['fixed_asset_master_edit'] ||  Yii::app()->user->authorised_user == 1) && $row->posted=="Y" && $row->active=="Y")
            // {
            // $div .= ' <button class="btn btn-primary btn-xs" title ="Scrap" onclick="loadPopupModal(\'fixedasset/register/Scrap&id=' . $row['id'] . '\',\'' . $row['part_no'].'\',\'xl\')"><i class="fa fa-trash"></i></button>';
            // }
            // //if((Yii::app()->user->havePermissionOn['fixed_asset_master_edit'] ||  Yii::app()->user->authorised_user == 1) && $row->posted=="N" && $row->active=="Y")
            // {
            // $div .= ' <button class="btn btn-primary btn-xs" title ="Post" onclick="post(' . $row['id'] . ')"><i class="fa fa-send"></i></button>';
            // }
            // //if((Yii::app()->user->havePermissionOn['fixed_asset_master_edit'] ||  Yii::app()->user->authorised_user == 1) && $row->posted=="Y" && $row->active=="Y")
            // {
            // $div .= ' <button class="btn btn-primary btn-xs" title ="Unpost" onclick="unpost(' . $row['id'] . ')"><i class="fa fa-retweet"></i></button>';
            // }
            if ($row->posted == "Y" && $row->active == "SO") {
                $div .= ' <button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'fixedasset/register/Create&id=' . $row['id'] . '\',\'' . $row['part_no'] . '\',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            //if ($row->posted == "N" && $row->active == "Y") {
            $div .= ' <button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'fixedasset/register/Create&id=' . $row['id'] . '\',\'' . $row['part_no'] . '\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            //}

            if ($row->posted == "Y" && $row->active == "Y") {
                $div .= ' <button class="btn btn-primary btn-xs" title="Sold" onclick="loadPopupModal(\'fixedasset/register/Sold&id=' . $row['id'] . '\',\'' . $row['part_no'] . '\',\'xl\')"><i class="fa fa-dollar"></i></button>';
            }

            if ($row->posted == "Y" && $row->active == "Y") {
                $div .= ' <button class="btn btn-primary btn-xs" title="Scrap" onclick="loadPopupModal(\'fixedasset/register/Scrap&id=' . $row['id'] . '\',\'' . $row['part_no'] . '\',\'xl\')"><i class="fa fa-trash"></i></button>';
            }

            if ($row->posted == "N" && $row->active == "Y") {
                $div .= ' <button class="btn btn-primary btn-xs" title="Post" onclick="post(' . $row['id'] . ')"><i class="fa fa-send"></i></button>';
            }

            if ($row->posted == "Y" && $row->active == "Y") {
                $div .= ' <button class="btn btn-primary btn-xs" title="Unpost" onclick="unpost(' . $row['id'] . ')"><i class="fa fa-retweet"></i></button>';
            }

            $div .= '</div>';
            $days = 0;
            $val1 = number_format(100 / ($row->master->depreciation_period / 12), 2, '.', '');
            $daily_dep = (($val1 * $row['total_value']) / 100) / 365;

            $current_date = date("Y-m-d");  // e.g. 2025-09-01
            $depr_date = '';
            $start_date = $row['depreciation_start_date'];
            $datetime1 = new DateTime($start_date);
            $datetime3 = new DateTime($depr_date);
            $datetime2 = new DateTime($current_date);
            $interval = $datetime1->diff($datetime3);
            $intervall = $datetime1->diff($datetime2);
            $days = (int) ($interval->days);
            $un_days = (int) ($intervall->days);
            $days_depr = 0;//$days* number_format($daily_dep,3);
            $days_depr2 = $un_days * number_format($daily_dep, 3);
            $undepr_value = $days_depr2 - $days_depr;
            $cbv = $row['total_value'] - $days_depr;
            $depr_last_date = $row['depr_last_date'];
            $depr_last_date = date('d/m/Y', strtotime($row['depr_last_date']));
            if ($row->master->depreciation_period > 0 && $row['depr_last_date'] == "0000-00-00") {
                $depr_last_date = date('Y-m-d', strtotime($row['depr_date'] . "" . $row->master->depreciation_period . " months"));
                $depr_last_date = date('d/m/Y', strtotime($depr_last_date));
            }
            $depr_date = "";
            $depr_date = $row['depr_check_date'];
            $depr_date = date('d/m/Y', strtotime($row['depr_check_date']));
            if ($row->master->depreciation_period > 0 && $row['depr_check_date'] == "0000-00-00") {
                $depr_date = date('Y-m-d', strtotime($row['depreciation_start_date'] . "" . $row->master->depreciation_period . " months"));
                $depr_date = date('d/m/Y', strtotime($depr_date));
            }
            $rowData[] = array(
                $m,//$row->id,
                date('d/m/Y', strtotime($row['purchase_date'])),
                date('d/m/Y', strtotime($row['depreciation_start_date'])),
                $row->master->fixed_asset_name,
                // $row['part_no'],
                $row['description'],
                $row['serial_no'],
                $row['location'],
                number_format($daily_dep, 3),
                Yii::app()->numberFormatter->formatCurrency($row['total_value'], ''),
                number_format($days_depr, 3),
                $depr_date,//date('d/m/Y', strtotime($row['depr_date'])),
                $depr_last_date,
                number_format($undepr_value, 3),
                round($row['current_depr_value'], 3),
                Yii::app()->numberFormatter->formatCurrency($cbv, ''),
                // $row->posted,
                // $row->active,
                $div,
                $row->posted,
                $row->active
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetSerialNumber($type = 'null', $param = 'null')
    {

        if ($param == 'null')
            $param = $_GET['fixed_asset_name'];

        $fixed_asset = Yii::app()->db->createCommand()
            ->select('max(fixed_asset_register_number) as number')
            ->from('erp_fixed_asset_register as fr')
            ->where('fr.fixed_asset_master_number = :number', array(':number' => $param))
            ->queryRow();
        if (empty($fixed_asset['number'])) {
            $fixed_asset = Yii::app()->db->createCommand()
                ->select('starting_series_number as number, starting_series_number as starting_number')
                ->from('erp_fixed_asset_master')
                ->where('id = :number', array(':number' => $param))
                ->queryRow();
        }
        if ($type == 'null') {
            echo CJSON::encode($fixed_asset);
        } else {
            return array(
                'existing_series_number' => $fixed_asset['number'],
                'series_number' => $fixed_asset['starting_number'],
            );
        }
    }

    public function getPurchaseOrders()
    {
        $purchase_orders = Yii::app()->db->createCommand()
            ->select('file_id')
            ->from('erp_purchasinginvoice')
            ->where('isActive = :active', array(':active' => 'Y'))
            ->queryAll();
        foreach ($purchase_orders as $purchase_order) {
            $purchase_order_dropdown[] = array('purchase_id' => $purchase_order['file_id'], 'purchase_values' => $purchase_order['file_id']);
        }
        return $purchase_order_dropdown;
    }

    public function actionGetInvoiceFromPurchase()
    {
        $invoices = Yii::app()->db->createCommand()
            ->select('epi.id, epi.file_id, epi.vendor_name, epii.description, epii.quantity, epii.rate, epi.invoice_date, es.part_number, epii.product_id')
            ->from('erp_purchasinginvoice as epi')
            ->join('erp_purchasinginvoice_item as epii', 'epi.id = epii.purchasing_invoice_id')
            ->join('erp_store as es', 'epii.product_id = es.id')
            ->where("epi.isActive = :active and epi.file_id = :purchase_order", array(':active' => 'Y', ':purchase_order' => $_GET['purchase_order']))
            ->queryAll();
        $purchase_order = $_GET['purchase_order'];
        foreach ($invoices as $key => $invoice) {
            foreach ($this->getFixedAssetRegister("and er.purchase_order = $purchase_order ") as $proid) {
                if ($proid['product_id'] == $invoice['product_id'])
                    unset($invoices[$key]);
            }
        }
        $invoice_data = array_values($invoices);
        echo CJSON::encode($invoice_data);
    }

    private function getFixedAssetRegister($condition = null, $limit = null, $offset = null, $orderBy = null)
    {
        if ($limit == null && $offset == null && $orderBy == null) {
            $purchase_orders = Yii::app()->db->createCommand()
                ->selectDistinct('er.product_id')
                ->from('erp_fixed_asset_register as er')
                ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                ->join('erp_purchasinginvoice_item as ei', 'er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id')
                ->join('erp_store as es', 'er.product_id = es.id')
                ->where("er.isActive = :active $condition", array(':active' => 'Y'))->order($orderBy)
                ->queryAll();
        } else {
            $purchase_orders = Yii::app()->db->createCommand()
                ->select('er.id, er.fixed_asset_register_number,er.invoice_id, er.product_id, er.serial_number, er.current_book_value ,er.depreciation_start_date, er.description, em.fixed_asset_name, ei.rate, es.part_number')
                ->from('erp_fixed_asset_register as er')
                ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                ->join('erp_purchasinginvoice_item as ei', 'er.invoice_id = ei.purchasing_invoice_id and er.product_id = ei.product_id')
                ->join('erp_store as es', 'er.product_id = es.id')
                ->where("er.isActive = :active $condition", array(':active' => 'Y'))
                ->limit($limit)
                ->offset($offset)
                ->order($orderBy)
                ->queryAll();
        }

        return $purchase_orders;
    }

    public function actionGetDepreciation()
    {
        $master_id = $_POST['master_id'];
        if ($master_id > 0) {
            $master = FixedAssetMaster::model()->findByPk($master_id);
            $month = $master->depreciation_period;
            $jsonData['val'] = $month;
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    // public function actionGetMasterDetails()
    // {
    // $master_id=$_POST['master_id'];
    // if($master_id>0)
    // {
    // $master=FixedAssetMaster::model()->findByPk($master_id);
    // $last=$master->last_number;
    // $number=preg_replace("/[^0-9]{1,4}/", '', $last);
    // // $no=$number+1;
    // $no = (float)$number + 1;

    // $string=str_replace($number,$no,$last);
    // $jsonData['val'] = $string;
    // $jsonData['status'] = 'success';
    // echo CJSON::encode($jsonData);    
    // }
    // }
    public function actionGetMasterDetails()
    {
        $master_id = (int) $_POST['master_id'];
        if ($master_id > 0) {
            $master = FixedAssetMaster::model()->findByPk($master_id);
            $last = $master->last_number;

            if (!empty($last)) {
                // Extract numeric part from last_number
                $number = preg_replace("/[^0-9]/", '', $last);
                $no = (float) $number + 1;
                $string = str_replace($number, $no, $last);
            } else {
                // If no last_number, take starting_series_number + 1
                $no = (float) $master->starting_series_number + 1;
                $string = $no; // if you need prefix/suffix, adjust here
            }

            $jsonData = [
                'val' => $string,
                'status' => 'success'
            ];
            echo CJSON::encode($jsonData);
        }
    }


    public function actionPostRegister()
    {

        function isPostable($date)
        {
            $last_closed_year = AccAuditClose::lastClosedDate();
            $voucherYear = date('Y', strtotime($date)); // ✅ Convert full date, take only year
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        $master_id = $_POST['master_id'];
        if ($master_id > 0) {
            $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $master_id));
            $valid = true;
            foreach ($depreciation as $i => $each) {
                $voucherHead[$i]['voucher_no'] = $each->id;
                $voucherHead[$i]['voucher_date'] = $each->depreciated_date;
                $voucherHead[$i]['reference_no'] = 'Depreciation of ' . $each->register->part_no . ' ' . $each->register->description . ' ' . $each->register->serial_no;
                $voucherHead[$i]['transaction_id'] = $each->fixed_asset_register;
                $voucherHead[$i]['amount'] = $each->depreciation_amount;
                $voucherHead[$i]['debit_acc'] = $each->register->master->depreciating_debit_account;
                $voucherHead[$i]['credit_acc'] = $each->register->master->depreciating_credit_account;

                $valid .= isPostable($each->depreciated_date);
            }
            if ($valid && !empty($voucherHead)) {
                foreach ($voucherHead as $eachItem) {
                    $model = new AccVoucher;
                    $model->voucher_type = 19; //Fixed Asset Voucher
                    $model->voucher_no = $eachItem['voucher_no'];
                    $model->voucher_date = $eachItem['voucher_date'];
                    $model->due_date = $eachItem['voucher_date'];
                    $model->transaction_id = $eachItem['transaction_id'];
                    $model->reference_no = $eachItem['reference_no'];
                    $model->amount = $eachItem['amount'];
                    $model->is_posted = 'Y';
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime = date('Y-m-d h:i:s');
                    $model->save(false);
                    //ITEMS
                    $modelItems = new AccVoucherItems;
                    $modelItems->acc_voucher_id = $model->id;
                    $modelItems->ledger_id = $eachItem['debit_acc'];
                    $modelItems->narration = $eachItem['reference_no'];
                    $modelItems->amount = $eachItem['amount'];
                    $modelItems->currency_id = 1;
                    $modelItems->exchange_rate = 1;
                    $modelItems->save(false);
                    //ITEMS
                    $modelItems = new AccVoucherItems;
                    $modelItems->acc_voucher_id = $model->id;
                    $modelItems->ledger_id = $eachItem['credit_acc'];
                    $modelItems->narration = $eachItem['reference_no'];
                    $modelItems->amount = -($eachItem['amount']);
                    $modelItems->currency_id = 1;
                    $modelItems->exchange_rate = 1;
                    $modelItems->save(false);
                }
                $masterRegister = FixedAssetRegister::model()->findByPk($master_id);
                $masterRegister->posted = "Y";
                $masterRegister->save();
                $jsonData['status'] = 'success';
            }
            // else {
            // $jsonData['status'] = 'Please Check Financial Year Closing';
            // }
            echo CJSON::encode($jsonData);
        }
    }

    public function actionUnPostRegister()
    {

        function isUnPostable($date)
        {
            $last_closed_year = AccAuditClose::lastClosedDate();
            $voucherYear = date('Y', strtotime($date));
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        $master_id = $_POST['master_id'];
        if ($master_id > 0) {
            $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $master_id));
            $valid = true;
            foreach ($depreciation as $i => $each) {
                $voucherHead[$i]['voucher_no'] = $each->id;
                $valid .= $valid && isUnPostable($each->depreciated_date);
            }
            if ($valid && !empty($voucherHead)) {
                foreach ($voucherHead as $eachItem) {
                    $vno = $eachItem['voucher_no'];
                    $voucher = AccVoucher::model()->find(array('condition' => 'voucher_type=19 AND voucher_no=' . $vno));
                    AccVoucherItems::model()->deleteAll(array('condition' => 'acc_voucher_id=' . $voucher->id));
                    AccVoucher::model()->deleteByPk($voucher->id);
                }
                $masterRegister = FixedAssetRegister::model()->findByPk($master_id);
                $masterRegister->posted = "N";
                $masterRegister->save();
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'Please Check Financial Year Closing';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actionSold()
    {
        $model = new FixedAssetRegister();
        $id = $_GET['id'];
        if (!empty($id)) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('sold', array('model' => $model), false, false);
    }
    public function actionScrap()
    {
        $model = new FixedAssetRegister();
        $id = $_GET['id'];
        if (!empty($id)) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('scrap', array('model' => $model), false, false);
    }
    public function actionSaveSold()
    {
        function isPostable($date)
        {
            $last_closed_year = AccAuditClose::lastClosedDate();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }
        if (isset($_POST['FixedAssetRegister'])) {
            $model = new FixedAssetRegister();
            $id = $_POST['FixedAssetRegister']['id'];
            if ($id > 0) {
                $audit_type = 'SOLD';
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['FixedAssetRegister'];
            $model->sold_amount = $_POST['FixedAssetRegister']['sold_amount'];
            $model->debit_account = $_POST['FixedAssetRegister']['debit_account'];
            $model->credit_account = $_POST['FixedAssetRegister']['credit_account'];
            $model->active = 'SO';
            $model->inactive_date = (count(explode('/', $_POST['FixedAssetRegister']['inactive_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['inactive_date']))) : date('Y-m-d');
            if ($id > 0) {
                $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $id . ' AND depreciated_date>="' . $model->inactive_date . '"'));
                $valid = true;
                foreach ($depreciation as $i => $each) {
                    $voucherHead[$i]['voucher_no'] = $each->id;
                    $valid .= isPostable($each->depreciated_date);
                }
            }
            if ($valid && $model->validate()) {
                $model->depr_date = $model->inactive_date;
                $model->save();
                $master_id = $model->id;
                //Delete Posting
                if ($master_id > 0) {
                    $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $master_id . ' AND depreciated_date>="' . $model->inactive_date . '"'));
                    $valid = true;
                    foreach ($depreciation as $i => $each) {
                        $voucherHead[$i]['voucher_no'] = $each->id;
                        $valid .= isPostable($each->depreciated_date);
                    }
                    if ($valid && !empty($voucherHead)) {
                        foreach ($voucherHead as $eachItem) {
                            $vno = $eachItem['voucher_no'];
                            $voucher = AccVoucher::model()->find(array('condition' => 'voucher_type=19 AND voucher_no=' . $vno));
                            // AccVoucherItems::model()->deleteAll(array('condition'=>'acc_voucher_id='.$voucher->id));
                            if (!empty($voucher->id)) {
                                AccVoucherItems::model()->deleteAll(
                                    "acc_voucher_id = :vid",
                                    array(":vid" => (int) $voucher->id)
                                );
                            }
                            AccVoucher::model()->deleteByPk($voucher->id);
                            Depreciate::model()->deleteByPk($eachItem['voucher_no']);
                        }
                        $modelHead = new AccVoucher;
                        $modelHead->voucher_type = 20; //Fixed Asset Voucher
                        $modelHead->voucher_no = $model->id;
                        $modelHead->voucher_date = $model->inactive_date;
                        $modelHead->due_date = $model->inactive_date;
                        $modelHead->transaction_id = $model->id;
                        $modelHead->reference_no = 'Depreciation of ' . $model->part_no . ' ' . $model->description . ' ' . $model->serial_no;
                        $modelHead->amount = $model->sold_amount;
                        $modelHead->is_posted = 'Y';
                        $modelHead->created_by = Yii::app()->user->id;
                        $modelHead->created_datetime = date('Y-m-d h:i:s');
                        $modelHead->save(false);
                        //ITEMS
                        $modelItems = new AccVoucherItems;
                        $modelItems->acc_voucher_id = $modelHead->id;
                        $modelItems->ledger_id = $model->debit_account;
                        $modelItems->narration = 'Depreciation of ' . $model->part_no . ' ' . $model->description . ' ' . $model->serial_no;
                        $modelItems->amount = $model->sold_amount;
                        $modelItems->currency_id = 1;
                        $modelItems->exchange_rate = 1;
                        $modelItems->save(false);
                        //ITEMS
                        $modelItems = new AccVoucherItems;
                        $modelItems->acc_voucher_id = $modelHead->id;
                        $modelItems->ledger_id = $model->credit_account;
                        $modelItems->narration = 'Depreciation of ' . $model->part_no . ' ' . $model->description . ' ' . $model->serial_no;
                        $modelItems->amount = -($model->sold_amount);
                        $modelItems->currency_id = 1;
                        $modelItems->exchange_rate = 1;
                        $modelItems->save(false);
                        $jsonData['status'] = 'success';
                    } else {
                        $jsonData['status'] = 'Please Check Financial Year Closing';
                    }
                    echo CJSON::encode($jsonData);
                }
                // End Delete
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'FIXED_ASSET_REGISTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with register No: - {$model->id}  "
                );
                // end audit log 
            } else {
                $error1 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!$valid) {
                    $error2[] = "Please Check Financial Year Closing";
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionSaveScrap()
    {
        function isPostable($date)
        {
            $last_closed_year = AccAuditClose::lastClosedDate();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }
        if (isset($_POST['FixedAssetRegister'])) {
            $model = new FixedAssetRegister();
            $id = $_POST['FixedAssetRegister']['id'];
            if ($id > 0) {
                $audit_type = 'SCRAP';
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['FixedAssetRegister'];
            $model->sold_amount = $_POST['FixedAssetRegister']['sold_amount'];
            $model->debit_account = $_POST['FixedAssetRegister']['debit_account'];
            $model->credit_account = $_POST['FixedAssetRegister']['credit_account'];
            $model->active = 'SC';
            $model->inactive_date = (count(explode('/', $_POST['FixedAssetRegister']['inactive_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['FixedAssetRegister']['inactive_date']))) : date('Y-m-d');
            if ($id > 0) {
                $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $id . ' AND depreciated_date>="' . $model->inactive_date . '"'));
                $valid = true;
                foreach ($depreciation as $i => $each) {
                    $voucherHead[$i]['voucher_no'] = $each->id;
                    $valid .= isPostable($each->depreciated_date);
                }
            }
            if ($valid && $model->validate()) {
                $model->depr_date = $model->inactive_date;
                $model->save();
                $master_id = $model->id;
                //Delete Posting
                if ($master_id > 0) {
                    $depreciation = Depreciate::model()->findAll(array('condition' => 'fixed_asset_register=' . $master_id . ' AND depreciated_date>="' . $model->inactive_date . '"'));
                    $valid = true;
                    foreach ($depreciation as $i => $each) {
                        $voucherHead[$i]['voucher_no'] = $each->id;
                        $valid .= isPostable($each->depreciated_date);
                    }
                    if ($valid && !empty($voucherHead)) {
                        foreach ($voucherHead as $eachItem) {
                            $vno = $eachItem['voucher_no'];
                            $voucher = AccVoucher::model()->find(array('condition' => 'voucher_type=19 AND voucher_no=' . $vno));
                            if (!empty($voucher->id)) {
                                AccVoucherItems::model()->deleteAll(
                                    "acc_voucher_id = :vid",
                                    array(":vid" => (int) $voucher->id)
                                );
                            }
                            AccVoucher::model()->deleteByPk($voucher->id);
                            Depreciate::model()->deleteByPk($eachItem['voucher_no']);
                        }
                        // $modelHead = new AccVoucher;
                        // $modelHead->voucher_type = 20; //Fixed Asset Voucher
                        // $modelHead->voucher_no = $model->id;
                        // $modelHead->voucher_date = $model->inactive_date;
                        // $modelHead->due_date = $model->inactive_date;
                        // $modelHead->transaction_id = $model->id;
                        // $modelHead->reference_no = 'Depreciation of ' . $model->part_no.' '.$model->description.' '.$model->serial_no;
                        // $modelHead->total_voucher_amount= $model->sold_amount;
                        // $modelHead->is_posted = 'Y';
                        // $modelHead->created_by = Yii::app()->user->id;
                        // $modelHead->created_datetime = date('Y-m-d h:i:s');
                        // $modelHead->save(false);
                        // //ITEMS
                        // $modelItems = new FinanceVoucherItems;
                        // $modelItems->header_id = $modelHead->id;
                        // $modelItems->ledger_id = $model->debit_account;
                        // $modelItems->narration = 'Depreciation of ' . $model->part_no.' '.$model->description.' '.$model->serial_no;
                        // $modelItems->amount = $model->sold_amount;
                        // $modelItems->currency_id = 1;
                        // $modelItems->exchange_rate = 1;
                        // $modelItems->save(false); 
                        // //ITEMS
                        // $modelItems = new FinanceVoucherItems;
                        // $modelItems->header_id = $modelHead->id;
                        // $modelItems->ledger_id = $model->credit_account;
                        // $modelItems->narration = 'Depreciation of ' . $model->part_no.' '.$model->description.' '.$model->serial_no;
                        // $modelItems->amount = -($model->sold_amount);
                        // $modelItems->currency_id = 1;
                        // $modelItems->exchange_rate = 1;
                        // $modelItems->save(false); 
                        $jsonData['status'] = 'success';
                    } else {
                        $jsonData['status'] = 'Please Check Financial Year Closing';
                    }
                    echo CJSON::encode($jsonData);
                }
                // End Delete
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'FIXED_ASSET_REGISTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with register No: - {$model->id}  "
                );
                // end audit log 
            } else {
                $error1 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!$valid) {
                    $error2[] = "Please Check Financial Year Closing";
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actioncreateDepreciation()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_depr', array(), false, false);
    }

    public function actionDepreciateDataMonth()
    {

        $modelFixedAsset = FixedAssetRegister::model()->findAll();
        foreach ($modelFixedAsset as $eachRegister) {
            $val1 = number_format(100 / ($eachRegister->master->depreciation_period / 12), 2, '.', '');
            $daily_dep = (($val1 * $eachRegister['total_value']) / 100) / 365;
            $start_date = $eachRegister['depreciation_start_date'];
            $depr_date = '';
            $current_date = date("Y-m-d");
            $datetime1 = new DateTime($start_date);

            $datetime2 = new DateTime($current_date);
            $interval = $datetime1->diff($datetime2);

            $days = (int) ($interval->days);
            $dep_val = $days * number_format($daily_dep, 3);
            $current_depr_value = $eachRegister['current_depr_value'];
            $current_depr_value = $current_depr_value + $dep_val;
            $eachRegister->current_depr_value = $current_depr_value;
            $eachRegister->save(false);
        }

        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
        //}


    }

    // public function actionSaveDepreciateData()
    // {
    //         $modelFixedAsset =array();
    //         $calc_date = (count(explode('/', $_POST['calc_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['calc_date']))) : "0000-00-00";
    //         if (isset($_POST['calc_date']) && $calc_date!="0000-00-00") {
    //         $modelFixedAsset= FixedAssetRegister::model()->findAll();
    //         foreach($modelFixedAsset as $eachRegister)
    //         {
    //             $calc_dep_date = "";
    //             if(strtotime($eachRegister['depr_date'])  <  strtotime($calc_date))
    //             $calc_dep_date = $eachRegister['depr_date'];
    //             else
    //             $calc_dep_date = $calc_date;
    //             ////////////////////////////////////////
    //             $datetime1 = new DateTime($eachRegister['depreciation_start_date']);
    //             $datetime2 = new DateTime($calc_dep_date);
    //             $interval = $datetime1->diff($datetime2); 
    //             $days = (int)($interval->days);
    //             $val1 =  number_format(100/($eachRegister->master->depreciation_period/12), 2, '.', '');
    //             $daily_dep  = (($val1*$eachRegister['total_value'])/100)/365;
    //             $current_depr_value = $days*number_format($daily_dep,3);

    //             $eachRegister->current_depr_value = (float)$current_depr_value;
    //             $eachRegister->depr_last_date = $calc_date;
    //             $eachRegister->depr_check_date = $calc_date;
    //             $eachRegister->save(false);
    //         }

    //         $jsonData['status'] = 'success';
    //         echo CJSON::encode($jsonData);
    //         //}

    //         }    

    // }

    public function actionSaveDepreciateData()
    {
        $calc_date = (count(explode('/', $_POST['calc_date'])) == 3)
            ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['calc_date'])))
            : "0000-00-00";

        if (isset($_POST['calc_date']) && $calc_date != "0000-00-00") {
            $modelFixedAsset = FixedAssetRegister::model()->findAll();

            foreach ($modelFixedAsset as $eachRegister) {

                $calcDate = new DateTime($calc_date);
                $checkDate = new DateTime($eachRegister['depr_check_date']);
                $startDate = new DateTime($eachRegister['depreciation_start_date']);

                $chosenDate = ($calcDate < $checkDate) ? $calcDate : $checkDate;

                if ($chosenDate < $startDate) {
                    $eachRegister->current_depr_value = 0;
                } else {
                    $interval = $startDate->diff($chosenDate);
                    $days = (int) $interval->days;

                    $daily_dep = (float) $eachRegister['daily_depreciation'];
                    $current_depr_value = round($days * $daily_dep, 3);

                    $eachRegister->current_depr_value = $current_depr_value;
                }
                // $eachRegister->depr_last_date = $calc_date;
                // $eachRegister->depr_check_date = $calc_date;

                $eachRegister->save(false);
            }

            echo CJSON::encode(['status' => 'success']);
        }
    }

}
